/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.customcode;

import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.exec.AbstractSparkBasedRecipeRunner;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipeMeta;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipesService;
import com.dataiku.dip.recipes.customcode.LoadedCustomCodeRecipeDesc;
import com.dataiku.dip.recipes.customcode.SparkCustomCodeRecipeParams;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomPysparkRecipeRunner
extends AbstractSparkBasedRecipeRunner {
    @Autowired
    private CustomCodeRecipesService service;
    @Autowired
    private JobAuthCtxService authCtxService;
    private static Logger logger = Logger.getLogger((String)"dku.flow.python");
    private LoadedCustomCodeRecipeDesc desc;

    public CustomPysparkRecipeRunner(JobActivity activity) {
        super(activity);
        this.desc = ((CustomCodeRecipeMeta)RecipeRegistry.getMeta(activity)).getPluginDesc();
    }

    protected File prepareWrapper(File processRunDir) throws Exception {
        String wrapperContent = DKUtils.getResourceFileContentUTF8((String)"com/dataiku/dip/dataflow/exec/python-exec-wrapper.py");
        File wrapperFile = new File(processRunDir, "python-exec-wrapper.py");
        DKUFileUtils.writeFileUTF8((File)wrapperFile, (String)wrapperContent);
        return wrapperFile;
    }

    @Override
    public void run() throws Exception {
        final SparkCustomCodeRecipeParams params = RecipeRegistry.getParamsAs(this.activity, SparkCustomCodeRecipeParams.class);
        CodeEnvSelector envSelector = new CodeEnvSelector();
        String envName = envSelector.getCodeEnvNameForPlugin(this.desc.ownerPluginId);
        this.runPySpark("PySpark", envName, params.executionEngine, new SparkExecutionEnginesHelper.SparkRecipeJobBuilder(){

            @Override
            public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                File tmpScriptData = new File(runDir, "script.py");
                logger.info((Object)("Dumping plugin Pyspark code to " + String.valueOf(tmpScriptData)));
                String pyScriptData = CustomPysparkRecipeRunner.this.service.getCode(CustomPysparkRecipeRunner.this.desc.recipeType);
                DKUFileUtils.writeFileUTF8((File)tmpScriptData, (String)pyScriptData);
                File wrapperFile = CustomPysparkRecipeRunner.this.prepareWrapper(runDir);
                T job = helper.makePyJob("DSS (Py): " + CustomPysparkRecipeRunner.this.activity.id(), effectiveConf, wrapperFile.getAbsolutePath(), tmpScriptData.getAbsolutePath());
                ((SparkJob)job).secretDriverFiles.add(tmpScriptData.getAbsolutePath());
                return job;
            }

            @Override
            public SparkOverrideConfig getRecipeOverrideConf() {
                return params.sparkConfig;
            }

            @Override
            public Map<String, String> getContextOverrideConf() {
                return new HashMap<String, String>();
            }
        }, GeneralSettingsDAO.CGrouppableProcessType.PYTHON_R_SPARK_RECIPE);
        this.activity.setAllSourcesCompletelyRead();
        this.activity.fillTargetWrittenSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Done");
    }

    @Override
    protected EnvironmentStash prepareEnvStash(File tmpDir, Map<String, String> extraEnv, ContainerExecRuntimeConfig containerConfig, String envName) throws IOException, SQLException, CodedException, DKUSecurityException, InterruptedException {
        EnvironmentStash stash = super.prepareEnvStash(tmpDir, extraEnv, containerConfig, envName);
        SparkCustomCodeRecipeParams params = RecipeRegistry.getParamsAs(this.activity, SparkCustomCodeRecipeParams.class);
        stash.fillForPlugin(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), containerConfig, params, this.desc, this.service);
        stash.fillForCustomPythonRecipe(this.desc, this.service);
        return stash;
    }

    @Override
    public void init() throws Exception {
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Initializing");
    }
}

