/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.download;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.utils.FlowVariables;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.download.DownloadRecipeParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.KernelsDownloadRecipeService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Maps;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class DownloadRecipeRunner
implements FlowRunnable,
RecipeRunner {
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private KernelsDownloadRecipeService kernelsDownloadRecipeService;
    private final JobActivity activity;
    private final RecipeRunnableSubgraph subgraph;
    private final FlowRecipe recipe;
    protected DownloadRecipeParams params;
    static Logger logger = Logger.getLogger((String)"dku.flow.recipe.download");

    public DownloadRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = this.subgraph.getRecipe();
        this.activity.initStatus();
    }

    @Override
    public void init() throws Exception {
        this.activity.setStatusMessage("Initializing");
        this.params = (DownloadRecipeParams)JSON.deepCopy((Object)RecipeRegistry.getParamsAs(this.activity, DownloadRecipeParams.class));
    }

    @Override
    public void run() throws Exception {
        String partitionPrefix;
        FlowManagedFolder flowManagedFolder = (FlowManagedFolder)this.recipe.getSuccessors().get(0);
        ManagedFolder managedFolder = flowManagedFolder.getManagedFolder();
        AuthCtx authCtx = this.authCtxService.getAuthCtx();
        HashMap flowVariables = Maps.newHashMap();
        if (managedFolder.getPartitioningSchema().isPartitioned()) {
            Partition targetPartition = this.activity.getSubgraph().getTargetPartition(flowManagedFolder);
            if (!FilePartitioner.isSchemeRepresentableAsFolder(managedFolder.getPartitioningSchema())) {
                throw new Exception("The partitioning scheme of the target cannot be represented as folders");
            }
            partitionPrefix = FilePartitioner.computePartitionRelPathAsFolder(targetPartition, managedFolder.getPartitioningSchema());
            FlowVariables.addVariablesForDstDataset(authCtx, flowVariables, managedFolder, targetPartition, "DKU_DST_");
        } else {
            partitionPrefix = "";
        }
        this.activity.setStatusMessage("Downloading from sources...");
        this.kernelsDownloadRecipeService.copyFromSourcesToFolder(managedFolder, partitionPrefix, this.recipe.getProjectKey(), authCtx, this.params, false, flowVariables);
        this.activity.setAllSourcesCompletelyRead();
        this.activity.setStatusMessage("Done");
    }
}

