/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.common.doc_extraction.chunks;

import com.dataiku.dip.docextraction.Content;
import com.dataiku.dip.docextraction.StructuredContentDTO;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.docextraction.common.chunks.TextFirstExtractionChunk;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocumentPageRange;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.ExtractedMetadata;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.MultimodalContent;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.SourceFile;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class RuleChunk {
    public abstract String getTextValue();

    public abstract String toJson();

    @Nullable
    public abstract MultimodalContent getMultimodalValue();

    public abstract ExtractedMetadata getGeneratedMetadata(InputRefs.ManagedFolderDocumentRef var1);

    public static class Structured
    extends RuleChunk {
        public String text;
        public List<String> outline;
        public Content parentStructure;
        public Content.PageRange pageRange;

        public Structured() {
        }

        public Structured(TextFirstExtractionChunk chunk) {
            this.text = chunk.fullContent;
            this.outline = chunk.outline;
            this.parentStructure = chunk.parentStructure;
            this.pageRange = chunk.pageRange;
        }

        public static Structured buildFromExtractionChunk(TextFirstExtractionChunk chunk) {
            if (chunk.imageRef != null) {
                return new Image(chunk);
            }
            return new Structured(chunk);
        }

        @Override
        public String getTextValue() {
            return this.text;
        }

        @Override
        public String toJson() {
            if (this.parentStructure != null) {
                StructuredContentDTO dto = this.parentStructure.toDTO(true);
                JsonObject obj = JSON.toJsonObject((Object)dto, (String[])new String[0]);
                ArrayList parentOutline = this.outline == null || this.outline.size() <= 1 ? new ArrayList() : this.outline.subList(0, this.outline.size() - 1);
                obj.add("outline", (JsonElement)JSON.toJsonArray(parentOutline));
                return obj.toString();
            }
            return "";
        }

        @Override
        public MultimodalContent getMultimodalValue() {
            return new MultimodalContent.Text(this.getTextValue());
        }

        @Override
        public ExtractedMetadata getGeneratedMetadata(InputRefs.ManagedFolderDocumentRef sourceDocument) {
            SourceFile sourceFileMetadata = new SourceFile(sourceDocument.managedFolderId, sourceDocument.filePath);
            ExtractedMetadata metadata = new ExtractedMetadata();
            metadata.sourceFile = sourceFileMetadata;
            if (this.outline != null) {
                metadata.sectionOutline = this.outline.stream().map(s -> StringUtils.stripEnd((String)StringUtils.stripEnd((String)StringUtils.strip((String)s, (String)"#"), (String)"="), (String)"-").trim()).toList();
            }
            if (this.pageRange != null && this.pageRange.start != null && this.pageRange.end != null) {
                metadata.pageRange = new DocumentPageRange(this.pageRange.start, this.pageRange.end);
            }
            return metadata;
        }

        public void prependOutlineToText(boolean prependFullOutlineToEachChunksPriorSplitting) {
            if (this.outline != null && !this.outline.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                if (!prependFullOutlineToEachChunksPriorSplitting) {
                    builder.append(this.outline.get(this.outline.size() - 1)).append("\n");
                } else {
                    this.outline.forEach(level -> builder.append((String)level).append("\n"));
                }
                this.text = builder.append(StringUtils.isNotBlank((String)this.text) ? this.text : "").toString();
            }
        }

        public static List<Structured> skipEmptySectionsAndPrependOutlineIfNeeded(List<Structured> chunks, boolean prependFullOutline) {
            boolean keepEmptySections = !prependFullOutline;
            List<Structured> filteredChunks = chunks.stream().filter(chunk -> keepEmptySections || StringUtils.isNotBlank((String)chunk.getTextValue())).toList();
            filteredChunks.forEach(chunk -> chunk.prependOutlineToText(prependFullOutline));
            return filteredChunks;
        }

        public static class Image
        extends Structured {
            public String caption;
            public InputRefs.SingleImageRef imageRef;

            public Image() {
            }

            public Image(TextFirstExtractionChunk chunk) {
                super(chunk);
                this.caption = chunk.caption;
                this.imageRef = chunk.imageRef;
            }

            @Override
            public MultimodalContent getMultimodalValue() {
                InputRefs.SingleManagedFolderImageRef mfRef;
                block5: {
                    block4: {
                        InputRefs.SingleImageRef singleImageRef;
                        if (this.imageRef == null || !((singleImageRef = this.imageRef) instanceof InputRefs.SingleManagedFolderImageRef)) break block4;
                        mfRef = (InputRefs.SingleManagedFolderImageRef)singleImageRef;
                        if (!StringUtils.isBlank((String)mfRef.path)) break block5;
                    }
                    return super.getMultimodalValue();
                }
                if (this.caption == null || this.caption.isEmpty()) {
                    return new MultimodalContent.Image(Collections.singletonList(mfRef.path));
                }
                return new MultimodalContent.CaptionedImage(this.caption, Collections.singletonList(mfRef.path));
            }
        }
    }

    public static class Raw
    extends RuleChunk {
        public String text;
        public Content parentStructure;
        public Content.PageRange pageRange;

        public Raw() {
        }

        public Raw(TextFirstExtractionChunk chunk) {
            this.text = chunk.fullContent;
            this.parentStructure = chunk.parentStructure;
            this.pageRange = chunk.pageRange;
        }

        public static Raw buildFromExtractionChunk(TextFirstExtractionChunk chunk) {
            return new Raw(chunk);
        }

        @Override
        public String getTextValue() {
            return this.text;
        }

        @Override
        public String toJson() {
            if (this.parentStructure != null) {
                StructuredContentDTO dto = this.parentStructure.toDTO(true);
                JsonObject obj = JSON.toJsonObject((Object)dto, (String[])new String[0]);
                return obj.toString();
            }
            return "";
        }

        @Override
        public MultimodalContent.Text getMultimodalValue() {
            return new MultimodalContent.Text(this.getTextValue());
        }

        @Override
        public ExtractedMetadata getGeneratedMetadata(InputRefs.ManagedFolderDocumentRef sourceDocument) {
            SourceFile sourceFileMetadata = new SourceFile(sourceDocument.managedFolderId, sourceDocument.filePath);
            ExtractedMetadata metadata = new ExtractedMetadata();
            metadata.sourceFile = sourceFileMetadata;
            if (this.pageRange != null && this.pageRange.start != null && this.pageRange.end != null) {
                metadata.pageRange = new DocumentPageRange(this.pageRange.start, this.pageRange.end);
            }
            return metadata;
        }
    }
}

