/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.visualsql;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.filter.GrelExpression;
import com.dataiku.dip.dataflow.exec.h2.DatasetToH2Loader;
import com.dataiku.dip.dataflow.exec.h2.H2DB;
import com.dataiku.dip.dataflow.exec.h2.H2dbFactory;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetSparkInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.GrelToQueryMapping;
import com.dataiku.dip.expressions.GrelToQueryTranslator;
import com.dataiku.dip.expressions.GrelTranslator;
import com.dataiku.dip.hadoop.HadoopFlavorUtils;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.common.BigQueryRecipeEngineHelper;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeEngineParams;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.ServiceUtils;
import com.dataiku.dip.sql.DummySQLDialect;
import com.dataiku.dip.sql.H2V2SQLDialect;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualSQLRecipesBaseService {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected H2dbFactory h2dbFactory;
    private static final Logger logger = Logger.getLogger((String)"dku.recipes.visualsql");

    public SQLBasedEngineStatus makeHiveEngineStatus(AuthCtx authCtx, JobActivity activity, AppConfig appConfig) throws Exception {
        SQLBasedEngineStatus ret = new SQLBasedEngineStatus("HIVE", "Hive", null, null, "Hive");
        ret.description = "Run on Hive";
        ret.canEngineAppend = false;
        ret.canAnalyticalFunctions = true;
        ret.canDeduplicateJoinMatches = true;
        ret.expectLongRecipeStatusComputation = true;
        ret.doNotSupportLeadLagWithWindow = true;
        ret.lowercasesColumnNames = true;
        HiveSQLDialect dialect = new HiveSQLDialect();
        ret.identifierQuotingCharacter = dialect.getIdentifierQuoteChar();
        ret.stringQuotingCharacter = dialect.getStringQuoteChar();
        ret.aggregabilities = dialect.getAggregationAbilities();
        boolean isInstalled = appConfig.hiveEnabled;
        if (!isInstalled) {
            ret.isSelectable = false;
            ret.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
            ret.statusMessage = "Hive not found";
        } else {
            ServiceUtils.EngineUsability engineUsability = ServiceUtils.canHive(authCtx, activity, this.datasetsDAO);
            ret.isSelectable = engineUsability.canUse();
            if (!ret.isSelectable) {
                ret.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                ret.statusMessage = engineUsability.getReason();
            } else {
                ret.recommended = true;
            }
        }
        return ret;
    }

    public SQLBasedEngineStatus makeImpalaEngineStatus(AuthCtx authCtx, JobActivity activity, AppConfig appConfig) throws Exception {
        SQLBasedEngineStatus ret = new SQLBasedEngineStatus("IMPALA", "Impala", null, null, "Impala");
        ret.description = "Run on Impala";
        ret.canNonEquiJoin = true;
        ret.canAnalyticalFunctions = true;
        ret.canDeduplicateJoinMatches = true;
        ImpalaSQLDialect dialect = new ImpalaSQLDialect();
        ret.identifierQuotingCharacter = dialect.getIdentifierQuoteChar();
        ret.stringQuotingCharacter = dialect.getStringQuoteChar();
        ret.aggregabilities = dialect.getAggregationAbilities();
        ret.lowercasesColumnNames = true;
        boolean isInstalled = appConfig.impalaEnabled;
        if (!isInstalled) {
            ret.isSelectable = false;
            ret.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
            ret.statusMessage = "Impala not found";
        } else {
            ServiceUtils.EngineUsability engineUsability = ServiceUtils.canImpala(authCtx, activity, this.datasetsDAO);
            ret.isSelectable = engineUsability.canUse();
            if (!ret.isSelectable) {
                ret.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                ret.statusMessage = engineUsability.getReason();
            }
        }
        return ret;
    }

    public SQLBasedEngineStatus makeSparkSQLEngineStatus(AuthCtx authCtx, String projectKey) throws Exception {
        return this.makeSparkSQLEngineStatus(authCtx, projectKey, "SPARK_SQL", "Spark SQL");
    }

    public SQLBasedEngineStatus makeSparkSQLEngineStatus(AuthCtx authCtx, String projectKey, String variantSpark, String variantLabel) throws Exception {
        SQLBasedEngineStatus ret = new SQLBasedEngineStatus("SPARK", "Spark", variantSpark, variantLabel, "Spark");
        ret.description = "Run on Spark";
        ret.canNonEquiJoin = true;
        ret.canDeduplicateJoinMatches = true;
        ret.canAnalyticalFunctions = true;
        ret.canStddevAsAnalyticalFunctions = true;
        ret.lowercasesColumnNames = false;
        ret.canEngineAppend = false;
        SparkSQLDialect dialect = new SparkSQLDialect();
        ret.identifierQuotingCharacter = dialect.getIdentifierQuoteChar();
        ret.stringQuotingCharacter = dialect.getStringQuoteChar();
        ret.aggregabilities = dialect.getAggregationAbilities();
        SparkSettings sparkSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getSparkSettings();
        if (!sparkSettings.sparkEnabled) {
            ret.isSelectable = false;
            ret.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
            ret.statusMessage = "Spark not found";
        } else {
            ret.useNativeProcessors = sparkSettings.useNativeProcessors;
            ret.isSelectable = true;
        }
        return ret;
    }

    public SQLDialect getDialect(AuthCtx authCtx, JobActivity activity, RecipeEngineStatus engineStatus) throws IOException, SQLException, DKUSecurityException {
        return this.getDialect(authCtx, activity, engineStatus, false);
    }

    public SQLDialect getDialect(AuthCtx authCtx, JobActivity activity, RecipeEngineStatus engineStatus, boolean useTargetDataset) throws IOException, SQLException, DKUSecurityException {
        boolean queryBased = false;
        if (engineStatus instanceof SQLBasedEngineStatus) {
            queryBased = ((SQLBasedEngineStatus)engineStatus).queryBased;
        }
        return this.getDialect(authCtx, activity, engineStatus.type, queryBased, useTargetDataset);
    }

    private SQLDialect getDialect(AuthCtx authCtx, JobActivity activity, String engineType, boolean queryBased, boolean useTargetDataset) throws IOException, SQLException, DKUSecurityException {
        Preconditions.checkNotNull((Object)engineType, (Object)"Engine type not specified");
        switch (engineType) {
            case "HIVE": {
                return new HiveSQLDialect();
            }
            case "IMPALA": {
                return new ImpalaSQLDialect();
            }
            case "SPARK": {
                return new SparkSQLDialect();
            }
            case "DSS": {
                if (queryBased) {
                    return new H2V2SQLDialect();
                }
                return null;
            }
            case "SQL": {
                SQLDialect dialect = null;
                if (useTargetDataset) {
                    dialect = this.getDialectFromSQLDatasetsUnsafe(authCtx, activity.getSubgraph().getTargetsDatasets());
                }
                if (dialect == null) {
                    dialect = this.getDialectFromSQLDatasetsUnsafe(authCtx, activity.getSubgraph().getSourceDatasets());
                }
                return dialect;
            }
        }
        return null;
    }

    private SQLDialect getDialectFromSQLDatasetsUnsafe(AuthCtx authCtx, List<FlowDataset> datasets) throws IOException, SQLException, DKUSecurityException {
        if (datasets.isEmpty()) {
            return null;
        }
        Dataset dataset = datasets.get(0).getMandatoryUnsafe(this.datasetsDAO);
        if (!DatasetInspector.isSQLAbleAndSQLTable(authCtx, dataset)) {
            return null;
        }
        AbstractSQLConnection conn = DatasetInspector.getDSSConnectionUnsafeForSQLAbleDatasetOrHive(authCtx, dataset);
        return conn.getDialect();
    }

    public SQLBasedEngineStatus makeSQLEngineStatus(AuthCtx authCtx, JobActivity activity) throws Exception {
        SQLBasedEngineStatus ret = new SQLBasedEngineStatus("SQL", "SQL", "IN_DB", "In Database", "In-database (SQL)");
        ret.description = "Run in database";
        ret.lowercasesColumnNames = false;
        ServiceUtils.EngineUsability sqlUsability = ServiceUtils.canSQL(authCtx, activity, this.datasetsDAO);
        ret.isSelectable = sqlUsability.canUse();
        if (!ret.isSelectable) {
            ret.markAsNonSelectable(sqlUsability.getReason(), RecipeEngineStatus.WarningLevel.ERROR);
        } else {
            SQLDialect dialect = this.getDialect(authCtx, activity, "SQL", false, false);
            if (dialect != null) {
                ret.identifierQuotingCharacter = dialect.getIdentifierQuoteChar();
                ret.stringQuotingCharacter = dialect.getStringQuoteChar();
                ret.canAnalyticalFunctions = dialect.canSQL99();
                ret.canStddevAsAnalyticalFunctions = dialect.canStddevAsAnalyticalFunctions();
                ret.aggregabilities = dialect.getAggregationAbilities();
            }
            ret.canNonEquiJoin = ret.canAnalyticalFunctions;
            ret.canFullOuterJoin = ret.canAnalyticalFunctions;
            ret.canDeduplicateJoinMatches = ret.canAnalyticalFunctions;
            ret.recommended = true;
            DatasetInspector.SQLAbleFlavor flavor = ServiceUtils.getSQLAbleFlavor(authCtx, activity, this.datasetsDAO);
            if (flavor == DatasetInspector.SQLAbleFlavor.ATHENA) {
                ret.label = "Athena";
                ret.description = "Run with Athena and stream back results";
                ret.statusWarnLevel = RecipeEngineStatus.WarningLevel.WARN;
                ret.statusMessage = "Not recommended";
                ret.statusMessageDetails = "Athena is not optimized for data processing, but for querying, and is not recommended for recipes";
            }
        }
        return ret;
    }

    public SQLBasedEngineStatus makeDSSBasedEngineStatus() {
        SQLBasedEngineStatus ret = new SQLBasedEngineStatus("DSS", "DSS", "STREAM", "Stream", "DSS");
        ret.description = "Run on stream";
        ret.isSelectable = true;
        ret.canDeduplicateJoinMatches = false;
        ret.canDistinctSelect = true;
        ret.canFullOuterJoin = false;
        ret.canNonEquiJoin = true;
        ret.queryBased = false;
        ret.canStddevAsAnalyticalFunctions = true;
        ret.canAnalyticalFunctions = true;
        ret.aggregabilities.put(SQLAggregateType.MIN, new SQLAggregateAbility(true, true, true, true));
        ret.aggregabilities.put(SQLAggregateType.MAX, new SQLAggregateAbility(true, true, true, true));
        ret.aggregabilities.put(SQLAggregateType.COUNT, new SQLAggregateAbility(true, true, true, true));
        ret.aggregabilities.put(SQLAggregateType.DISTINCT, new SQLAggregateAbility(true, true, true, true));
        ret.aggregabilities.put(SQLAggregateType.SUM, new SQLAggregateAbility(false, true, true, true));
        ret.aggregabilities.put(SQLAggregateType.CONCAT, new SQLAggregateAbility(true, true, true, true));
        ret.aggregabilities.put(SQLAggregateType.CONCAT_DISTINCT, new SQLAggregateAbility(true, true, true, true));
        ret.aggregabilities.put(SQLAggregateType.AVG, new SQLAggregateAbility(false, true, true, true));
        ret.aggregabilities.put(SQLAggregateType.STDDEV, new SQLAggregateAbility(false, true, true, true));
        ret.aggregabilities.put(SQLAggregateType.FIRST, new SQLAggregateAbility(true, true, true, true));
        ret.aggregabilities.put(SQLAggregateType.LAST, new SQLAggregateAbility(true, true, true, true));
        ret.aggregabilities.put(SQLAggregateType.FIRST_NOTNULL, new SQLAggregateAbility(true, true, true, true));
        ret.aggregabilities.put(SQLAggregateType.LAST_NOTNULL, new SQLAggregateAbility(true, true, true, true));
        ret.aggregabilities.put(SQLAggregateType.RETRIEVE, new SQLAggregateAbility(true, true, true, true));
        ret.aggregabilities.put(SQLAggregateType.LEAD, new SQLAggregateAbility(true, true, true, true));
        ret.aggregabilities.put(SQLAggregateType.LAG, new SQLAggregateAbility(true, true, true, true));
        ret.aggregabilities.put(SQLAggregateType.LEAD_DIFF, new SQLAggregateAbility(false, true, true, true));
        ret.aggregabilities.put(SQLAggregateType.LAG_DIFF, new SQLAggregateAbility(false, true, true, true));
        H2V2SQLDialect dialect = new H2V2SQLDialect();
        ret.identifierQuotingCharacter = dialect.getIdentifierQuoteChar();
        ret.stringQuotingCharacter = dialect.getStringQuoteChar();
        ret.lowercasesColumnNames = false;
        return ret;
    }

    public static void h2ModeOn(SQLBasedEngineStatus dssStatus, boolean shouldWarnUser, String warningMessage, String warningMessageDetails) {
        dssStatus.queryBased = true;
        dssStatus.canAnalyticalFunctions = false;
        dssStatus.variant = "DISK_COPY";
        dssStatus.variantLabel = "Disk copy";
        dssStatus.aggregabilities = new H2V2SQLDialect().getAggregationAbilities();
        if (shouldWarnUser) {
            dssStatus.setStatus(warningMessage, RecipeEngineStatus.WarningLevel.WARN);
            dssStatus.statusMessageDetails = warningMessageDetails;
        }
    }

    private void addEngines(AuthCtx authCtx, JobActivity activity, RecipeStatus status, String projectKey) throws Exception {
        AppConfig appConfig = this.getAppConfig(authCtx, projectKey);
        Dataset outputDataset = this.getOutputDataset(activity);
        SQLBasedEngineStatus dss = this.makeDSSBasedEngineStatus();
        status.engines.add(dss);
        SQLBasedEngineStatus inDatabase = this.makeSQLEngineStatus(authCtx, activity);
        status.engines.add(inDatabase);
        SQLBasedEngineStatus hive = this.makeHiveEngineStatus(authCtx, activity, appConfig);
        BigQueryRecipeEngineHelper.disableEngineForBigQuery(hive, outputDataset);
        status.engines.add(hive);
        SQLBasedEngineStatus impala = this.makeImpalaEngineStatus(authCtx, activity, appConfig);
        BigQueryRecipeEngineHelper.disableEngineForBigQuery(impala, outputDataset);
        status.engines.add(impala);
        SQLBasedEngineStatus spark = this.makeSparkSQLEngineStatus(authCtx, projectKey);
        status.engines.add(spark);
    }

    public void initEngines(AuthCtx authCtx, JobActivity activity, VisualSQLRecipeStatus status, String projectKey) throws Exception {
        this.addEngines(authCtx, activity, status, projectKey);
        for (RecipeEngineStatus engine : status.engines) {
            if (status.isInvalid()) {
                RecipeEngineStatus.setErrorStatus("Invalid recipe settings", engine);
                continue;
            }
            if (!engine.recommended || !"DSS".equals(engine.type)) continue;
            RecipeEngineStatus.setWarningStatus("Stream (slow)", engine);
        }
    }

    public AppConfig getAppConfig(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        AppConfig config = new AppConfig();
        config.hiveEnabled = HiveConfigurator.hiveAvailable(authCtx, projectKey);
        config.impalaEnabled = ImpalaConfigurator.impalaAvailable(authCtx, projectKey);
        SparkSettings sparkSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getSparkSettings();
        config.sparkEnabled = sparkSettings.sparkEnabled;
        return config;
    }

    public static void basicCheckComputedColumns(List<ComputedColumn> computedColumns, RecipeStatus.StepStatus stepStatus, SQLDialect dialect) {
        if (computedColumns != null && !computedColumns.isEmpty()) {
            for (int i = 0; i < computedColumns.size(); ++i) {
                ComputedColumn compCol = computedColumns.get(i);
                int line = i + 1;
                VisualSQLRecipesBaseService.checkComputedColumn(stepStatus, compCol, line, dialect);
            }
        }
    }

    private static void checkComputedColumn(RecipeStatus.StepStatus stepStatus, ComputedColumn compCol, int line, SQLDialect dialect) {
        if (dialect == null) {
            dialect = new DummySQLDialect();
        }
        if (StringUtils.isBlank((String)compCol.name)) {
            stepStatus.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_COMPUTED_COLUMN, (String)"Computed column has an empty name").withPos(line, 0));
        } else if (!dialect.isValidIdentifier(compCol.name)) {
            stepStatus.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_COMPUTED_COLUMN, (String)("Computed column name '" + compCol.name + "' is invalid")).withPos(line, 0));
        }
        try {
            Type.forName((String)compCol.type);
        }
        catch (IllegalArgumentException e) {
            stepStatus.addMessage(InfoMessage.fatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_COMPUTED_COLUMN, (String)("Computed column '" + compCol.name + "' has an unknown type: " + compCol.type), (Object[])new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)}).withPos(line, 0));
        }
        if (compCol.type == null) {
            stepStatus.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_COMPUTED_COLUMN, (String)("Computed column '" + compCol.name + "' has an unknown type")).withPos(line, 0));
        }
        if (compCol.mode == null) {
            stepStatus.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_COMPUTED_COLUMN, (String)("Computed column '" + compCol.name + "' has an unkown mode: null")).withPos(line, 0));
        }
    }

    public void checkComputedColumns(List<ComputedColumn> computedColumns, Schema schema, SQLBasedEngineStatus selectedEngine, SQLDialect dialect, boolean engineMustLowerColumnNames, RecipeStatus.StepStatus stepStatus) {
        if (computedColumns != null && !computedColumns.isEmpty()) {
            HashMap<String, Set<Integer>> ccNames = new HashMap<String, Set<Integer>>();
            HashMap<String, Set<Integer>> ccNamesLowercase = new HashMap<String, Set<Integer>>();
            for (SchemaColumn sc : schema.getColumns()) {
                HashSet<Integer> inputSetLines = new HashSet<Integer>();
                inputSetLines.add(-1);
                ccNames.put(sc.getName(), inputSetLines);
                HashSet<Integer> inputSetLinesLowered = new HashSet<Integer>();
                inputSetLinesLowered.add(-1);
                ccNamesLowercase.put(sc.getName().toLowerCase(), inputSetLinesLowered);
            }
            for (int i = 0; i < computedColumns.size(); ++i) {
                ComputedColumn compCol = computedColumns.get(i);
                int line = i + 1;
                String ccNameLowered = compCol.name.toLowerCase();
                if (!ccNames.containsKey(compCol.name)) {
                    ccNames.put(compCol.name, new HashSet());
                }
                ((Set)ccNames.get(compCol.name)).add(line);
                if (!ccNamesLowercase.containsKey(ccNameLowered)) {
                    ccNamesLowercase.put(ccNameLowered, new HashSet());
                }
                ((Set)ccNamesLowercase.get(ccNameLowered)).add(line);
                VisualSQLRecipesBaseService.checkComputedColumn(stepStatus, compCol, line, dialect);
                this.checkComputedColumnWithEngine(compCol, line, schema, selectedEngine, dialect, stepStatus);
            }
            this.checkDuplicateNames(ccNames, ccNamesLowercase, engineMustLowerColumnNames, stepStatus);
        }
    }

    private void checkDuplicateNames(Map<String, Set<Integer>> ccNames, Map<String, Set<Integer>> ccNamesLowercase, boolean engineMustLowerColumnNames, RecipeStatus.StepStatus stepStatus) {
        Set<Integer> compColsInError = this.checkDuplicateNamesStrictCase(ccNames, stepStatus);
        this.checkDuplicateNamesLowerCase(ccNamesLowercase, engineMustLowerColumnNames, compColsInError, stepStatus);
    }

    private Set<Integer> checkDuplicateNamesStrictCase(Map<String, Set<Integer>> ccNames, RecipeStatus.StepStatus stepStatus) {
        HashSet<Integer> compColsInError = new HashSet<Integer>();
        for (Map.Entry<String, Set<Integer>> entry : ccNames.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            for (int line : entry.getValue()) {
                if (line < 1) continue;
                compColsInError.add(line);
                String message = "Duplicate computed column name '" + entry.getKey() + "'" + (entry.getValue().contains(-1) ? " with input schema" : "");
                stepStatus.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_COMPUTED_COLUMN, (String)message).withPos(line, 0));
            }
        }
        return compColsInError;
    }

    private void checkDuplicateNamesLowerCase(Map<String, Set<Integer>> ccNamesLowercase, boolean engineMustLowerColumnNames, Set<Integer> compColsInError, RecipeStatus.StepStatus stepStatus) {
        for (Map.Entry<String, Set<Integer>> entry : ccNamesLowercase.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            for (int line : entry.getValue()) {
                if (line < 1 || compColsInError.contains(line)) continue;
                String message = "Duplicate case-insensitive name '" + entry.getKey() + "'" + (entry.getValue().contains(-1) ? " with input schema" : "");
                InfoMessage msg = engineMustLowerColumnNames ? InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_COMPUTED_COLUMN, (String)message) : InfoMessage.warning((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_COMPUTED_COLUMN, (String)message);
                msg.withPos(line, 0);
                stepStatus.addMessage(msg);
            }
        }
    }

    private void checkComputedColumnWithEngine(ComputedColumn compCol, int line, Schema schema, SQLBasedEngineStatus selectedEngine, SQLDialect dialect, RecipeStatus.StepStatus stepStatus) {
        if ("DSS".equals(selectedEngine.type) && !selectedEngine.queryBased) {
            if (compCol.mode == ComputedColumn.Mode.SQL) {
                stepStatus.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_COMPUTED_COLUMN, (String)("Computed column '" + compCol.name + "' uses an incompatible mode '" + String.valueOf((Object)compCol.mode) + "' for engine type (" + selectedEngine.type + ")")).withPos(line, 0));
            } else {
                if (compCol.expr == null || StringUtils.isBlank((String)compCol.expr)) {
                    stepStatus.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_COMPUTED_COLUMN, (String)("Computed column '" + compCol.name + "' has an empty formula")).withPos(line, 0));
                    return;
                }
                try {
                    Expression expression = new Expression(compCol.expr, schema);
                    if (expression.requirePreviousRows()) {
                        String errorMsg = "Offset argument for val/strval/numval is not available in this context.";
                        stepStatus.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_COMPUTED_COLUMN, (String)("Computed column '" + compCol.name + "' has an invalid expression: " + errorMsg)).withPos(line, 0));
                    }
                }
                catch (IllegalArgumentException e) {
                    stepStatus.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_COMPUTED_COLUMN, (String)("Computed column '" + compCol.name + "' has an invalid expression '" + compCol.expr + "': " + ExceptionUtils.getMessageWithCauses((Throwable)e))).withPos(line, 0));
                }
            }
        } else {
            try {
                QueryGenerationUtils.getComputedColumnExpr(compCol, dialect, schema);
            }
            catch (IllegalArgumentException e) {
                stepStatus.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_COMPUTED_COLUMN, (String)ExceptionUtils.getMessageWithCauses((Throwable)e)).withPos(line, 0));
            }
        }
    }

    public String checkFilter(FilterDesc filterDesc, @Nullable Dataset inputDataset, SQLDialect dialect, RecipeStatus.StepStatus stepStatus, boolean translateFully) {
        logger.info((Object)("check filter translateFully=" + translateFully + " filterDesc=" + JSON.log((Object)filterDesc)));
        String filterSQLExpression = null;
        if (filterDesc != null && filterDesc.enabled) {
            if (dialect == null) {
                dialect = new DummySQLDialect();
                translateFully = false;
                logger.info((Object)"translateFully -> false");
            }
            try {
                if (inputDataset != null) {
                    FilterDescUtils.checkAstWrtSchema(filterDesc, inputDataset.getSchema());
                }
                filterSQLExpression = FilterDescUtils.getSQLExpression(filterDesc, dialect, inputDataset, translateFully);
                this.checkRegexp(filterDesc);
            }
            catch (Exception e) {
                stepStatus.withFatal(RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_FILTER, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        return filterSQLExpression;
    }

    private void checkRegexp(FilterDesc filterDesc) throws Exception {
        if (filterDesc.uiData != null && ("&&".equals(filterDesc.uiData.mode) || "||".equals(filterDesc.uiData.mode))) {
            for (FilterDesc.FilterUiCondition filterUiCond : filterDesc.uiData.conditions) {
                if (filterUiCond.operator == null || FilterDesc.FilterUiOperator.fromRepr((String)filterUiCond.operator) != FilterDesc.FilterUiOperator.REGEX || StringUtils.isEmpty((String)filterUiCond.string)) continue;
                try {
                    Pattern.compile(filterUiCond.string);
                }
                catch (PatternSyntaxException e) {
                    throw new Exception("Invalid regular expression: " + filterUiCond.string, e);
                }
            }
        }
    }

    public void checkFilterAnyEngine(FilterDesc filter, Dataset ds, RecipeStatus.StepStatus stepStatus, String engineType, SQLDialect dialect) {
        if (filter != null && filter.enabled) {
            switch (VisualSQLRecipesBaseService.getFilterExprType(filter)) {
                case AST: {
                    try {
                        if (engineType.equals("DSS")) {
                            FilterDescUtils.translateAstToGrel(filter);
                            break;
                        }
                        ExpressionBuilder builder = FilterDescUtils.translateAstToSql(filter, ds, true, dialect);
                        if (!dialect.needsAstTranslationChecking()) break;
                        builder.toSQL(dialect);
                    }
                    catch (Throwable e) {
                        logger.error((Object)"Invalid filter", e);
                        stepStatus.withFatal(RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_FILTER, ExceptionUtils.getMessageWithCauses((Throwable)e));
                    }
                    break;
                }
                case GREL: {
                    if (engineType.equals("DSS")) break;
                    try {
                        Expression expr = GrelExpression.build(FilterDescUtils.getGrelFilterExpression(filter), ds.getSchema());
                        GrelToQueryTranslator translator = new GrelToQueryTranslator((GrelTranslator.GrelMapping)new GrelToQueryMapping(dialect), ds.getSchema());
                        GrelTranslator.TranslationResult<String> tr = translator.translateToString(expr, false);
                        if (tr.isFullyTranslated) break;
                        stepStatus.withFatal(RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_FILTER, "The filter expression is not fully translatable to SQL");
                    }
                    catch (Throwable e) {
                        logger.error((Object)"Invalid filter", e);
                        stepStatus.withFatal(RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_FILTER, ExceptionUtils.getMessageWithCauses((Throwable)e));
                    }
                    break;
                }
                case SQL: {
                    if (!engineType.equals("DSS")) break;
                    stepStatus.withFatal(RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_FILTER, "Cannot filter with a SQL expression in DSS engine");
                }
            }
            try {
                this.checkRegexp(filter);
            }
            catch (Exception e) {
                stepStatus.withFatal(RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_FILTER, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
    }

    private static FilterExprType getFilterExprType(FilterDesc filterDesc) {
        if (filterDesc.uiData == null) {
            if (filterDesc.getExpressionLanguage() == FilterDesc.ExpressionLanguage.SQL) {
                return FilterExprType.SQL;
            }
            return FilterExprType.GREL;
        }
        if (filterDesc.uiData.mode.equals("CUSTOM")) {
            return FilterExprType.GREL;
        }
        if (filterDesc.uiData.mode.equals("SQL")) {
            return FilterExprType.SQL;
        }
        if (filterDesc.uiData.mode.equals("ES_QUERY_STRING")) {
            return FilterExprType.ES_QUERY_STRING;
        }
        return FilterExprType.AST;
    }

    public boolean areAllInputDatasetsRealSQL(JobActivity activity) throws IOException {
        for (FlowComputable flowComputable : activity.getSubgraph().getSourceDatasets()) {
            FlowDataset fdsource;
            Dataset dataset;
            if (!(flowComputable instanceof FlowDataset) || DatasetInspector.isSQL(dataset = (fdsource = (FlowDataset)flowComputable).getMandatoryUnsafe(this.datasetsDAO))) continue;
            return false;
        }
        return true;
    }

    public boolean areAllInputDatasetsHDFS(JobActivity activity) throws IOException {
        for (FlowComputable flowComputable : activity.getSubgraph().getSourceDatasets()) {
            FlowDataset fdsource;
            Dataset dataset;
            if (!(flowComputable instanceof FlowDataset) || "HDFS".equals((dataset = (fdsource = (FlowDataset)flowComputable).getMandatoryUnsafe(this.datasetsDAO)).getType())) continue;
            return false;
        }
        return true;
    }

    public void selectEngine(AuthCtx authCtx, JobActivity activity, String userSelected, RecipeStatus status, String recipeType, RecipeEnginesPreferenceConfig resolvedPreferences) throws IOException, DKUSecurityException {
        this.selectEngine(authCtx, activity, userSelected, status, recipeType, resolvedPreferences, true);
    }

    /*
     * WARNING - void declaration
     */
    public void selectEngine(AuthCtx authCtx, JobActivity activity, String userSelected, RecipeStatus status, String recipeType, RecipeEnginesPreferenceConfig resolvedPreferences, boolean fallbackToDSSEnginePossible) throws IOException, DKUSecurityException {
        void var10_27;
        HashMap<String, SQLBasedEngineStatus> enginesIndex = new HashMap<String, SQLBasedEngineStatus>();
        for (RecipeEngineStatus recipeEngineStatus : status.engines) {
            enginesIndex.put(recipeEngineStatus.type, (SQLBasedEngineStatus)recipeEngineStatus);
        }
        List<String> forbiddenEngines = resolvedPreferences.getEffectiveForbidden(recipeType);
        for (String forbidden : forbiddenEngines) {
            SQLBasedEngineStatus engine = (SQLBasedEngineStatus)enginesIndex.get(forbidden);
            if (engine == null) continue;
            engine.isSelectable = false;
            engine.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
            engine.statusMessage = "Forbidden by configuration";
        }
        Object var10_12 = null;
        if (StringUtils.isNotBlank((String)userSelected)) {
            SQLBasedEngineStatus sQLBasedEngineStatus = (SQLBasedEngineStatus)enginesIndex.get(userSelected);
            if (sQLBasedEngineStatus == null) {
                throw ErrorContext.iae((String)("User requested unknown recipe engine: " + userSelected));
            }
            logger.info((Object)("User requested engine: " + sQLBasedEngineStatus.type));
        } else {
            void var10_25;
            void var10_23;
            void var10_21;
            SQLBasedEngineStatus spark;
            void var10_19;
            SQLBasedEngineStatus hive;
            void var10_17;
            SQLBasedEngineStatus sql;
            void var10_15;
            List<String> userSpecifiedPreference = resolvedPreferences.getEffectivePreference(recipeType);
            if (userSpecifiedPreference.size() > 0) {
                for (String type : userSpecifiedPreference) {
                    SQLBasedEngineStatus res = (SQLBasedEngineStatus)enginesIndex.get(type);
                    if (!res.isSelectable || res.statusWarnLevel != RecipeEngineStatus.WarningLevel.OK) continue;
                    logger.info((Object)("Using user-prefered engine: " + type));
                    SQLBasedEngineStatus sQLBasedEngineStatus = res;
                    break;
                }
            }
            if (var10_15 == null) {
                logger.info((Object)"No user preference was usable, using heuristics");
            }
            if (var10_15 == null && this.areAllInputDatasetsRealSQL(activity) && (sql = (SQLBasedEngineStatus)enginesIndex.get("SQL")) != null && sql.isOK()) {
                logger.info((Object)"SQL is possible and inputs are real SQL, using it");
                SQLBasedEngineStatus sQLBasedEngineStatus = sql;
            }
            if (var10_17 == null && this.areAllInputDatasetsHDFS(activity) && (hive = (SQLBasedEngineStatus)enginesIndex.get("HIVE")) != null && hive.isOK()) {
                logger.info((Object)"Using Hive because input is HDFS");
                SQLBasedEngineStatus sQLBasedEngineStatus = hive;
            }
            if (var10_19 == null && (spark = (SQLBasedEngineStatus)enginesIndex.get("SPARK")) != null && spark.isOK()) {
                DatasetSparkInspector.SparkFastPathStatus sparkFPS = ServiceUtils.canLikelySparkFastPathRead(authCtx, activity, this.datasetsDAO);
                logger.info((Object)("Spark fast-path status: " + JSON.log((Object)sparkFPS)));
                if (sparkFPS.ok) {
                    logger.info((Object)"Using possible Spark because spark-fast-path-able");
                    SQLBasedEngineStatus sQLBasedEngineStatus = spark;
                }
            }
            if (var10_21 == null) {
                ArrayList<String> remainingEnginesToTry = new ArrayList<String>();
                if (this.areAllInputDatasetsRealSQL(activity)) {
                    remainingEnginesToTry.add("HIVE");
                    remainingEnginesToTry.add("SQL");
                    remainingEnginesToTry.add("DSS");
                    remainingEnginesToTry.add("SPARK");
                    remainingEnginesToTry.add("IMPALA");
                } else if (this.areAllInputDatasetsHDFS(activity)) {
                    remainingEnginesToTry.add("HIVE");
                    remainingEnginesToTry.add("SPARK");
                    remainingEnginesToTry.add("IMPALA");
                    remainingEnginesToTry.add("DSS");
                    remainingEnginesToTry.add("SQL");
                } else {
                    remainingEnginesToTry.add("HIVE");
                    remainingEnginesToTry.add("DSS");
                    remainingEnginesToTry.add("SPARK");
                    remainingEnginesToTry.add("IMPALA");
                    remainingEnginesToTry.add("SQL");
                }
                for (String type : remainingEnginesToTry) {
                    if (enginesIndex.get(type) == null || ((SQLBasedEngineStatus)enginesIndex.get((Object)type)).statusWarnLevel == RecipeEngineStatus.WarningLevel.ERROR) continue;
                    SQLBasedEngineStatus sQLBasedEngineStatus = (SQLBasedEngineStatus)enginesIndex.get(type);
                    logger.info((Object)("Auto-selected recipe engine: " + sQLBasedEngineStatus.type));
                    break;
                }
            }
            if (var10_23 == null) {
                logger.info((Object)"All engines have ERROR status, just picking one that is selectable");
                for (String type : enginesIndex.keySet()) {
                    if (enginesIndex.get(type) == null || !((SQLBasedEngineStatus)enginesIndex.get((Object)type)).isSelectable) continue;
                    SQLBasedEngineStatus sQLBasedEngineStatus = (SQLBasedEngineStatus)enginesIndex.get(type);
                    logger.info((Object)("Auto-selected recipe engine (among all-error): " + sQLBasedEngineStatus.type));
                    break;
                }
            }
            if (var10_25 == null && fallbackToDSSEnginePossible) {
                logger.info((Object)"No engine could be auto-selected. Select DSS engine.");
                SQLBasedEngineStatus sQLBasedEngineStatus = (SQLBasedEngineStatus)enginesIndex.get("DSS");
                assert (sQLBasedEngineStatus != null);
            }
        }
        status.selectedEngine = var10_27;
    }

    public void enableSimplifiedExplainPlan(SQLBasedEngineStatus selectedEngine, VisualSQLRecipePayloadParams params) {
        if (VisualSQLRecipesBaseService.matchesEngineType(selectedEngine, "HIVE") && HadoopFlavorUtils.hiveSupportsMREngine()) {
            logger.info((Object)"Not requiring the true explain plan, using MR Hive engine");
            params.engineParams.hive.hiveconf.add(new SimpleKeyValue("hive.execution.engine", "mr"));
        }
    }

    public boolean mustLowerCaseColumnsNames(VisualSQLRecipePayloadParams params, SQLBasedEngineStatus selectedEngine) {
        boolean lowerCaseColumnsNames = false;
        if (params.engineParams.lowerCaseSchemaIfEngineRequiresIt) {
            lowerCaseColumnsNames = selectedEngine != null && selectedEngine.lowercasesColumnNames();
        }
        return lowerCaseColumnsNames;
    }

    public SQLBasedEngineStatus getEngine(AuthCtx authCtx, JobActivity activity, VisualSQLRecipePayloadParams params, String engineType) throws Exception {
        SerializedRecipe sr = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe().getModel();
        RecipeEnginesPreferenceConfig repc = new RecipeConfigUtils().getResolvedPreferenceConfig(sr.projectKey, sr.type, params.enginesPreferences);
        VisualSQLRecipeStatus fakeStatus = new VisualSQLRecipeStatus(){

            @Override
            public InfoMessage.InfoMessages gatherAllMessages() {
                InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
                ret.mergeFrom(this.topLevelMessages);
                return ret;
            }
        };
        this.initEngines(authCtx, activity, fakeStatus, sr.projectKey);
        this.selectEngine(authCtx, activity, engineType, fakeStatus, sr.type, repc);
        return fakeStatus.getSelectedSQLBasedEngine();
    }

    public boolean mustLowerCaseColumnsNames(VisualSQLRecipePayloadParams params, RecipeEngineStatus engine) throws Exception {
        boolean lowerCaseColumnsNames = false;
        if (params.engineParams.lowerCaseSchemaIfEngineRequiresIt && engine instanceof SQLBasedEngineStatus) {
            lowerCaseColumnsNames = ((SQLBasedEngineStatus)engine).lowercasesColumnNames();
        }
        return lowerCaseColumnsNames;
    }

    public boolean canUseEngine(String engineType, RecipeStatus status) {
        for (RecipeEngineStatus engine : status.engines) {
            if (!engine.type.equals(engineType)) continue;
            return engine.isSelectable;
        }
        return false;
    }

    public ExecutionPlanService.ExecutionPlan getExecutionPlan(AuthCtx authCtx, SQLBasedEngineStatus engine, SerializedRecipe sr, List<Dataset> inputDatasets, String sql, VisualSQLRecipeEngineParams engineParams) throws Exception {
        ExecutionPlanService executionPlanService = (ExecutionPlanService)SpringUtils.getBean(ExecutionPlanService.class);
        switch (engine.type) {
            case "HIVE": {
                return executionPlanService.getHiveExecutionPlan(sr, sql, authCtx, engineParams.hive);
            }
            case "IMPALA": {
                return executionPlanService.getImpalaExecutionPlan(sr, sql, authCtx, engineParams.impala);
            }
            case "SQL": {
                return executionPlanService.getSqlExecutionPlan(sr, sql, authCtx).call();
            }
            case "SPARK": {
                throw new NotImplementedException("Spark execution plans not implemented");
            }
            case "DSS": {
                if (!engine.queryBased) break;
                try (DatasetToH2Loader h2Loader = new DatasetToH2Loader(authCtx, null, sr.getProjectKey(), this.h2dbFactory.createFor(sr.getProjectKey()));){
                    H2DB db = null;
                    logger.info((Object)"Create H2DB");
                    for (Dataset ds : inputDatasets) {
                        db = h2Loader.createTestTable(ds);
                    }
                    if (db != null) {
                        ExecutionPlanService.ExecutionPlan executionPlan = executionPlanService.getExecutionPlan(db.getConn(), db.getConnData(), sql);
                        return executionPlan;
                    }
                    break;
                }
            }
        }
        return null;
    }

    public void adjustEngineStatus(AuthCtx authCtx, JobActivity activity, VisualSQLRecipeStatus status, String partialSQLExplanation) throws IOException {
        this.emitSpecificWarningsForHiveDatasets(activity, status);
        this.downgradeSQLEngineLabelIfNotFullSQL(authCtx, activity, status, partialSQLExplanation);
        this.downgradeSparkEngineLabelIfNotFastPath(authCtx, activity, status);
    }

    private void emitSpecificWarningsForHiveDatasets(JobActivity activity, VisualSQLRecipeStatus status) throws IOException {
        SQLBasedEngineStatus selectedEngine = status.getSelectedSQLBasedEngine();
        if (VisualSQLRecipesBaseService.matchesEngineType(selectedEngine, "HIVE")) {
            if (status.engineParams != null && status.engineParams.hive.executionEngine == HiveRecipeMeta.HiveExecutionEngine.HIVECLI_LOCAL && !ServiceUtils.canHiveCLILocal(activity, this.datasetsDAO)) {
                status.output.withFatal(RecipeCodes.ERR_RECIPE_INVALID_HIVE_ENGINE, "The 'Hive CLI (Isolated metastore)' engine for Hive can only be used on HDFS inputs");
            }
        } else if (VisualSQLRecipesBaseService.matchesEngineType(selectedEngine, "SPARK") && status.engineParams != null && !status.engineParams.sparkSQL.useGlobalMetastore && ServiceUtils.optimizableForGlobalMetastore(activity, this.datasetsDAO)) {
            status.output.withWarning(RecipeCodes.WARN_RECIPE_SPARK_INDIRECT_HIVE, "Some input datasets will not be accessed directly by Spark until the recipe is set to use the global Hive metastore");
        }
    }

    private void downgradeSQLEngineLabelIfNotFullSQL(AuthCtx authCtx, JobActivity activity, VisualSQLRecipeStatus status, String explanation) {
        try {
            RecipeEngineStatus sql = RecipeStatus.getEngineByTypeAllowNonExisting(status.engines, "SQL");
            logger.info((Object)("SQL status " + JSON.log((Object)sql)));
            if (sql != null && sql.isSelectable && sql.statusWarnLevel == RecipeEngineStatus.WarningLevel.OK) {
                logger.info((Object)"It's selectable");
                if (!ServiceUtils.canFullSQL(authCtx, activity, this.datasetsDAO).canUse()) {
                    logger.info((Object)"Cannot Full SQL");
                    sql.label = "Partially in-database";
                    sql.variantLabel = explanation;
                    sql.description = explanation;
                } else {
                    logger.info((Object)"Can Full SQL");
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to mark SQL engine as downgraded", (Throwable)e);
        }
    }

    private void downgradeSparkEngineLabelIfNotFastPath(AuthCtx authCtx, JobActivity activity, VisualSQLRecipeStatus status) {
        try {
            RecipeEngineStatus spark = RecipeStatus.getEngineByTypeAllowNonExisting(status.engines, "SPARK");
            if (spark != null && spark.isOK()) {
                DatasetSparkInspector.SparkFastPathStatus sparkFPS = ServiceUtils.canLikelySparkFastPathRead(authCtx, activity, this.datasetsDAO);
                logger.info((Object)("Spark fast-path status: " + JSON.log((Object)sparkFPS)));
                if (!sparkFPS.ok) {
                    logger.info((Object)"Not spark-fast-path-able");
                    spark.label = "Spark (slow)";
                    spark.variantLabel = "Computation not fully distributed: " + sparkFPS.message;
                    spark.description = spark.variantLabel;
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to mark Spark engine as downgraded", (Throwable)e);
        }
    }

    public Dataset getOutputDataset(JobActivity activity) throws IOException {
        List<FlowDataset> targetsDatasets = activity.getSubgraph().getTargetsDatasets();
        if (targetsDatasets == null || targetsDatasets.isEmpty()) {
            return null;
        }
        return targetsDatasets.get(0).getMandatory(this.datasetsDAO);
    }

    private static boolean matchesEngineType(SQLBasedEngineStatus engine, String type) {
        return engine != null && type.equals(engine.type);
    }

    public static final class SQLBasedEngineStatus
    extends RecipeEngineStatus {
        public boolean canAnalyticalFunctions = false;
        public boolean canStddevAsAnalyticalFunctions = false;
        public boolean canDistinctSelect = true;
        public boolean canNonEquiJoin = false;
        public boolean canFullOuterJoin = true;
        public boolean canDeduplicateJoinMatches;
        public boolean doNotSupportLeadLagWithWindow = false;
        public boolean queryBased = true;
        public boolean expectLongRecipeStatusComputation = false;
        public Map<SQLAggregateType, SQLAggregateAbility> aggregabilities = Maps.newHashMap();
        public String identifierQuotingCharacter;
        public String stringQuotingCharacter;
        public boolean lowercasesColumnNames;
        public boolean useNativeProcessors;

        public static boolean isH2Mode(SQLBasedEngineStatus engine) {
            return VisualSQLRecipesBaseService.matchesEngineType(engine, "DSS") && engine.queryBased;
        }

        public SQLBasedEngineStatus() {
        }

        public SQLBasedEngineStatus(String type, String engineLabel, String variant, String variantLabel, String label) {
            super(type, engineLabel, variant, variantLabel, label);
        }

        public boolean lowercasesColumnNames() {
            return this.lowercasesColumnNames;
        }
    }

    public static class AppConfig {
        boolean sparkEnabled;
        boolean hiveEnabled;
        boolean impalaEnabled;
    }

    private static enum FilterExprType {
        GREL,
        SQL,
        AST,
        ES_QUERY_STRING;

    }
}

