/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck.detectors;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.sanitycheck.SanityCheckDetectorBase;
import com.dataiku.dip.sanitycheck.SanityCheckInfoMessages;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.annotations.VisibleForTesting;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;

@Component
public class JVMConfigurationDetector
implements SanityCheckDetectorBase {
    private static final long RED_ZONE_MIN_IN_BYTES = 0x800000000L;
    private static final long RED_ZONE_MAX_IN_BYTES = 0xC00000000L;
    private static final Pattern xmxPattern = Pattern.compile("(?<value>\\d+)(?<unit>[kmg]?)", 2);
    private static final List<String> javaProcesses = Arrays.asList("apimain", "dku", "backend", "fek", "hproxy", "jek", "cak", "eventserver");
    public static final String KERNEL_XMX_DEFAULT_THRESHOLD = "4g";
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.sanitycheck.jvmconfigdetector");

    public List<InfoMessage.MessageCode> getCodes() {
        return Arrays.asList(Codes.values());
    }

    public SanityCheckInfoMessages runAnalysis(Set<String> exclusionList) {
        SanityCheckInfoMessages messages = new SanityCheckInfoMessages();
        if (!exclusionList.contains(Codes.WARN_JVM_CONFIG_XMX_IN_RED_ZONE.name())) {
            for (String javaProcess : javaProcesses) {
                messages.mergeFrom((InfoMessage.InfoMessages)this.warnIfXmxInRedZone(javaProcess + ".xmx"));
            }
        }
        if (!exclusionList.contains(Codes.WARN_JVM_CONFIG_KERNEL_XMX_OVER_THRESHOLD.name())) {
            messages.mergeFrom(this.warnIfXmxOverThreshold("fek.xmx"));
            messages.mergeFrom(this.warnIfXmxOverThreshold("jek.xmx"));
        }
        return messages;
    }

    private SanityCheckInfoMessages warnIfXmxInRedZone(String xmxKey) {
        SanityCheckInfoMessages messages = new SanityCheckInfoMessages();
        String xmx = this.getJavaOpts(xmxKey);
        if (xmx == null) {
            return messages;
        }
        try {
            long valueInBytes = JVMConfigurationDetector.getXmxValueInBytes(xmx);
            if (valueInBytes > 0x800000000L && valueInBytes < 0xC00000000L) {
                messages.withWarningV((InfoMessage.MessageCode)Codes.WARN_JVM_CONFIG_XMX_IN_RED_ZONE, "the %s value of '%s' is over 32g and under 48g which is likely to waste memory", new Object[]{xmxKey, this.getJavaOpts(xmxKey)});
            }
        }
        catch (ParseException e) {
            messages.withFatalV((InfoMessage.MessageCode)Codes.WARN_JVM_CONFIG_XMX_IN_RED_ZONE, "Could not parse %s value of '%s'  as it does not follow the <size>[g|G|m|M|k|K] pattern", new Object[]{xmxKey, xmx});
        }
        return messages;
    }

    private InfoMessage.InfoMessages warnIfXmxOverThreshold(String xmxKey) {
        SanityCheckInfoMessages messages = new SanityCheckInfoMessages();
        String xmx = this.getJavaOpts(xmxKey);
        if (xmx == null) {
            return messages;
        }
        String xmxThreshold = DKUApp.getParams().getParam("dku.sanitycheck.jvm.kernelXmxThreshold", KERNEL_XMX_DEFAULT_THRESHOLD);
        long xmxThresholdInBytes = 0L;
        try {
            xmxThresholdInBytes = JVMConfigurationDetector.getXmxValueInBytes(xmxThreshold);
        }
        catch (ParseException e) {
            logger.errorV((Throwable)e, "Could not parse dku.sanitycheck.jvm.kernelXmxThreshold value of '%s'  as it does not follow the <size>[g|G|m|M|k|K] pattern", new Object[]{xmxThreshold});
            xmxThreshold = KERNEL_XMX_DEFAULT_THRESHOLD;
            try {
                xmxThresholdInBytes = JVMConfigurationDetector.getXmxValueInBytes(xmxThreshold);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        try {
            if (JVMConfigurationDetector.getXmxValueInBytes(xmx) > xmxThresholdInBytes) {
                messages.withWarningV((InfoMessage.MessageCode)Codes.WARN_JVM_CONFIG_KERNEL_XMX_OVER_THRESHOLD, "the %s value of '%s' is over the recommended maximum of %s", new Object[]{xmxKey, this.getJavaOpts(xmxKey), xmxThreshold});
            }
        }
        catch (ParseException e) {
            messages.withFatalV((InfoMessage.MessageCode)Codes.WARN_JVM_CONFIG_KERNEL_XMX_OVER_THRESHOLD, "Could not parse %s value of '%s' as it does not follow the <size>[g|G|m|M|k|K] pattern", new Object[]{xmxKey, xmx});
        }
        return messages;
    }

    @VisibleForTesting
    protected String getJavaOpts(String key) {
        return DKUApp.getIniValue((String)"javaopts", (String)key);
    }

    private static long getXmxValueInBytes(String xmx) throws ParseException {
        Matcher matcher = xmxPattern.matcher(xmx.trim());
        if (!matcher.matches()) {
            throw new ParseException(xmx, 0);
        }
        long valueInBytes = Long.parseLong(matcher.group("value"));
        switch (matcher.group("unit").toLowerCase()) {
            case "g": {
                valueInBytes *= 1024L;
            }
            case "m": {
                valueInBytes *= 1024L;
            }
            case "k": {
                valueInBytes *= 1024L;
            }
        }
        return valueInBytes;
    }

    public static enum Codes implements InfoMessage.MessageCode
    {
        WARN_JVM_CONFIG_XMX_IN_RED_ZONE("JVM configuration - Sub optimal Xmx value", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING),
        WARN_JVM_CONFIG_KERNEL_XMX_OVER_THRESHOLD("JVM configuration - Xmx value for kernel over threshold", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private Codes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

