/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.scheduler.ScenarioThread;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.services.TaggableObjectCodes;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class InvalidateCacheStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public String getType() {
            return "invalidate_cache";
        }

        @Override
        public Class<? extends StepParams> paramsClass() {
            return InvalidateStepParams.class;
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new InvalidateCacheStepRunner(scenario, step, step.getParamsAs(InvalidateStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            InvalidateStepParams params = step.getParamsAs(InvalidateStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("Invalidate cache");
            if (params != null) {
                for (FlowComputableSpecification built : params.invalidates) {
                    sb.append(" ");
                    sb.append(built.getItemName());
                }
            }
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            InvalidateStepParams params = step.getParamsAs(InvalidateStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("invalidatecache");
            if (params != null) {
                sb.append("_");
                for (FlowComputableSpecification built : params.invalidates) {
                    sb.append("_");
                    sb.append(built.getPartitionInvariantId());
                }
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario scenario, Step step, PluginUsagesInspector pluginUsagesInspector) {
            InvalidateStepParams stepParams = (InvalidateStepParams)step.params;
            if (null != stepParams && null != stepParams.invalidates && !stepParams.invalidates.isEmpty()) {
                return StepMeta.UnavailableStepInfo.checkFlowComputableSpecs(scenario, step, pluginUsagesInspector, stepParams.invalidates, logger);
            }
            return null;
        }
    };
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetDeletionService datasetDeletionService;
    @Autowired
    private TransactionService transactionService;
    private final InvalidateStepParams params;
    private final Step step;
    private final Scenario scenario;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.invalidatecache");

    public InvalidateCacheStepRunner(Scenario scenario, Step step, InvalidateStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.name));
        for (FlowComputableSpecification item : this.params.invalidates) {
            ScenarioThread.checkInterrupted();
            logger.info((Object)("Will clear " + JSON.log((Object)item)));
            String pkey = item.projectKey == null ? this.scenario.getProjectKey() : item.projectKey;
            switch (item.type) {
                case DATASET: {
                    Dataset dataset;
                    try (Transaction t = this.transactionService.beginRead();){
                        dataset = this.datasetAccessService.getMandatory(pkey, item.itemId);
                    }
                    this.datasetDeletionService.clearCacheAndStatus_NT(dataset);
                    break;
                }
                case SAVED_MODEL: {
                    throw new CodedException((InfoMessage.MessageCode)TaggableObjectCodes.ERR_OBJECT_OPERATION_NOT_AVAILABLE_FOR_TYPE, "Cannot invalidate caches on a saved model");
                }
                case MANAGED_FOLDER: {
                    throw new CodedException((InfoMessage.MessageCode)TaggableObjectCodes.ERR_OBJECT_OPERATION_NOT_AVAILABLE_FOR_TYPE, "Cannot invalidate caches on a managed folder");
                }
                case STREAMING_ENDPOINT: {
                    throw new CodedException((InfoMessage.MessageCode)TaggableObjectCodes.ERR_OBJECT_OPERATION_NOT_AVAILABLE_FOR_TYPE, "Cannot invalidate caches on a streaming endpoint");
                }
                case MODEL_EVALUATION_STORE: {
                    throw new CodedException((InfoMessage.MessageCode)TaggableObjectCodes.ERR_OBJECT_OPERATION_NOT_AVAILABLE_FOR_TYPE, "Cannot invalidate caches on a model evaluation");
                }
                case RETRIEVABLE_KNOWLEDGE: {
                    throw new CodedException((InfoMessage.MessageCode)TaggableObjectCodes.ERR_OBJECT_OPERATION_NOT_AVAILABLE_FOR_TYPE, "Cannot invalidate caches on a knowledge bank");
                }
            }
        }
        stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
        logger.info((Object)("Done InvalidateCache step " + this.step.name));
        assert (stepReportItem.getOutcome() != null);
    }

    public static class InvalidateStepParams
    extends NonFatalStepParams
    implements StepParams {
        public List<FlowComputableSpecification> invalidates = Lists.newArrayList();
    }
}

