/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.auth;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.custom.CustomUserAuthenticatorDelegator;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSCustomUserAuthenticatorDelegator
extends CustomUserAuthenticatorDelegator {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth");

    @Autowired
    public DSSCustomUserAuthenticatorDelegator(GeneralSettingsDAO generalSettingsDao, PubSubService pubSubService) {
        this.customAuthSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().customAuthSettings;
        pubSubService.subscribe("general-settings-changed", evt -> {
            try {
                GeneralSettingsDAO.GeneralSettings generalSettings = generalSettingsDao.getUnsafeAutoTXN();
                this.customAuthSettings = generalSettings.customAuthSettings;
            }
            catch (IOException e) {
                logger.error((Object)"Could not reload modified general settings", (Throwable)e);
            }
        });
    }
}

