/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.auth;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UserAuthenticationService;
import com.dataiku.dip.security.auth.UserCredentialsAuthenticator;
import com.dataiku.dip.security.auth.UserSupplier;
import com.dataiku.dip.server.services.DkuUsersService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.DkuLicenseEnforcementService;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSUserAuthenticationService
extends UserAuthenticationService {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth");
    private final GeneralSettingsDAO generalSettingsDao;

    @Autowired
    public DSSUserAuthenticationService(AuditTrailService auditTrailService, DkuUsersService usersService, TransactionService transactionService, List<UserCredentialsAuthenticator> userAuthenticators, List<UserSupplier> userSuppliers, DkuLicenseEnforcementService licenseEnforcementService, GeneralSettingsDAO gsDAO, PubSubService pubSubService, PasswordEncryptionService symetricCryptoService) {
        super(auditTrailService, usersService, transactionService, userAuthenticators, userSuppliers, licenseEnforcementService, symetricCryptoService);
        GeneralSettingsDAO.GeneralSettings settings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        this.generalSettingsDao = gsDAO;
        this.authSyncSettings = settings.authSyncSettings;
        this.isEmailSafe = !settings.security.enableEmailAndDisplayNameModification;
        pubSubService.subscribe("general-settings-changed", evt -> {
            try {
                GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDao.getUnsafeAutoTXN();
                this.authSyncSettings = generalSettings.authSyncSettings;
                this.isEmailSafe = !generalSettings.security.enableEmailAndDisplayNameModification;
            }
            catch (IOException e) {
                logger.error((Object)"Could not reload modified general settings", (Throwable)e);
            }
        });
    }
}

