/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.impersonation;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Master;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.client.api.TimelineClient;

public class HadoopDelegationTokensGenerator {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.security.impersonation.tokens");

    public static boolean isDisabled() {
        return ApplicationConfigurator.getProperty((String)"hadoop.security.delegationTokens.enabled", (String)"true").equalsIgnoreCase("false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateSparkTokenFile(String proxyUser, String tokenFile, List<SimpleKeyValue> extraConf) throws IOException {
        final Configuration conf = new Configuration();
        for (SimpleKeyValue kv : extraConf) {
            conf.set(kv.key, kv.value);
        }
        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)proxyUser, (UserGroupInformation)UserGroupInformation.getLoginUser());
        final String renewer = Master.getMasterPrincipal((Configuration)conf);
        final Credentials cred = new Credentials();
        logger.info((Object)("Getting delegation tokens for user=" + String.valueOf(ugi) + " renewer=" + renewer));
        HadoopDelegationTokensGenerator.addTokenForFS(null, conf, ugi, renewer, cred);
        try {
            String defaultFSsStr = conf.get("spark.yarn.access.hadoopFileSystems", conf.get("spark.yarn.access.namenodes", ""));
            if (StringUtils.isNotBlank((String)defaultFSsStr)) {
                for (String defaultFS : defaultFSsStr.split(",")) {
                    HadoopDelegationTokensGenerator.addTokenForFS(defaultFS, conf, ugi, renewer, cred);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"No property defined for extra fs.defaultFS");
        }
        try (Cluster cluster = null;){
            logger.info((Object)"Getting tokens for MR cluster");
            final Cluster fCluster = cluster = (Cluster)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Cluster>(){

                @Override
                public Cluster run() throws IOException {
                    return new Cluster(conf);
                }
            });
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, InterruptedException {
                    Token mrTok = fCluster.getDelegationToken(new Text(renewer));
                    cred.addToken(new Text("MRToken"), mrTok);
                    return null;
                }
            });
        }
        HadoopDelegationTokensGenerator.fetchHiveMetastoreDelegationToken(extraConf, ugi, renewer, cred);
        if (conf.getBoolean("yarn.timeline-service.enabled", false)) {
            try (TimelineClient timelineClient = null;){
                logger.info((Object)"Getting tokens for timeline server");
                timelineClient = (TimelineClient)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TimelineClient>(){

                    @Override
                    public TimelineClient run() throws IOException {
                        TimelineClient timelineClient = TimelineClient.createTimelineClient();
                        timelineClient.init(conf);
                        return timelineClient;
                    }
                });
                Token atsTok = timelineClient.getDelegationToken(renewer);
                cred.addToken(new Text("ATSToken"), atsTok);
            }
        } else {
            logger.info((Object)"Timeline server not enabled");
        }
        logger.info((Object)"Acquired tokens:");
        for (Token token : cred.getAllTokens()) {
            logger.info((Object)("Token: " + String.valueOf(token)));
        }
        logger.info((Object)("Writing tokens to " + tokenFile));
        cred.writeTokenStorageFile(new Path(tokenFile), conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fetchHiveMetastoreDelegationToken(List<SimpleKeyValue> extraConf, UserGroupInformation ugi, String renewer, Credentials cred) {
        Hive hive = null;
        try {
            logger.info((Object)"Getting token for Hive metastore");
            HiveConf hiveConf = new HiveConf();
            for (SimpleKeyValue kv : extraConf) {
                hiveConf.set(kv.key, kv.value);
            }
            hive = Hive.get((HiveConf)hiveConf);
            String tokStr = hive.getDelegationToken(ugi.getUserName(), renewer);
            Token tok = new Token();
            tok.decodeFromUrlString(tokStr);
            cred.addToken(new Text("MetastoreToken"), tok);
        }
        catch (Throwable e) {
            logger.warn((Object)"cannot retrieve metastore delegation token", e);
        }
        finally {
            if (hive != null) {
                Hive.closeCurrent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTokenForFS(final String defaultFS, final Configuration conf, UserGroupInformation ugi, String renewer, Credentials cred) throws IOException {
        try (FileSystem fs = null;){
            logger.info((Object)"Getting tokens for default filesystem");
            fs = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    if (StringUtils.isBlank((String)defaultFS) || "/".equals(defaultFS)) {
                        return FileSystem.get((Configuration)conf);
                    }
                    return FileSystem.get((URI)new URI(defaultFS), (Configuration)conf);
                }
            });
            fs.addDelegationTokens(renewer, cred);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: " + HadoopDelegationTokensGenerator.class.getCanonicalName() + " PROXY_USER TOKENFILE");
            System.exit(1);
        }
        HadoopDelegationTokensGenerator.generateSparkTokenFile(args[0], args[1], new ArrayList<SimpleKeyValue>());
    }
}

