/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.connections;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.BigQueryConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.ElasticSearchConnection;
import com.dataiku.dip.connections.HDFSAbleConnection;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.connections.IcebergConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.TeradataConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.exec.h2.H2TemporarySQLConfig;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDatasetHandler;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDialect;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchHttpClient;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchIndex;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchUtils;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetHandler;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetParams;
import com.dataiku.dip.datasets.iceberg.IcebergSchemaConverter;
import com.dataiku.dip.datasets.iceberg.IcebergUtils;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.TeradataDatasetConfig;
import com.dataiku.dip.datasets.sql.bigquery.BigQueryDatasetConfig;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.hive.massimport.HiveImportabilityChecker;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.connections.ConnectionsImportController;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.text.StringNormalizer;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.sql.metadata.DatabaseObjectKey;
import com.dataiku.dip.transactions.exceptions.TransactionFailedException;
import com.dataiku.dip.transactions.git.TransactionGitException;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dip.utils.WithMessages;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Catalog;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.SupportsNamespaces;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifier;
import com.dataiku.hproxy.model.hive.TableSchema;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectionsImportService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetsDAO dao;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private MetastoreInspectionService metastoreInspectionService;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private FlowZonesService flowZonesService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.connections.import");

    public FutureResponse<SQLTableImportData> startListSQLTables(AbstractSQLConnection connection, String sourceCatalog, String sourceSchema, AuthCtx authCtx, String projectKey) throws Exception {
        ListSQLMassImportTablesThread ft = new ListSQLMassImportTablesThread(connection, sourceCatalog, sourceSchema, authCtx, projectKey);
        return this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<SQLTableImportData>>(){});
    }

    public FutureResponse<IcebergTableImportData> startListIcebergTables(AuthCtx authCtx, String projectKey, String namespace, IcebergConnection connection) throws Exception {
        ListIcebergMassImportTablesThread ft = new ListIcebergMassImportTablesThread(connection, authCtx, projectKey, namespace);
        return this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<IcebergTableImportData>>(){});
    }

    public FutureResponse<ElasticSearchIndicesImportData> startListElasticSearchIndices(ElasticSearchConnection connection, AuthCtx authCtx) throws Exception {
        ListElasticSearchMassImportIndicesThread ft = new ListElasticSearchMassImportIndicesThread(connection, authCtx);
        return this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<ElasticSearchIndicesImportData>>(){});
    }

    public FutureResponse<HiveImportabilityChecker.HiveTablesImportCandidates> startListMetastoreTables(String projectKey, AuthCtx authCtx, ConnectionsDAO.VirtualConnectionId virtualConnection) throws Exception {
        ListHiveMassImportTablesThread ft = new ListHiveMassImportTablesThread(projectKey, authCtx, virtualConnection);
        return this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<HiveImportabilityChecker.HiveTablesImportCandidates>>(){});
    }

    private TableImportCandidates getImportCandidatesFromElasticSearchCandidates(String targetProjectKey, List<ElasticSearchIndexImportCandidate> initialCandidates) throws Exception {
        assert (targetProjectKey != null);
        TableImportCandidates result = new TableImportCandidates();
        StringTransmogrifier st2 = new StringTransmogrifier();
        AlreadyUsedDatasets usedDatasets = new AlreadyUsedDatasets();
        usedDatasets.findAlreadyUsedDatasets(targetProjectKey, st2);
        for (ElasticSearchIndexImportCandidate imic : initialCandidates) {
            DatabaseObjectKey imicKey = new DatabaseObjectKey(imic.connectionName, null, null, imic.name);
            imic.datasetName = this.createDatasetName(st2, imic.name);
            imic.existingDatasetsNames = usedDatasets.existingDatasetsPerElasticSearchIndex.get((Object)imicKey);
            result.elasticSearchImportCandidates.add(imic);
        }
        return result;
    }

    private TableImportCandidates getTableImportCandidatesFromSQLCandidates(String targetProjectKey, List<SQLTableImportCandidate> initialCandidates) throws Exception {
        assert (targetProjectKey != null);
        TableImportCandidates result = new TableImportCandidates();
        StringTransmogrifier st2 = new StringTransmogrifier();
        AlreadyUsedDatasets usedDatasets = new AlreadyUsedDatasets();
        usedDatasets.findAlreadyUsedDatasets(targetProjectKey, st2);
        for (SQLTableImportCandidate imic : initialCandidates) {
            DatabaseObjectKey imicKey = new DatabaseObjectKey(imic.connectionName, imic.catalog, imic.schema, imic.table);
            imic.datasetName = this.createDatasetName(st2, imic.table);
            imic.existingDatasetsNames = usedDatasets.existingDatasetsPerSQLTable.get((Object)imicKey);
            result.sqlImportCandidates.add(imic);
        }
        return result;
    }

    private TableImportCandidates getTableImportCandidatesFromIcebergCandidates(String targetProjectKey, List<IcebergTableImportCandidate> initialCandidates) throws Exception {
        assert (targetProjectKey != null);
        TableImportCandidates result = new TableImportCandidates();
        StringTransmogrifier st2 = new StringTransmogrifier();
        AlreadyUsedDatasets usedDatasets = new AlreadyUsedDatasets();
        usedDatasets.findAlreadyUsedDatasets(targetProjectKey, st2);
        for (IcebergTableImportCandidate imic : initialCandidates) {
            DatabaseObjectKey imicKey = new DatabaseObjectKey(imic.connectionName, null, imic.schema, imic.table);
            imic.datasetName = this.createDatasetName(st2, imic.table);
            imic.existingDatasetsNames = usedDatasets.existingDatasetsPerIcebergTable.get((Object)imicKey);
            result.icebergImportCandidates.add(imic);
        }
        return result;
    }

    private String createDatasetName(StringTransmogrifier st2, String tableOrIndex) {
        String slug = StringNormalizer.normalize((String)tableOrIndex);
        slug = slug.replaceAll("[^a-zA-Z0-9_]", "_");
        return st2.transmogrify(slug);
    }

    public FutureResponse<TableImportCandidates> startGetTableImportCandidatesFromExplorer_NT(AuthCtx authCtx, String targetProjectKey, ConnectionsImportController.ExplorerWorkflowType workflowType, String tables) throws Exception {
        switch (workflowType) {
            case SQL: {
                List mics = (List)JSON.parse((String)tables, (TypeToken)new TypeToken<List<SQLTableImportCandidate>>(){});
                FutureResponse fr = new FutureResponse();
                fr.hasResult = true;
                fr.result = this.getTableImportCandidatesFromSQLCandidates(targetProjectKey, mics);
                return fr;
            }
            case HIVE: {
                List mics = (List)JSON.parse((String)tables, (TypeToken)new TypeToken<List<HiveImportabilityChecker.HiveTableImportCandidate>>(){});
                ArrayList<DatabaseObjectKey> doks = new ArrayList<DatabaseObjectKey>();
                for (HiveImportabilityChecker.HiveTableImportCandidate htic : mics) {
                    doks.add(new DatabaseObjectKey(htic.sourceVirtualConnection, null, htic.databaseName, htic.table));
                }
                return this.startGetTableImportCandidatesFromKeys_NT(targetProjectKey, doks, null, null, authCtx);
            }
            case ELASTIC_SEARCH: {
                List mics = (List)JSON.parse((String)tables, (TypeToken)new TypeToken<List<ElasticSearchIndexImportCandidate>>(){});
                FutureResponse fr = new FutureResponse();
                fr.hasResult = true;
                fr.result = this.getImportCandidatesFromElasticSearchCandidates(targetProjectKey, mics);
                return fr;
            }
            case ICEBERG: {
                List mics = (List)JSON.parse((String)tables, (TypeToken)new TypeToken<List<IcebergTableImportCandidate>>(){});
                FutureResponse fr = new FutureResponse();
                fr.hasResult = true;
                fr.result = this.getTableImportCandidatesFromIcebergCandidates(targetProjectKey, mics);
                return fr;
            }
        }
        throw new IllegalArgumentException("Unsupported workflow type: " + String.valueOf((Object)workflowType));
    }

    public FutureResponse<TableImportCandidates> startGetTableImportCandidatesFromKeys_NT(final String targetProjectKey, final List<DatabaseObjectKey> tables, final List<String> remarks, final String targetConnection, final AuthCtx u) throws Exception {
        SimpleFutureThread<TableImportCandidates> sft = new SimpleFutureThread<TableImportCandidates>(u){

            @Override
            public TableImportCandidates compute() throws Exception {
                TableImportCandidates result = new TableImportCandidates();
                StringTransmogrifier st2 = new StringTransmogrifier();
                AlreadyUsedDatasets usedDatasets = new AlreadyUsedDatasets();
                usedDatasets.findAlreadyUsedDatasets(targetProjectKey, st2);
                HiveImportabilityChecker hiveImportabilityChecker = new HiveImportabilityChecker();
                List<HDFSAbleConnection> hdfsConnections = ConnectionsImportService.this.connectionsService.listUsableHdfsAbleConnectionsUnsafe(u, targetConnection);
                try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)"Computing Hive tables import", (double)tables.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    int tableIndex = 0;
                    for (DatabaseObjectKey tableKey : tables) {
                        try (FutureProgress.AutocloseableFutureProgressState fp2 = FutureProgress.pushAutoCloseableState((String)("Computing Hive import for " + tableKey.name));){
                            ConnectionsDAO.VirtualConnectionId vc = ConnectionsDAO.parseVirtualConnection(tableKey.connectionName);
                            if (vc != null) {
                                String clusterId = new ClusterSelector().getClusterForProject(targetProjectKey, Cluster.ClusterArchitecture.HADOOP);
                                switch (vc.getType()) {
                                    case HIVE_JDBC: {
                                        DSSConnection connection = ConnectionsImportService.this.connectionsDAO.getConnection(this.owner, tableKey.connectionName);
                                        assert (connection instanceof HiveConnection);
                                        HiveConnection hiveConnection = (HiveConnection)connection;
                                        try {
                                            TableSchema hiveTableSchema = ConnectionsImportService.this.metastoreInspectionService.newInspector(this.owner, targetProjectKey).getTableSchema(clusterId, tableKey.schema, tableKey.name, null, u, targetProjectKey);
                                            HiveImportabilityChecker.HiveTableImportCandidate hiveTableImportResult = hiveImportabilityChecker.computeTableImportCandidate(targetProjectKey, clusterId, u, hiveConnection.getDatabaseName(), tableKey.name, null, hiveTableSchema, st2, hdfsConnections, usedDatasets.alreadyImportedHiveTables);
                                            hiveTableImportResult.sourceVirtualConnection = vc.getId();
                                            result.hiveImportCandidates.add(hiveTableImportResult);
                                        }
                                        catch (Exception e) {
                                            logger.error((Object)"Failed to prepare table candidate", (Throwable)e);
                                            result.hiveImportCandidates.add(HiveImportabilityChecker.HiveTableImportCandidate.ofError(hiveConnection.getDatabaseName(), tableKey.name, e));
                                        }
                                        break;
                                    }
                                    default: {
                                        throw new Error("Illegal virtual connection type " + String.valueOf((Object)vc.getType()));
                                    }
                                }
                            } else {
                                DSSConnection connection = ConnectionsImportService.this.connectionsDAO.getConnection(this.owner, tableKey.connectionName);
                                if (connection instanceof ElasticSearchConnection) {
                                    ElasticSearchIndexImportCandidate mic = this.createElasticSearchImportCandidate(st2, tableKey);
                                    result.elasticSearchImportCandidates.add(mic);
                                } else if (connection instanceof IcebergConnection) {
                                    remark = remarks != null && tableIndex < remarks.size() ? (String)remarks.get(tableIndex++) : null;
                                    mic = this.createIcebergTableImportCandidate(targetProjectKey, st2, usedDatasets.existingDatasetsPerIcebergTable.get((Object)tableKey), tableKey, remark);
                                    result.icebergImportCandidates.add((IcebergTableImportCandidate)mic);
                                } else {
                                    remark = remarks != null && tableIndex < remarks.size() ? (String)remarks.get(tableIndex++) : null;
                                    mic = this.createSQLTableImportCandidate(targetProjectKey, st2, usedDatasets.existingDatasetsPerSQLTable.get((Object)tableKey), tableKey, remark);
                                    result.sqlImportCandidates.add((SQLTableImportCandidate)mic);
                                }
                            }
                        }
                        FutureProgress.incrementState((double)1.0);
                    }
                }
                return result;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"get-table-import-candidates", (String)"Compute tables importability from catalog");
            }

            private SQLTableImportCandidate createSQLTableImportCandidate(String targetProjectKey2, StringTransmogrifier st2, Collection<String> alreadyImportedDatasets, DatabaseObjectKey tableKey, String remark) {
                SQLTableImportCandidate mic = new SQLTableImportCandidate();
                mic.connectionName = tableKey.connectionName;
                mic.projectKey = targetProjectKey2;
                mic.table = tableKey.name;
                mic.catalog = tableKey.catalog;
                mic.schema = tableKey.getSchema();
                mic.datasetName = ConnectionsImportService.this.createDatasetName(st2, tableKey.name);
                mic.existingDatasetsNames = alreadyImportedDatasets;
                mic.remarks = remark;
                return mic;
            }

            private IcebergTableImportCandidate createIcebergTableImportCandidate(String targetProjectKey2, StringTransmogrifier st2, Collection<String> alreadyImportedDatasets, DatabaseObjectKey tableKey, String remark) {
                IcebergTableImportCandidate mic = new IcebergTableImportCandidate();
                mic.connectionName = tableKey.connectionName;
                mic.projectKey = targetProjectKey2;
                mic.table = tableKey.name;
                mic.schema = tableKey.getSchema();
                mic.datasetName = ConnectionsImportService.this.createDatasetName(st2, tableKey.name);
                mic.existingDatasetsNames = alreadyImportedDatasets;
                mic.remarks = remark;
                return mic;
            }

            private ElasticSearchIndexImportCandidate createElasticSearchImportCandidate(StringTransmogrifier st2, DatabaseObjectKey tableKey) {
                ElasticSearchIndexImportCandidate mic = new ElasticSearchIndexImportCandidate();
                mic.connectionName = tableKey.connectionName;
                mic.name = tableKey.name;
                mic.datasetName = ConnectionsImportService.this.createDatasetName(st2, tableKey.name);
                return mic;
            }
        };
        return this.futureService.runFuture(sft, 0L, new TypeToken<FutureResponse<TableImportCandidates>>(){});
    }

    public FutureResponse<InfoMessage.InfoMessages> massImportCandidates(String projectKey, List<SQLTableImportCandidate> sqlCandidates, List<HiveImportabilityChecker.HiveTableImportCandidate> hiveCandidates, List<ElasticSearchIndexImportCandidate> elasticSearchCandidates, List<IcebergTableImportCandidate> icebergCandidates, AuthCtx authCtx, String zoneId) throws Exception {
        MassImportCandidatesThread ft = new MassImportCandidatesThread(projectKey, sqlCandidates, hiveCandidates, elasticSearchCandidates, icebergCandidates, authCtx, zoneId);
        return this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    private static class ListSQLMassImportTablesThread
    extends SimpleFutureThread<SQLTableImportData> {
        private final AbstractSQLConnection connection;
        private final String sourceCatalog;
        private final String sourceSchema;
        private final String projectKey;

        public ListSQLMassImportTablesThread(AbstractSQLConnection connection, String sourceCatalog, String sourceSchema, AuthCtx authCtx, String projectKey) {
            super(authCtx);
            this.connection = connection;
            this.sourceCatalog = sourceCatalog;
            this.sourceSchema = sourceSchema;
            this.projectKey = projectKey;
        }

        @Override
        protected SQLTableImportData compute() throws Exception {
            SQLTableImportData ret = new SQLTableImportData();
            SQLConnectionProvider.SQLConnectionData connData = SQLConnectionProvider.getConnectionData_NT((AuthCtx)this.owner, this.projectKey, this.connection.name);
            ret.connectionType = connData.getConnection().getType();
            try (SQLConnectionProvider.SQLConnectionWrapper wrapper = SQLConnectionProvider.newConnection(connData, (AuthCtx)this.owner, this.projectKey);){
                try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Listing tables", (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    String catalog = StringUtils.isBlank((String)this.sourceCatalog) ? null : this.sourceCatalog;
                    String schema = StringUtils.isBlank((String)this.sourceSchema) ? null : this.sourceSchema;
                    List<SQLUtils.SQLTable> tables = SQLUtils.listTables(connData, wrapper, catalog, schema, connData.getDialect());
                    state.increment(1.0);
                    for (SQLUtils.SQLTable table : tables) {
                        SQLTableImportCandidate mic = new SQLTableImportCandidate();
                        mic.connectionName = this.connection.name;
                        mic.table = table.getTable();
                        mic.catalog = table.getCatalog();
                        mic.schema = table.getSchemaNullIfBlank();
                        mic.remarks = table.getRemarks();
                        mic.type = table.type;
                        mic.systemTable = SQLUtils.isSystemTable(connData.getType(), mic.catalog, mic.schema, mic.table, mic.type);
                        ret.tables.add(mic);
                    }
                    state.increment(1.0);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to list tables", (Throwable)e);
                    if (ret.tables.isEmpty()) {
                        throw new SQLException("Failed to list tables", e);
                    }
                }
            }
            return ret;
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "sql_table_importability";
            fp.displayName = "List importable SQL tables in " + this.connection.name;
            return fp;
        }
    }

    private static class ListIcebergMassImportTablesThread
    extends SimpleFutureThread<IcebergTableImportData> {
        private final IcebergConnection connection;
        private final String projectKey;
        private final String namespace;

        public ListIcebergMassImportTablesThread(IcebergConnection connection, AuthCtx authCtx, String projectKey, String namespace) {
            super(authCtx);
            this.connection = connection;
            this.projectKey = projectKey;
            this.namespace = namespace;
        }

        @Override
        protected IcebergTableImportData compute() throws Exception {
            IcebergTableImportData ret = new IcebergTableImportData();
            ret.connectionType = this.connection.getType();
            IcebergUtils utils = new IcebergUtils();
            PrivilegedExceptionAction<IcebergTableImportData> action = () -> {
                Catalog icebergCatalog = this.connection.getIcebergCatalog(this.owner, this.projectKey);
                try {
                    FutureProgress.AutocloseableFutureProgressState state;
                    List<Object> namespaces;
                    if (StringUtils.isNotBlank((String)this.namespace)) {
                        namespaces = Lists.newArrayList((Object[])new String[]{this.namespace});
                    } else {
                        state = FutureProgress.pushAutoCloseableState((String)"Listing namespaces", (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                        try {
                            if (icebergCatalog instanceof SupportsNamespaces) {
                                namespaces = utils.listNamespacesRecursively((SupportsNamespaces)icebergCatalog);
                            } else {
                                namespaces = new ArrayList();
                                namespaces.add("");
                            }
                        }
                        finally {
                            if (state != null) {
                                state.close();
                            }
                        }
                    }
                    state = FutureProgress.pushAutoCloseableState((String)"Listing tables", (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                    try {
                        for (String string : namespaces) {
                            logger.info((Object)("List tables in namespace " + string));
                            Namespace icebergNamespace = utils.toNamespace(string);
                            try {
                                for (TableIdentifier tableId : icebergCatalog.listTables(icebergNamespace)) {
                                    IcebergTableImportCandidate mic = new IcebergTableImportCandidate();
                                    mic.connectionName = this.connection.name;
                                    mic.table = tableId.name();
                                    mic.schema = utils.namespaceToQuotedString(tableId.namespace());
                                    ret.tables.add(mic);
                                }
                            }
                            catch (Exception e) {
                                logger.warn((Object)("Unable to list tables in namespace " + string), (Throwable)e);
                            }
                        }
                    }
                    finally {
                        if (state != null) {
                            state.close();
                        }
                    }
                }
                finally {
                    if (icebergCatalog instanceof Closeable) {
                        ((Closeable)icebergCatalog).close();
                    }
                }
                return ret;
            };
            return utils.getUgi(this.connection, this.owner, this.projectKey).doAs(action);
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "iceberg_table_importability";
            fp.displayName = "List importable Iceberg tables in " + this.connection.name;
            return fp;
        }
    }

    private static class ListElasticSearchMassImportIndicesThread
    extends SimpleFutureThread<ElasticSearchIndicesImportData> {
        private final ElasticSearchConnection connection;

        public ListElasticSearchMassImportIndicesThread(ElasticSearchConnection connection, AuthCtx authCtx) {
            super(authCtx);
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ElasticSearchIndicesImportData compute() throws Exception {
            ElasticSearchIndicesImportData ret = new ElasticSearchIndicesImportData();
            String address = this.connection.getServerAddress();
            try (ElasticSearchHttpClient client = this.connection.getHttpClient(this.owner, null);){
                HashMap<String, ElasticSearchIndexImportData> candidates = new HashMap<String, ElasticSearchIndexImportData>();
                try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Listing ElasticSearch indices", (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    Map<String, Integer> indicesWithCount = ElasticSearchUtils.listIndicesWithCount(client, address);
                    for (Map.Entry<String, Integer> entry : indicesWithCount.entrySet()) {
                        ElasticSearchIndexImportData candidate = new ElasticSearchIndexImportData();
                        candidate.connectionName = this.connection.name;
                        candidate.count = entry.getValue();
                        candidate.name = entry.getKey();
                        candidate.type = ElasticSearchIndexType.INDEX;
                        candidate.aliasesOrIndices = new HashSet<String>();
                        candidates.put(candidate.name, candidate);
                    }
                    state.increment(1.0);
                    HttpResponse resp = client.execute((HttpUriRequest)new HttpGet(address + "_aliases"), false, "Couldn't fetch aliases", new int[0]);
                    try {
                        JSONObject jresp = new JSONObject(ElasticSearchUtils.tryToGetString(resp.getEntity().getContent()));
                        Iterator indices = jresp.keys();
                        while (indices.hasNext()) {
                            String index = (String)indices.next();
                            if (!candidates.containsKey(index)) continue;
                            Iterator aliases = jresp.getJSONObject(index).getJSONObject("aliases").keys();
                            while (aliases.hasNext()) {
                                ElasticSearchIndexImportData candidateAlias;
                                String alias = (String)aliases.next();
                                ElasticSearchIndexImportData candidateIndex = (ElasticSearchIndexImportData)candidates.get(index);
                                candidateIndex.aliasesOrIndices.add(alias);
                                if (!candidates.containsKey(alias)) {
                                    candidateAlias = new ElasticSearchIndexImportData();
                                    candidateAlias.connectionName = this.connection.name;
                                    candidateAlias.count = 0;
                                    candidateAlias.name = alias;
                                    candidateAlias.type = ElasticSearchIndexType.ALIAS;
                                    candidateAlias.aliasesOrIndices = new HashSet<String>();
                                    candidates.put(candidateAlias.name, candidateAlias);
                                }
                                candidateAlias = (ElasticSearchIndexImportData)candidates.get(alias);
                                candidateAlias.aliasesOrIndices.add(candidateIndex.name);
                                candidateAlias.count += candidateIndex.count;
                            }
                        }
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)resp.getEntity());
                    }
                    state.increment(1.0);
                    ret.tables.addAll(candidates.values());
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to fetch indices", (Throwable)e);
                }
            }
            return ret;
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "sql_table_importability";
            fp.displayName = "List importable SQL tables in " + this.connection.name;
            return fp;
        }
    }

    private class ListHiveMassImportTablesThread
    extends SimpleFutureThread<HiveImportabilityChecker.HiveTablesImportCandidates> {
        private final ConnectionsDAO.VirtualConnectionId virtualConnection;
        private final String projectKey;

        public ListHiveMassImportTablesThread(String projectKey, AuthCtx authCtx, ConnectionsDAO.VirtualConnectionId virtualConnection) {
            super(authCtx);
            this.projectKey = projectKey;
            this.virtualConnection = virtualConnection;
        }

        @Override
        protected HiveImportabilityChecker.HiveTablesImportCandidates compute() throws Exception {
            logger.info((Object)("Reading tables from virtual connection: " + JSON.log((Object)this.virtualConnection)));
            HiveImportabilityChecker.HiveTablesImportCandidates ret = new HiveImportabilityChecker.HiveTablesImportCandidates();
            String clusterId = new ClusterSelector().getClusterForProject(this.projectKey, Cluster.ClusterArchitecture.HADOOP);
            ConnectionsDAO.VirtualConnectionType type = ConnectionsDAO.VirtualConnectionType.forId(this.virtualConnection.type);
            List<String> tables = null;
            switch (type) {
                case HIVE_JDBC: {
                    tables = ConnectionsImportService.this.metastoreInspectionService.newInspector(this.owner, null).listHiveTables(clusterId, this.virtualConnection.db, this.owner, this.projectKey);
                    break;
                }
                case IMPALA_JDBC: 
                case HIVE_HPROXY: 
                case SPARK_LIVY: {
                    throw new Error("Unexpected virtual connection type: " + String.valueOf((Object)type));
                }
            }
            for (String table : tables) {
                HiveImportabilityChecker.HiveTableImportCandidate item = new HiveImportabilityChecker.HiveTableImportCandidate();
                item.sourceVirtualConnection = this.virtualConnection.getId();
                item.table = table;
                item.databaseName = this.virtualConnection.db;
                ret.tables.add(item);
            }
            return ret;
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "hive_table_importability";
            if (this.projectKey != null) {
                fp.targets.add(new FuturePayload.FuturePayloadTarget(this.projectKey, ITaggingService.TaggableType.PROJECT.name()));
            }
            fp.withExtra("database", (Object)this.virtualConnection.db);
            fp.displayName = "List importable Hive tables in " + this.virtualConnection.db;
            return fp;
        }
    }

    public static class TableImportCandidates {
        public List<SQLTableImportCandidate> sqlImportCandidates = new ArrayList<SQLTableImportCandidate>();
        public List<IcebergTableImportCandidate> icebergImportCandidates = new ArrayList<IcebergTableImportCandidate>();
        public List<HiveImportabilityChecker.HiveTableImportCandidate> hiveImportCandidates = new ArrayList<HiveImportabilityChecker.HiveTableImportCandidate>();
        public List<ElasticSearchIndexImportCandidate> elasticSearchImportCandidates = new ArrayList<ElasticSearchIndexImportCandidate>();
    }

    class AlreadyUsedDatasets {
        Map<String, SQLUtils.SQLTable> alreadyImportedHiveTables = Maps.newHashMap();
        Multimap<DatabaseObjectKey, String> existingDatasetsPerSQLTable = HashMultimap.create();
        Multimap<DatabaseObjectKey, String> existingDatasetsPerElasticSearchIndex = HashMultimap.create();
        Multimap<DatabaseObjectKey, String> existingDatasetsPerIcebergTable = HashMultimap.create();

        AlreadyUsedDatasets() {
        }

        void findAlreadyUsedDatasets(String targetProjectKey, StringTransmogrifier st2) throws IOException {
            if (StringUtils.isBlank((String)targetProjectKey)) {
                return;
            }
            try (Transaction t = ConnectionsImportService.this.transactionService.beginRead();){
                for (SerializedDataset d : ConnectionsImportService.this.dao.listUnsafe(targetProjectKey)) {
                    st2.addAlreadyTransmogrified(d.name);
                    this.getTableImportCandidate(d);
                }
            }
        }

        private void getTableImportCandidate(SerializedDataset d) {
            DatabaseObjectKey dok;
            if (DatasetInspector.isSQLTable(d)) {
                DatabaseObjectKey dok2 = this.createDatabaseObjectKeyForSQLTable(d);
                if (dok2 != null) {
                    this.existingDatasetsPerSQLTable.put((Object)dok2, (Object)d.name);
                }
            } else if (DatasetInspector.canHiveTable(d)) {
                try {
                    SQLUtils.SQLTable table = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(d);
                    if (StringUtils.isNotBlank((String)table.getTable())) {
                        this.alreadyImportedHiveTables.put(d.getDisplayName(), table);
                    }
                }
                catch (Throwable e) {
                    logger.warn((Object)("Cannot get dataset's table : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
            } else if (DatasetInspector.isElasticSearch(d)) {
                DatabaseObjectKey dok3 = this.createDatabaseObjectKeyForElasticSearch(d);
                if (dok3 != null) {
                    this.existingDatasetsPerElasticSearchIndex.put((Object)dok3, (Object)d.name);
                }
            } else if (DatasetInspector.isFSBasedTabular(d) && (dok = this.createDatabaseObjectKeyForIceberg(d)) != null) {
                this.existingDatasetsPerIcebergTable.put((Object)dok, (Object)d.name);
            }
        }

        private DatabaseObjectKey createDatabaseObjectKeyForElasticSearch(SerializedDataset d) {
            try {
                DatasetHandler.DatasetParams params = d.getParams();
                ElasticSearchDatasetHandler.Config config = (ElasticSearchDatasetHandler.Config)params;
                if (StringUtils.isBlank((String)config.index)) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No index specified in dataset " + d.getFullName());
                }
                return new DatabaseObjectKey(config.connection, null, null, config.index);
            }
            catch (Exception e) {
                logger.error((Object)("Inspecting dataset " + d.getFullName() + " to check if already imported failed"), (Throwable)e);
                return null;
            }
        }

        private DatabaseObjectKey createDatabaseObjectKeyForSQLTable(SerializedDataset d) {
            DatabaseObjectKey databaseObjectKey;
            block9: {
                DatasetHandler.DatasetParams params = d.getParams();
                Dataset ds = Dataset.fromSerializedUnsafe(d);
                AbstractSQLDatasetHandler.AbstractSQLConfig config = (AbstractSQLDatasetHandler.AbstractSQLConfig)params;
                if (StringUtils.isBlank((String)config.table)) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No table specified in dataset " + d.getFullName());
                }
                AbstractSQLTableDatasetHandler handler = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(DSSAuthCtx.newNone(), ds);
                try {
                    SQLUtils.SQLTable orig = handler.getResolvedTable();
                    databaseObjectKey = new DatabaseObjectKey(handler.getConnectionName(), orig.getCatalog(), orig.getSchemaNullIfBlank(), orig.getTable());
                    if (handler == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (handler != null) {
                            try {
                                handler.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.error((Object)("Inspecting dataset " + d.getFullName() + " to check if already imported failed"), (Throwable)e);
                        return null;
                    }
                }
                handler.close();
            }
            return databaseObjectKey;
        }

        private DatabaseObjectKey createDatabaseObjectKeyForIceberg(SerializedDataset d) {
            DatasetHandler.DatasetParams params = d.getParams();
            Dataset ds = Dataset.fromSerializedUnsafe(d);
            IcebergDatasetParams config = (IcebergDatasetParams)params;
            if (StringUtils.isBlank((String)config.table)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No table specified in dataset " + d.getFullName());
            }
            IcebergDatasetHandler handler = (IcebergDatasetHandler)DatasetHandlerFactory.build(DSSAuthCtx.newNone(), ds);
            try {
                TableIdentifier tableId = handler.resolveTableIdentifier();
                DatabaseObjectKey databaseObjectKey = new DatabaseObjectKey(((IcebergDatasetParams)params).connection, null, new IcebergUtils().namespaceToQuotedString(tableId.namespace()), tableId.name());
                if (handler != null) {
                    handler.close();
                }
                return databaseObjectKey;
            }
            catch (Throwable throwable) {
                try {
                    if (handler != null) {
                        try {
                            handler.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error((Object)("Inspecting dataset " + d.getFullName() + " to check if already imported failed"), (Throwable)e);
                    return null;
                }
            }
        }
    }

    public static class ElasticSearchIndexImportCandidate
    extends ElasticSearchIndexImportInfo {
        public Collection<String> existingDatasetsNames;
        public String datasetName;
    }

    public static class SQLTableImportCandidate
    extends ImportInfo {
        public String catalog;
        public String schema;
        public String table;
        public String type;
        public String remarks;
        public boolean checked;
        public boolean systemTable;
        public String projectKey;
        public Collection<String> existingDatasetsNames;
        public String datasetName;

        @Override
        String getName() {
            return this.table;
        }
    }

    public static class IcebergTableImportCandidate
    extends ImportInfo {
        public String schema;
        public String table;
        public String type;
        public String remarks;
        public boolean checked;
        public String projectKey;
        public Collection<String> existingDatasetsNames;
        public String datasetName;

        @Override
        String getName() {
            return this.table;
        }
    }

    private class MassImportCandidatesThread
    extends SimpleFutureThread<InfoMessage.InfoMessages> {
        private final int numberOfSteps;
        private final List<SQLTableImportCandidate> sqlCandidates;
        private final List<HiveImportabilityChecker.HiveTableImportCandidate> hiveCandidates;
        private final List<IcebergTableImportCandidate> icebergCandidates;
        private final List<ElasticSearchIndexImportCandidate> elasticSearchCandidates;
        private final String zoneId;
        private final String projectKey;

        public MassImportCandidatesThread(String projectKey, List<SQLTableImportCandidate> sqlCandidates, List<HiveImportabilityChecker.HiveTableImportCandidate> hiveCandidates, List<ElasticSearchIndexImportCandidate> elasticSearchCandidates, List<IcebergTableImportCandidate> icebergCandidates, AuthCtx owner, String zoneId) {
            super(owner);
            this.projectKey = projectKey;
            this.sqlCandidates = sqlCandidates;
            this.hiveCandidates = hiveCandidates;
            this.icebergCandidates = icebergCandidates;
            this.elasticSearchCandidates = elasticSearchCandidates;
            this.zoneId = zoneId;
            int numberOfSteps = 0;
            if (sqlCandidates != null && !sqlCandidates.isEmpty()) {
                numberOfSteps += 2;
            }
            if (hiveCandidates != null && !hiveCandidates.isEmpty()) {
                numberOfSteps += 2;
            }
            if (elasticSearchCandidates != null && !elasticSearchCandidates.isEmpty()) {
                numberOfSteps += 2;
            }
            if (icebergCandidates != null && !icebergCandidates.isEmpty()) {
                numberOfSteps += 2;
            }
            this.numberOfSteps = numberOfSteps;
        }

        @Override
        protected InfoMessage.InfoMessages compute() throws Exception {
            try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Import tables or indices", (double)this.numberOfSteps, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                InfoMessage.InfoMessages messages;
                ImportResults importer;
                InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
                if (!this.hiveCandidates.isEmpty()) {
                    logger.info((Object)("Import: creating Hive datasets " + this.hiveCandidates.size()));
                    List<HiveImportabilityChecker.HiveTableImportCandidate> preparedCandidates = this.prepareHiveDatasets();
                    state.increment(1.0);
                    ret.mergeFrom(this.saveHiveDatasets(preparedCandidates));
                    state.increment(1.0);
                }
                if (!this.sqlCandidates.isEmpty()) {
                    logger.info((Object)("Import: creating SQL datasets " + this.sqlCandidates.size()));
                    importer = new SQLTablesImportResult();
                    messages = importer.importCandidates(this.zoneId, state, this.sqlCandidates);
                    ret.mergeFrom(messages);
                }
                if (!this.elasticSearchCandidates.isEmpty()) {
                    logger.info((Object)("Import: creating ElasticSearch datasets from " + this.elasticSearchCandidates.size() + " indices"));
                    importer = new ElasticSearchIndicesImportResult();
                    messages = importer.importCandidates(this.zoneId, state, this.elasticSearchCandidates);
                    ret.mergeFrom(messages);
                }
                if (!this.icebergCandidates.isEmpty()) {
                    logger.info((Object)("Import: creating Iceberg datasets from " + this.icebergCandidates.size() + " tables"));
                    importer = new IcebergTablesImportResult();
                    messages = importer.importCandidates(this.zoneId, state, this.icebergCandidates);
                    ret.mergeFrom(messages);
                }
                ConnectionsImportService.this.graphService.invalidateCache();
                InfoMessage.InfoMessages infoMessages = ret;
                return infoMessages;
            }
        }

        private InfoMessage.InfoMessages saveHiveDatasets(List<HiveImportabilityChecker.HiveTableImportCandidate> importabilities) throws InterruptedException, IOException {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            try (RWTransaction t = ConnectionsImportService.this.transactionService.beginWriteAsLoggedInUser((AuthCtx)this.owner);){
                try (FutureProgress.AutocloseableFutureProgressState listState = FutureProgress.pushAutoCloseableState((String)"Create datasets", (double)importabilities.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    for (HiveImportabilityChecker.HiveTableImportCandidate importability : importabilities) {
                        if (!importability.messages.anyFatal()) {
                            try {
                                if (importability.newDataset != null) {
                                    logger.info((Object)("Saving dataset " + importability.newDataset.name));
                                    importability.newDataset.tags.add("origin:hive_import:" + importability.databaseName);
                                    DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildDefault();
                                    dsCtx.setZoneId(this.zoneId);
                                    ConnectionsImportService.this.datasetSaveService.create(importability.newDataset.projectKey, importability.newDataset, dsCtx, this.owner);
                                    importability.messages.withSuccess((InfoMessage.MessageCode)HiveImportabilityChecker.ImportCodes.INFO_IMPORT_SUCCESS, "Table '" + importability.table + "' imported as dataset '" + importability.newDataset.name + "'");
                                }
                            }
                            catch (Throwable t2) {
                                logger.error((Object)"Import failed", t2);
                                importability.messages.withFatal((InfoMessage.MessageCode)HiveImportabilityChecker.ImportCodes.ERR_IMPORT_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)t2));
                            }
                        }
                        ret.mergeFrom(importability.messages);
                        listState.increment(1.0);
                        FutureProgressState.checkInterrupt();
                    }
                }
                t.commit("Imported datasets from Hive db into project " + this.projectKey);
            }
            return ret;
        }

        private List<HiveImportabilityChecker.HiveTableImportCandidate> prepareHiveDatasets() throws Exception {
            ArrayList importabilities = Lists.newArrayList();
            StringTransmogrifier st2 = new StringTransmogrifier();
            try (Transaction t = ConnectionsImportService.this.transactionService.beginRead();){
                for (SerializedDataset d : ConnectionsImportService.this.dao.listUnsafe(this.projectKey)) {
                    st2.addAlreadyTransmogrified(d.name);
                }
            }
            try (FutureProgress.AutocloseableFutureProgressState listState = FutureProgress.pushAutoCloseableState((String)"Prepare Hive datasets", (double)this.hiveCandidates.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                for (HiveImportabilityChecker.HiveTableImportCandidate initCandidate : this.hiveCandidates) {
                    logger.info((Object)("Importing " + JSON.log((Object)initCandidate)));
                    ArrayList connections = Lists.newArrayList();
                    if (initCandidate.selectedConnection == null) {
                        throw new IllegalArgumentException("No connection selected for " + initCandidate.table);
                    }
                    if (initCandidate.selectedConnection.type == HiveImportabilityChecker.PossibleConnection.Type.FILES) {
                        HDFSAbleConnection connection = (HDFSAbleConnection)((Object)ConnectionsImportService.this.connectionsDAO.getConnection(this.owner, initCandidate.selectedConnection.connectionName));
                        connections.add(connection);
                    }
                    ConnectionsDAO.VirtualConnectionId vc = ConnectionsDAO.parseVirtualConnection(initCandidate.sourceVirtualConnection);
                    assert (vc != null);
                    String clusterId = new ClusterSelector().getClusterForProject(this.projectKey, Cluster.ClusterArchitecture.HADOOP);
                    TableSchema hiveTableSchema = null;
                    switch (vc.getType()) {
                        case HIVE_JDBC: {
                            hiveTableSchema = ConnectionsImportService.this.metastoreInspectionService.newInspector(this.owner, this.projectKey).getTableSchema(clusterId, initCandidate.databaseName, initCandidate.table, null, this.owner, this.projectKey);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal virtual connection type " + String.valueOf((Object)vc.getType()));
                        }
                    }
                    HiveImportabilityChecker.HiveTableImportCandidate ret = new HiveImportabilityChecker.HiveTableImportCandidate();
                    try {
                        HiveImportabilityChecker checker = new HiveImportabilityChecker();
                        ret = checker.computeTableImportCandidate(this.projectKey, clusterId, this.owner, initCandidate.databaseName, initCandidate.table, initCandidate.selectedConnection, hiveTableSchema, st2, connections, new HashMap<String, SQLUtils.SQLTable>());
                        if (!ret.messages.anyFatal()) {
                            ret.newDataset.projectKey = this.projectKey;
                            if (StringUtils.isNotBlank((String)initCandidate.datasetName)) {
                                ret.newDataset.name = initCandidate.datasetName;
                            }
                        }
                    }
                    catch (Throwable t) {
                        logger.error((Object)"Import failed", t);
                        ret.messages.withFatal((InfoMessage.MessageCode)HiveImportabilityChecker.ImportCodes.ERR_IMPORT_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)t));
                    }
                    importabilities.add(ret);
                    listState.increment(1.0);
                    FutureProgressState.checkInterrupt();
                }
            }
            return importabilities;
        }

        public FuturePayload getPayload() {
            return null;
        }

        private class SQLTablesImportResult
        extends ImportResults<SQLTableImportCandidate> {
            public List<SQLOrElasticSearchImportResult> tables;

            private SQLTablesImportResult() {
                this.tables = new ArrayList<SQLOrElasticSearchImportResult>();
            }

            @Override
            protected void saveDatasets(String zoneId) throws InterruptedException, TransactionFailedException, TransactionGitException {
                this.saveDatasets(zoneId, "Table", "SQL Tables", HiveImportabilityChecker.ImportCodes.INFO_IMPORT_SUCCESS, HiveImportabilityChecker.ImportCodes.ERR_IMPORT_FAILED);
            }

            private void assignErrorMessageToResult(List<SQLTableImportCandidate> massImportCandidates, String message) {
                this.assignErrorMessageToResult(massImportCandidates, message, "table");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void prepareDatasets(List<SQLTableImportCandidate> candidates) throws IOException, InterruptedException, DKUSecurityException, SQLException {
                Map<String, List<SQLTableImportCandidate>> massImportCandidatesByConnection = this.groupCandidatesByConnection(candidates);
                try (FutureProgress.AutocloseableFutureProgressState listState = FutureProgress.pushAutoCloseableState((String)"Preparing SQL datasets", (double)candidates.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    for (Map.Entry<String, List<SQLTableImportCandidate>> massImportCandidatesWithConnectionName : massImportCandidatesByConnection.entrySet()) {
                        String connectionName = massImportCandidatesWithConnectionName.getKey();
                        DSSConnection connection = ConnectionsImportService.this.connectionsDAO.getConnection(MassImportCandidatesThread.this.owner, connectionName);
                        if (!(connection instanceof AbstractSQLConnection)) {
                            this.assignErrorMessageToResult(massImportCandidatesWithConnectionName.getValue(), String.format("Expected SQL connection type, got %s", connection.getType()));
                            continue;
                        }
                        if (!connection.isFreelyUsableBy(MassImportCandidatesThread.this.owner)) {
                            this.assignErrorMessageToResult(massImportCandidatesWithConnectionName.getValue(), String.format("Cannot use connection %s", connection.name));
                            continue;
                        }
                        SQLConnectionProvider.SQLConnectionData connData = ((AbstractSQLConnection)connection).getConnectionData_NT(MassImportCandidatesThread.this.owner, MassImportCandidatesThread.this.projectKey);
                        SQLConnectionProvider.SQLConnectionWrapper conn = null;
                        try {
                            conn = SQLConnectionProvider.newConnection(connData, (AuthCtx)MassImportCandidatesThread.this.owner, MassImportCandidatesThread.this.projectKey);
                        }
                        catch (Exception e) {
                            this.assignErrorMessageToResult(massImportCandidatesWithConnectionName.getValue(), ExceptionUtils.getMessageWithCauses((Throwable)e));
                        }
                        if (conn == null) continue;
                        try {
                            DatabaseMetaData meta = conn.getMetaData();
                            for (SQLTableImportCandidate mic : massImportCandidatesWithConnectionName.getValue()) {
                                SQLOrElasticSearchImportResult res = this.importSQLTable(MassImportCandidatesThread.this.owner, connection.name, conn, meta, mic);
                                this.results.add(res);
                                listState.increment(1.0);
                                FutureProgressState.checkInterrupt();
                            }
                        }
                        finally {
                            conn.close();
                        }
                    }
                }
            }

            private SQLOrElasticSearchImportResult importSQLTable(AuthCtx authCtx, String connectionName, SQLConnectionProvider.SQLConnectionWrapper conn, DatabaseMetaData meta, SQLTableImportCandidate mic) {
                SQLOrElasticSearchImportResult ret = new SQLOrElasticSearchImportResult();
                SQLConnectionProvider.SQLConnectionData connData = conn.getConnectionData();
                ret.name = mic.table;
                try {
                    AbstractSQLDatasetHandler.AbstractSQLConfig config;
                    AbstractSQLConnection connection = connData.getConnection();
                    Dataset dataset = new Dataset().withType(connection.getType());
                    dataset.setFullName(mic.projectKey + "." + mic.datasetName);
                    if (connection instanceof TeradataConnection) {
                        TeradataDatasetConfig teradataConfig = new TeradataDatasetConfig();
                        teradataConfig.assumedDbTzForUnknownTz = ((TeradataConnection)connection).getParams().defaultAssumedDbTzForUnknownTz;
                        config = teradataConfig;
                    } else {
                        config = connection instanceof BigQueryConnection ? new BigQueryDatasetConfig() : new H2TemporarySQLConfig();
                    }
                    config.setAssumedJavaTzForUnknownTz(connection.getParams().defaultAssumedTzForUnknownTz);
                    config.connection = connectionName;
                    config.mode = "table";
                    if (!StringUtils.isBlank((String)mic.catalog)) {
                        config.catalog = mic.catalog;
                    }
                    if (!StringUtils.isBlank((String)mic.schema)) {
                        config.schema = mic.schema;
                    }
                    config.table = mic.table;
                    config.partitioningType = "custom";
                    dataset.setParams(config);
                    dataset.getModel().tags.add("origin:sql_import");
                    dataset.getModel().tags.add(connectionName);
                    dataset.getModel().description = mic.remarks;
                    SchemaReader.SchemaWithInfo schemaWithInfo = SchemaReader.getTableSchemaWithInfoAndComments(authCtx, conn, meta, config.catalog, config.schema, config.table, config.datetimenotzReadMode, config.dateonlyReadMode, null);
                    com.dataiku.dip.coremodel.Schema schema = schemaWithInfo.schema;
                    dataset.setSchema(schema);
                    logger.infoV("Creating dataset %s with %d columns (listed in schema=%s table=%s)", new Object[]{dataset.getName(), schema.getColumns().size(), mic.schema, mic.table});
                    if (connData.getDialect().supportsDirectSchemaRetrieval() && connData.getDialect().supportsTablePartitionInfoRetrieval()) {
                        SchemaReader.TablePartitionInfo partitionInfo = schemaWithInfo.tablePartitionInfo;
                        if (partitionInfo.dimension != null) {
                            PartitioningScheme partitioningScheme = new PartitioningScheme();
                            partitioningScheme.addDimension(partitionInfo.dimension);
                            dataset.setPartitioningScheme(partitioningScheme);
                            logger.infoV("Table in DB has a partition, activating %s partitioning on dataset %s on column %s", new Object[]{partitionInfo.dimension.getType(), dataset.getName(), partitionInfo.dimension.getName()});
                            if (config instanceof BigQueryDatasetConfig) {
                                config.externalPartitionField = partitionInfo.dimension.getName();
                            }
                        }
                    }
                    ret.dataset = dataset.serialize();
                    ret.columnCount = schema.getColumns().size();
                }
                catch (Throwable t) {
                    logger.error((Object)("Import failed for table " + connectionName + ":" + mic.schema + " " + mic.table), t);
                    ret.messages.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)HiveImportabilityChecker.ImportCodes.ERR_IMPORT_FAILED, (String)("Import failed for table " + connectionName + ":" + mic.schema + " " + mic.table + ": " + ExceptionUtils.getMessageWithCauses((Throwable)t))));
                }
                return ret;
            }
        }

        private class ElasticSearchIndicesImportResult
        extends ImportResults<ElasticSearchIndexImportCandidate> {
            public List<SQLOrElasticSearchImportResult> indices;

            private ElasticSearchIndicesImportResult() {
                this.indices = new ArrayList<SQLOrElasticSearchImportResult>();
            }

            @Override
            protected void saveDatasets(String zoneId) throws InterruptedException, TransactionFailedException, TransactionGitException {
                this.saveDatasets(zoneId, "Index", "ElasticSearch Indices", HiveImportabilityChecker.ImportCodes.INFO_IMPORT_INDEX_SUCCESS, HiveImportabilityChecker.ImportCodes.ERR_IMPORT_INDEX_FAILED);
            }

            private void assignErrorMessageToResult(List<ElasticSearchIndexImportCandidate> massImportCandidates, String message) {
                this.assignErrorMessageToResult(massImportCandidates, message, "index");
            }

            @Override
            protected void prepareDatasets(List<ElasticSearchIndexImportCandidate> candidates) throws IOException, InterruptedException, DKUSecurityException {
                Map<String, List<ElasticSearchIndexImportCandidate>> massImportCandidatesByConnection = this.groupCandidatesByConnection(candidates);
                try (FutureProgress.AutocloseableFutureProgressState listState = FutureProgress.pushAutoCloseableState((String)"Preparing ElasticSearch datasets", (double)candidates.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    for (Map.Entry<String, List<ElasticSearchIndexImportCandidate>> massImportCandidatesWithConnectionName : massImportCandidatesByConnection.entrySet()) {
                        String connectionName = massImportCandidatesWithConnectionName.getKey();
                        DSSConnection connection = ConnectionsImportService.this.connectionsDAO.getConnection(MassImportCandidatesThread.this.owner, connectionName);
                        List<ElasticSearchIndexImportCandidate> candidatesByConnection = massImportCandidatesWithConnectionName.getValue();
                        if (!(connection instanceof ElasticSearchConnection)) {
                            this.assignErrorMessageToResult(candidatesByConnection, String.format("Expected ElasticSearch connection type, got %s", connection.getType()));
                            continue;
                        }
                        if (!connection.isFreelyUsableBy(MassImportCandidatesThread.this.owner)) {
                            this.assignErrorMessageToResult(candidatesByConnection, String.format("Cannot use connection %s", connection.name));
                            continue;
                        }
                        ElasticSearchConnection conn = (ElasticSearchConnection)connection;
                        if (!ElasticSearchDialect.ES_7.equals((Object)conn.params.dialect)) {
                            this.assignErrorMessageToResult(candidatesByConnection, String.format("Importing ElasticSearch connections for ES <7 is not supported, got %s", new Object[]{conn.params.dialect}));
                            continue;
                        }
                        for (ElasticSearchIndexImportCandidate mic : this.mergeCandidatesByDataset(candidatesByConnection)) {
                            SQLOrElasticSearchImportResult res = this.importElasticSearchIndex(conn, MassImportCandidatesThread.this.projectKey, mic);
                            this.results.add(res);
                            listState.increment(1.0);
                            FutureProgressState.checkInterrupt();
                        }
                    }
                }
            }

            private Collection<ElasticSearchIndexImportCandidate> mergeCandidatesByDataset(List<ElasticSearchIndexImportCandidate> candidatesByConnection) {
                HashMap<String, ElasticSearchIndexImportCandidate> byDataset = new HashMap<String, ElasticSearchIndexImportCandidate>();
                for (ElasticSearchIndexImportCandidate candidate : candidatesByConnection) {
                    if (!byDataset.containsKey(candidate.datasetName)) {
                        ElasticSearchIndexImportCandidate newCandidate = new ElasticSearchIndexImportCandidate();
                        newCandidate.connectionName = candidate.connectionName;
                        newCandidate.name = candidate.name;
                        newCandidate.datasetName = candidate.datasetName;
                        byDataset.put(candidate.datasetName, newCandidate);
                        continue;
                    }
                    ((ElasticSearchIndexImportCandidate)byDataset.get((Object)candidate.datasetName)).name = ((ElasticSearchIndexImportCandidate)byDataset.get((Object)candidate.datasetName)).name + "," + candidate.name;
                }
                return byDataset.values();
            }

            private SQLOrElasticSearchImportResult importElasticSearchIndex(ElasticSearchConnection connection, String projectKey, ElasticSearchIndexImportCandidate mic) {
                SQLOrElasticSearchImportResult ret = new SQLOrElasticSearchImportResult();
                ret.name = mic.name;
                try {
                    Dataset dataset = new Dataset().withType(connection.getType());
                    dataset.setFullName(projectKey + "." + mic.datasetName);
                    ElasticSearchDatasetHandler.Config config = new ElasticSearchDatasetHandler.Config();
                    config.connection = connection.name;
                    config.index = mic.name;
                    dataset.setParams(config);
                    dataset.getModel().tags.add("origin:elasticsearch_import");
                    dataset.getModel().tags.add(connection.name);
                    try (ElasticSearchIndex esIndex = new ElasticSearchIndex(MassImportCandidatesThread.this.owner, connection, config, dataset);){
                        com.dataiku.dip.coremodel.Schema schema = esIndex.inferSchemaFromMapping((String)config.index).inferredSchema;
                        dataset.setSchema(schema);
                        ret.columnCount = schema.getColumns().size();
                        logger.infoV("Creating dataset %s with %d columns (listed in schema=%s index=%s)", new Object[]{dataset.getName(), ret.columnCount, schema, config.index});
                        ret.dataset = dataset.serialize();
                    }
                }
                catch (Throwable t) {
                    String message = "Import failed for index " + connection.name + ": " + mic.name;
                    logger.error((Object)message, t);
                    ret.messages.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)HiveImportabilityChecker.ImportCodes.ERR_IMPORT_INDEX_FAILED, (String)(message + ": " + ExceptionUtils.getMessageWithCauses((Throwable)t))));
                }
                return ret;
            }
        }

        private class IcebergTablesImportResult
        extends ImportResults<IcebergTableImportCandidate> {
            public List<SQLOrElasticSearchImportResult> tables;

            private IcebergTablesImportResult() {
                this.tables = new ArrayList<SQLOrElasticSearchImportResult>();
            }

            @Override
            protected void saveDatasets(String zoneId) throws InterruptedException, TransactionFailedException, TransactionGitException {
                this.saveDatasets(zoneId, "Table", "SQL Tables", HiveImportabilityChecker.ImportCodes.INFO_IMPORT_SUCCESS, HiveImportabilityChecker.ImportCodes.ERR_IMPORT_FAILED);
            }

            private void assignErrorMessageToResult(List<IcebergTableImportCandidate> massImportCandidates, String message) {
                this.assignErrorMessageToResult(massImportCandidates, message, "table");
            }

            @Override
            protected void prepareDatasets(List<IcebergTableImportCandidate> candidates) throws Exception {
                Map<String, List<IcebergTableImportCandidate>> massImportCandidatesByConnection = this.groupCandidatesByConnection(candidates);
                try (FutureProgress.AutocloseableFutureProgressState listState = FutureProgress.pushAutoCloseableState((String)"Preparing SQL datasets", (double)candidates.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    for (Map.Entry<String, List<IcebergTableImportCandidate>> massImportCandidatesWithConnectionName : massImportCandidatesByConnection.entrySet()) {
                        String connectionName = massImportCandidatesWithConnectionName.getKey();
                        DSSConnection connection = ConnectionsImportService.this.connectionsDAO.getConnection(MassImportCandidatesThread.this.owner, connectionName);
                        if (!(connection instanceof IcebergConnection)) {
                            this.assignErrorMessageToResult(massImportCandidatesWithConnectionName.getValue(), String.format("Expected Iceberg connection type, got %s", connection.getType()));
                            continue;
                        }
                        if (!connection.isFreelyUsableBy(MassImportCandidatesThread.this.owner)) {
                            this.assignErrorMessageToResult(massImportCandidatesWithConnectionName.getValue(), String.format("Cannot use connection %s", connection.name));
                            continue;
                        }
                        IcebergConnection icebergConnection = (IcebergConnection)connection;
                        PrivilegedExceptionAction<Void> action = () -> {
                            Catalog icebergCatalog = null;
                            try {
                                icebergCatalog = icebergConnection.getIcebergCatalog(MassImportCandidatesThread.this.owner, MassImportCandidatesThread.this.projectKey);
                            }
                            catch (Exception e) {
                                this.assignErrorMessageToResult((List)massImportCandidatesWithConnectionName.getValue(), ExceptionUtils.getMessageWithCauses((Throwable)e));
                            }
                            if (icebergCatalog != null) {
                                try {
                                    for (IcebergTableImportCandidate mic : (List)massImportCandidatesWithConnectionName.getValue()) {
                                        SQLOrElasticSearchImportResult res = this.importIcebergTable(MassImportCandidatesThread.this.owner, connection.name, icebergCatalog, mic);
                                        this.results.add(res);
                                        listState.increment(1.0);
                                        FutureProgressState.checkInterrupt();
                                    }
                                }
                                finally {
                                    if (icebergCatalog instanceof Closeable) {
                                        ((Closeable)icebergCatalog).close();
                                    }
                                }
                            }
                            return null;
                        };
                        new IcebergUtils().getUgi(icebergConnection, MassImportCandidatesThread.this.owner, MassImportCandidatesThread.this.projectKey).doAs(action);
                    }
                }
            }

            private SQLOrElasticSearchImportResult importIcebergTable(AuthCtx authCtx, String connectionName, Catalog icebergCatalog, IcebergTableImportCandidate mic) {
                SQLOrElasticSearchImportResult ret = new SQLOrElasticSearchImportResult();
                ret.name = mic.table;
                try {
                    Dataset dataset = new Dataset().withType("iceberg");
                    dataset.setFullName(mic.projectKey + "." + mic.datasetName);
                    IcebergDatasetParams config = new IcebergDatasetParams();
                    config.connection = connectionName;
                    config.table = mic.table;
                    config.namespace = mic.schema;
                    dataset.setParams(config);
                    dataset.getModel().tags.add("origin:iceberg_import");
                    dataset.getModel().tags.add(connectionName);
                    dataset.getModel().description = mic.remarks;
                    IcebergUtils utils = new IcebergUtils();
                    TableIdentifier tableId = TableIdentifier.of((Namespace)utils.toNamespace(mic.schema), (String)mic.table);
                    if (icebergCatalog.getClass().getSimpleName().equals("SnowflakeCatalog")) {
                        tableId = utils.makeSnowflakeCompatible(tableId);
                    }
                    Table table = icebergCatalog.loadTable(tableId);
                    Schema icebergSchema = table.schema();
                    logger.info((Object)("Iceberg schema is " + String.valueOf(icebergSchema)));
                    IcebergSchemaConverter converter = new IcebergSchemaConverter();
                    com.dataiku.dip.coremodel.Schema schema = converter.convert(icebergSchema);
                    dataset.setSchema(schema);
                    logger.infoV("Creating dataset %s with %d columns (listed in namespace=%s table=%s)", new Object[]{dataset.getName(), schema.getColumns().size(), mic.schema, mic.table});
                    PartitionSpec icebergSpec = table.spec();
                    if (icebergSpec.isPartitioned()) {
                        dataset.setPartitioningScheme(utils.inferPartitioningScheme(icebergSpec, icebergSchema));
                    }
                    ret.dataset = dataset.serialize();
                    ret.columnCount = schema.getColumns().size();
                }
                catch (Throwable t) {
                    logger.error((Object)("Import failed for table " + connectionName + ":" + mic.schema + " " + mic.table), t);
                    ret.messages.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)HiveImportabilityChecker.ImportCodes.ERR_IMPORT_FAILED, (String)("Import failed for table " + connectionName + ":" + mic.schema + " " + mic.table + ": " + ExceptionUtils.getMessageWithCauses((Throwable)t))));
                }
                return ret;
            }
        }

        abstract class ImportResults<IF extends ImportInfo> {
            public List<SQLOrElasticSearchImportResult> results = new ArrayList<SQLOrElasticSearchImportResult>();

            ImportResults() {
            }

            abstract void prepareDatasets(List<IF> var1) throws Exception;

            protected abstract void saveDatasets(String var1) throws InterruptedException, TransactionFailedException, TransactionGitException;

            InfoMessage.InfoMessages importCandidates(String zoneId, FutureProgress.AutocloseableFutureProgressState state, List<IF> candidates) throws Exception {
                this.prepareDatasets(candidates);
                state.increment(1.0);
                this.saveDatasets(zoneId);
                state.increment(1.0);
                InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
                for (SQLOrElasticSearchImportResult createdDataset : this.results) {
                    messages.mergeFrom(createdDataset.messages);
                }
                return messages;
            }

            protected void saveDatasets(String zoneId, String prefix, String commitMsgFrom, HiveImportabilityChecker.ImportCodes successCode, HiveImportabilityChecker.ImportCodes errorCode) throws InterruptedException, TransactionFailedException, TransactionGitException {
                try (RWTransaction t = ConnectionsImportService.this.transactionService.beginWriteAsLoggedInUser((AuthCtx)MassImportCandidatesThread.this.owner);){
                    try (FutureProgress.AutocloseableFutureProgressState listState = FutureProgress.pushAutoCloseableState((String)"Create datasets", (double)this.results.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                        for (SQLOrElasticSearchImportResult createDataset : this.results) {
                            if (createDataset.dataset == null) continue;
                            try {
                                DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildDefault();
                                WithMessages<SerializedDataset> newDataset = ConnectionsImportService.this.datasetSaveService.create(MassImportCandidatesThread.this.projectKey, createDataset.dataset, dsCtx, MassImportCandidatesThread.this.owner);
                                createDataset.dataset = (SerializedDataset)newDataset.value;
                                createDataset.datasetName = ((SerializedDataset)newDataset.value).getDisplayName();
                                ConnectionsImportService.this.flowZonesService.attachObjectToZone(zoneId, MassImportCandidatesThread.this.projectKey, createDataset.dataset);
                                createDataset.messages.mergeFrom(newDataset.messages);
                                createDataset.messages.addMessage(InfoMessage.success((InfoMessage.MessageCode)successCode, (String)(prefix + " '" + createDataset.name + "' imported as dataset '" + createDataset.datasetName + "'")));
                            }
                            catch (Throwable e) {
                                logger.error((Object)"Creation of dataset failed", e);
                                createDataset.messages.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)errorCode, (String)ExceptionUtils.getMessageWithCauses((Throwable)e)));
                            }
                        }
                        listState.increment(1.0);
                        FutureProgressState.checkInterrupt();
                    }
                    StringBuilder sb = new StringBuilder();
                    for (SQLOrElasticSearchImportResult createdDataset : this.results) {
                        if (createdDataset.messages.anyFatal()) continue;
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(createdDataset.dataset.getFullName());
                    }
                    t.commit("Created datasets from " + commitMsgFrom + ": " + String.valueOf(sb));
                }
            }

            protected Map<String, List<IF>> groupCandidatesByConnection(List<IF> candidates) {
                HashMap<String, List<IF>> massImportCandidatesByConnection = new HashMap<String, List<IF>>();
                for (ImportInfo candidate : candidates) {
                    if (!massImportCandidatesByConnection.containsKey(candidate.connectionName)) {
                        massImportCandidatesByConnection.put(candidate.connectionName, new ArrayList());
                    }
                    ((List)massImportCandidatesByConnection.get(candidate.connectionName)).add(candidate);
                }
                return massImportCandidatesByConnection;
            }

            protected void assignErrorMessageToResult(List<IF> massImportCandidates, String message, String kind) {
                for (ImportInfo massImportCandidate : massImportCandidates) {
                    SQLOrElasticSearchImportResult result = new SQLOrElasticSearchImportResult();
                    result.messages.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)HiveImportabilityChecker.ImportCodes.ERR_IMPORT_FAILED, (String)String.format("Could not import %s %s : %s", kind, massImportCandidate.getName(), message)));
                    this.results.add(result);
                }
            }
        }

        class SQLOrElasticSearchImportResult {
            public String name;
            public String datasetName;
            public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            public transient SerializedDataset newDataset;
            public SerializedDataset dataset;
            int columnCount;

            SQLOrElasticSearchImportResult() {
            }
        }
    }

    public static class ElasticSearchIndicesImportData {
        public List<ElasticSearchIndexImportData> tables = new ArrayList<ElasticSearchIndexImportData>();
    }

    public static class ElasticSearchIndexImportData
    extends ElasticSearchIndexImportInfo {
        public int count;
        public ElasticSearchIndexType type;
        public Collection<String> aliasesOrIndices;
    }

    public static class ElasticSearchIndexImportInfo
    extends ImportInfo {
        public String name;

        @Override
        String getName() {
            return this.name;
        }
    }

    public static abstract class ImportInfo {
        public String connectionName;

        abstract String getName();
    }

    static enum ElasticSearchIndexType {
        INDEX,
        ALIAS;

    }

    public static class IcebergTableImportData {
        public List<IcebergTableImportCandidate> tables = new ArrayList<IcebergTableImportCandidate>();
        public String connectionType;
    }

    public static class SQLTableImportData {
        public List<SQLTableImportCandidate> tables = new ArrayList<SQLTableImportCandidate>();
        public String connectionType;
    }
}

