/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.containers.exec.BaseImageBuilder;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dataflow.cde.CDEImageBuilderService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.PluginExtraInfo;
import com.dataiku.dip.plugins.PluginRequirementService;
import com.dataiku.dip.plugins.PluginSettingsAccessService;
import com.dataiku.dip.plugins.PluginSetupPythonKernel;
import com.dataiku.dip.plugins.PluginStoreService;
import com.dataiku.dip.plugins.PluginsLoadService;
import com.dataiku.dip.plugins.PluginsSetupService;
import com.dataiku.dip.plugins.dev.DevPluginsService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.plugins.model.StorePluginsList;
import com.dataiku.dip.plugins.presets.LoadedParameterSet;
import com.dataiku.dip.plugins.presets.ParameterSetDesc;
import com.dataiku.dip.plugins.presets.PluginParameterSetsService;
import com.dataiku.dip.plugins.presets.PluginPreset;
import com.dataiku.dip.scheduler.runnables.DSSRunnableDesc;
import com.dataiku.dip.scheduler.runnables.DSSRunnablesService;
import com.dataiku.dip.scheduler.runnables.LoadedRunnable;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.PluginValidatorHelper;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class PluginsController
extends DIPInternalControllerBase {
    @Autowired
    UIAuthService authService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    IPluginsRegistryService pluginsRegistry;
    @Autowired
    PluginsLoadService pluginsLoadService;
    @Autowired
    PluginRequirementService pluginRequirementService;
    @Autowired
    PluginStoreService pluginStoreService;
    @Autowired
    DevPluginsService devPluginsService;
    @Autowired
    PluginsSetupService pluginsSetupService;
    @Autowired
    IPermissionsService permissionsService;
    @Autowired
    DesignNodeCodeEnvsService designNodeEnvsService;
    @Autowired
    AutomationNodeCodeEnvsService automationNodeEnvsService;
    @Autowired
    PluginSettingsAccessService pluginSettingsAccessService;
    @Autowired
    PluginParameterSetsService pluginPresetsService;
    @Autowired
    PluginUsagesInspector pluginUsagesInspector;
    @Autowired
    DSSRunnablesService runnablesService;
    @Autowired
    FutureService futureService;
    @Autowired
    private CDEImageBuilderService cdeImageBuilderService;
    private static Logger logger = Logger.getLogger((String)"dku.plugins.controller");

    @AuditedCall(value={"msgType", "admin-plugins-get"})
    @RequestMapping(value={"/api/plugins/get"})
    public synchronized void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam(required=false) String projectKey) throws Exception {
        PluginSettingsAccessService.PluginUISettings settings;
        StorePluginsList.StorePlugin storeDesc;
        InstalledPluginDesc installedDesc;
        try (Transaction t = this.transactionService.beginRead();){
            boolean canAdminProject;
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            installedDesc = this.pluginsRegistry.getInstalledDesc(pluginId);
            storeDesc = this.pluginStoreService.getStorePluginDesc(pluginId).orElse(null);
            boolean canAdminPlugin = this.permissionsService.hasPluginPrivilege(authCtx, pluginId, Privileges.PluginLevelPrivilegeType.ADMIN);
            boolean bl = canAdminProject = StringUtils.isNotBlank((String)projectKey) && this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            settings = canAdminPlugin || StringUtils.isNotBlank((String)projectKey) && canAdminProject ? this.pluginSettingsAccessService.get(authCtx, pluginId, projectKey) : new PluginSettingsAccessService.PluginUISettings();
        }
        PluginInfo ret = new PluginInfo(installedDesc, settings, storeDesc);
        PluginsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "admin-plugins-list"})
    @RequestMapping(value={"/api/plugins/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp, boolean forceFetch) throws Exception {
        DSSAuthCtx liu;
        try (Transaction ignored = this.transactionService.beginRead();){
            liu = (DSSAuthCtx)this.authService.getMandatoryUser(req);
        }
        if (forceFetch) {
            this.pluginStoreService.forceFetch(liu);
        }
        PluginsController.writeJSON((HttpServletResponse)resp, (Object)this.pluginStoreService.getStateList(liu));
    }

    @AuditedCall(value={"msgType", "admin-plugins-list"})
    @RequestMapping(value={"/api/plugins/list-plugins-with-presets"})
    @ResponseBody
    public synchronized List<PluginStoreService.PluginStateInfo> listPresetable(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        ArrayList presetablePluginDescs = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        for (InstalledPluginDesc desc : this.pluginsRegistry.getLoadedPlugins()) {
            if (desc.customParameterSets.isEmpty()) continue;
            PluginStoreService.PluginStateInfo info = PluginStoreService.PluginStateInfo.fromInstalled(desc);
            presetablePluginDescs.add(info);
        }
        return presetablePluginDescs;
    }

    @AuditedCall(value={"msgType", "admin-plugin-install-from-store", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/install-from-store"})
    public void install(HttpServletRequest req, HttpServletResponse resp, String pluginId, boolean update) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            authCtx = this.authService.getUser(req);
        }
        PluginsController.writeJSON((HttpServletResponse)resp, this.pluginStoreService.downloadAndInstall(pluginId, authCtx, update));
    }

    @AuditedCall(value={"msgType", "admin-plugin-upload"})
    @RequestMapping(value={"/api/plugins/upload"}, method={RequestMethod.POST})
    public void uploadPlugin(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="file") MultipartFile filePart, @RequestParam boolean isUpdate) throws Exception {
        logger.info((Object)("Uploading new plugin from file " + filePart.getOriginalFilename()));
        AuthCtx liu = null;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(liu);
        }
        AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"plugin-uploads");
        FileUtils.copyInputStreamToFile((InputStream)filePart.getInputStream(), (File)this.pluginStoreService.getPluginArchive((File)tmpDir));
        logger.info((Object)"Plugin received, installing it");
        PluginsController.writeJSON((HttpServletResponse)resp, this.pluginStoreService.startUploadAndInstall(tmpDir, liu, isUpdate));
    }

    @AuditedCall(value={"msgType", "admin-plugin-clone"})
    @RequestMapping(value={"/api/plugins/clone"}, method={RequestMethod.POST})
    public void clonePlugin(HttpServletRequest req, HttpServletResponse resp, @RequestParam String repository, @RequestParam String checkout, @RequestParam String path, @RequestParam boolean isUpdate) throws Exception {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(user);
        }
        PluginsController.writeJSON((HttpServletResponse)resp, this.pluginStoreService.startCloneAndInstall(repository, checkout, path, user, isUpdate));
    }

    @AuditedCall(value={"msgType", "admin-move-plugin-to-dev"})
    @RequestMapping(value={"/api/plugins/move-to-dev"}, method={RequestMethod.POST})
    public void clonePlugin(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(user);
        }
        PluginsController.writeJSON((HttpServletResponse)resp, (Object)this.pluginStoreService.movePluginToDev_NT(pluginId));
    }

    @AuditedCall(value={"msgType", "plugindev-dss-restart"})
    @RequestMapping(value={"/api/plugins/trigger-restart"})
    public void triggerRestart(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            System.exit(1);
        }
    }

    @AuditedCall(value={"msgType", "plugindev-use-venv", "pluginId", "${pluginId}", "envName", "${envName}"})
    @RequestMapping(value={"/api/plugins/use-code-env"})
    public synchronized void useCodeEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam(required=false) String envName) throws Exception {
        AuthCtx authCtx;
        String oldEnvName = null;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkPluginPrivileges(authCtx, pluginId, Privileges.PluginLevelPrivilegeType.ADMIN);
            PluginSettings settings = this.pluginsRegistry.getSettings(pluginId);
            oldEnvName = settings.codeEnvName;
            settings.codeEnvName = envName;
            this.pluginsRegistry.setSettings(pluginId, settings);
            t.commit("Changed code env on plugin " + pluginId);
        }
        if (!StringUtils.equals((String)envName, (String)oldEnvName) && this.cdeImageBuilderService.shouldRebuildCDEOnPluginCodeEnvChange(pluginId)) {
            BaseImageBuilder builder = new BaseImageBuilder(ContainerExecUtils.BaseImageType.CDE_PLUGINS, new BaseImageBuilder.BaseImageBuildOptions(), true, true);
            PluginsController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(builder.getBuildFuture(authCtx), 0L, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){}));
        }
    }

    @AuditedCall(value={"msgType", "admin-plugin-save-settings", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/save-settings"})
    public void savePluginSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam(required=false) String projectKey, @RequestParam String data) throws Exception {
        PluginSettingsAccessService.PluginSettingsSaveResult ret;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            ret = this.pluginSettingsAccessService.save(authCtx, pluginId, projectKey, (PluginSettingsAccessService.PluginUISettings)JSON.parse((String)data, PluginSettingsAccessService.PluginUISettings.class));
            t.commit("Saved settings on plugin " + pluginId);
        }
        PluginsController.writeJSON((HttpServletResponse)resp, (Object)this.pluginSettingsAccessService.handleSavePostActions(ret, null));
    }

    @AuditedCall(value={"msgType", "plugin-get-presets", "pluginId", "${pluginId}", "elementId", "${elementId}"})
    @RequestMapping(value={"/api/plugins/list-accessible-presets"})
    public synchronized void listAccessiblePresets(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam(required=false) String projectKey, @RequestParam String elementId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            String elementType = "parameter-set-" + pluginId + "-" + elementId;
            LoadedParameterSet loadedParameterSet = (LoadedParameterSet)this.pluginPresetsService.getOrNull(elementType);
            if (loadedParameterSet == null) {
                throw new IllegalArgumentException("Unknown preset type");
            }
            ParameterSetDesc parameterSetDesc = loadedParameterSet.desc;
            PluginSettings settings = new PluginSettingsResolver(authCtx, projectKey).getAndMergePluginSettings(pluginId);
            PluginPresetItems ret = new PluginPresetItems();
            ret.definableInline = this.permissionsService.hasPluginParameterSetPrivilege(authCtx, pluginId, loadedParameterSet.id, Privileges.PluginParameterSetLevelPrivilegeType.INLINE);
            if (ret.definableInline) {
                ret.inlineParams = parameterSetDesc.params;
                ret.inlinePluginParams = parameterSetDesc.pluginParams;
            }
            for (PluginPreset preset : settings.presets) {
                if (!elementType.equals(preset.type) || !this.permissionsService.hasPluginPresetPrivilege(authCtx, pluginId, projectKey, preset.name, elementId, Privileges.PluginPresetLevelPrivilegeType.USE)) continue;
                PluginPresetItem item = new PluginPresetItem();
                item.name = preset.name;
                item.description = preset.description;
                ret.presets.add(item);
            }
            PluginsController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "admin-plugin-install-requirements", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins/install-requirements"})
    public void installRequirements(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam PluginRequirementService.DependencySystem type) throws Exception {
        AuthCtx liu = null;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            liu = this.authService.getMandatoryUser(req);
        }
        InstalledPluginDesc installedDesc = PluginsController.getInstalledPluginDesc(this.pluginsRegistry, pluginId);
        PluginsController.writeJSON((HttpServletResponse)resp, this.pluginRequirementService.installRequirements(installedDesc, type, liu));
    }

    @AuditedCall(value={"msgType", "plugin-python-do", "pluginId", "${pluginId}", "componentId", "${componentId}"})
    @RequestMapping(value={"/api/plugins/call-python-do"})
    public void callPythonDo(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false, defaultValue="") String sessionId, @RequestParam String pluginId, @RequestParam String componentId, @RequestParam(required=false) String projectKey, @RequestParam(required=false) String clusterId, @RequestParam(value="part", required=false, defaultValue="") String partStr, @RequestParam(value="config") String configStr, @RequestParam(value="payload", required=false, defaultValue="") String payloadStr, @RequestParam(value="recipeConfig", required=false, defaultValue="") String recipeConfigStr) throws Exception {
        List<PluginSetupPythonKernel.DoRequestInput> recipeRequestInputs;
        PluginsSetupService.CallPythonDoContext callPythonDoContext;
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            if (StringUtils.isNotBlank((String)projectKey)) {
                this.permissionsService.checkProjectPrivileges(liu, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                callPythonDoContext = PluginsSetupService.CallPythonDoContext.IN_PROJECT;
            } else if (StringUtils.isNotBlank((String)clusterId)) {
                this.permissionsService.checkClusterPrivileges(liu, clusterId, Privileges.ClusterLevelPrivilegeType.UPDATE);
                callPythonDoContext = PluginsSetupService.CallPythonDoContext.IN_CLUSTER;
            } else {
                callPythonDoContext = this.inferPythonContextAndCheckRights((DSSAuthCtx)liu, pluginId, componentId);
            }
            SerializedRecipe recipeConfig = StringUtils.isNotBlank((String)recipeConfigStr) ? (SerializedRecipe)JSON.parse((String)recipeConfigStr, SerializedRecipe.class) : null;
            recipeRequestInputs = this.pluginsSetupService.buildDoRequestInputs(recipeConfig);
        }
        JsonObject config = StringUtils.isNotBlank((String)configStr) ? (JsonObject)JSON.parse((String)configStr, JsonObject.class) : null;
        JsonObject payload = StringUtils.isNotBlank((String)payloadStr) ? (JsonObject)JSON.parse((String)payloadStr, JsonObject.class) : null;
        PluginsSetupService.SetupPart setupPart = StringUtils.isNotBlank((String)partStr) ? PluginsSetupService.SetupPart.valueOf(partStr) : PluginsSetupService.SetupPart.MAIN;
        Callable<PluginsSetupService.SetupData> callable = this.pluginsSetupService.callPythonDo(sessionId, config, payload, pluginId, componentId, liu, projectKey, recipeRequestInputs, setupPart, callPythonDoContext);
        PluginsController.writeJSON((HttpServletResponse)resp, (Object)callable.call());
    }

    private PluginsSetupService.CallPythonDoContext inferPythonContextAndCheckRights(DSSAuthCtx user, String pluginId, String componentId) throws DKUSecurityException {
        if (this.hasProjectCreationMacroRole(PluginsSetupService.getMatchingComponent(pluginId, componentId, new ArrayList<PluginsSetupService.SetupableComponentLoadedDesc>(this.runnablesService.listRunnables())))) {
            this.permissionsService.checkCanCreateProjectFromMacro(user);
            return PluginsSetupService.CallPythonDoContext.IN_PROJECT_CREATOR;
        }
        this.permissionsService.checkPluginPrivileges(user, pluginId, Privileges.PluginLevelPrivilegeType.ADMIN);
        return PluginsSetupService.CallPythonDoContext.NONE;
    }

    private boolean hasProjectCreationMacroRole(Optional<PluginsSetupService.SetupableComponentLoadedDesc> matchingRunnable) {
        return matchingRunnable.isPresent() && ((DSSRunnableDesc)((LoadedRunnable)matchingRunnable.get()).getDesc()).macroRoles.stream().anyMatch(macroRoleDef -> DSSRunnableDesc.MacroRoleDef.Type.PROJECT_CREATOR.equals((Object)macroRoleDef.type));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/plugins/get-lib-folders"})
    public void getLibFolders(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            authCtx.failIfNoSafeCode("You are not allowed to use code-related functions");
        }
        PluginsController.writeJSON((HttpServletResponse)resp, (Object)new LibFolders(this.pluginsRegistry, pluginId));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/plugins/get-usages"})
    public void getUsages(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam(required=false) String projectKey) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        PluginsController.writeJSON((HttpServletResponse)resp, (Object)this.pluginUsagesInspector.getUsages(authCtx, projectKey, pluginId));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/plugins/prepare-delete"})
    public void prepareDelete(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        InstalledPluginDesc installedDesc = PluginsController.getInstalledPluginDesc(this.pluginsRegistry, pluginId);
        PluginValidatorHelper.checkDeletablePlugin(installedDesc);
        PluginUsagesInspector.PluginUsages usages = this.pluginUsagesInspector.getUsages(null, pluginId);
        PluginsController.writeJSON((HttpServletResponse)resp, (Object)usages.getStatistics());
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/plugins/delete"})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam(required=false, defaultValue="false") boolean force) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        InstalledPluginDesc installedDesc = PluginsController.getInstalledPluginDesc(this.pluginsRegistry, pluginId);
        PluginValidatorHelper.checkDeletablePlugin(installedDesc);
        if (!force) {
            PluginUsagesInspector.PluginUsages usages = this.pluginUsagesInspector.getUsages(null, pluginId);
            if (!usages.usages.isEmpty()) {
                throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_USED_PLUGIN_DELETION, "The plugin " + pluginId + " is used; its deletion may be forced");
            }
        }
        PluginsController.writeJSON((HttpServletResponse)resp, this.pluginStoreService.remove(pluginId, authCtx));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/plugins/can-admin-plugin"})
    public void canAdminPlugin(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        boolean canAdminPlugin = this.permissionsService.hasPluginPrivilege(authCtx, pluginId, Privileges.PluginLevelPrivilegeType.ADMIN);
        PluginsController.writeJSON((HttpServletResponse)resp, (Object)canAdminPlugin);
    }

    public static InstalledPluginDesc getInstalledPluginDesc(IPluginsRegistryService pluginsRegistry, String pluginId) throws CodedException {
        InstalledPluginDesc installedDesc = pluginsRegistry.getInstalledDesc(pluginId);
        if (installedDesc == null) {
            throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Plugin " + pluginId + " was not found");
        }
        return installedDesc;
    }

    public static class PluginInfo {
        public final InstalledPluginDesc installedDesc;
        public final PluginSettingsAccessService.PluginUISettings settings;
        public final PluginExtraInfo extraInfo;
        public final StorePluginsList.StorePlugin storeDesc;

        public PluginInfo(InstalledPluginDesc installedDesc, PluginSettingsAccessService.PluginUISettings settings, StorePluginsList.StorePlugin storeDesc) {
            this.installedDesc = installedDesc;
            this.settings = settings;
            this.extraInfo = new PluginExtraInfo(installedDesc);
            this.storeDesc = storeDesc;
        }
    }

    public static class PluginPresetItems {
        public boolean definableInline;
        public List<ParamDesc> inlineParams;
        public List<ParamDesc> inlinePluginParams;
        public List<PluginPresetItem> presets = Lists.newArrayList();
    }

    public static class PluginPresetItem {
        public String name;
        public String description;
    }

    public static class LibFolders {
        public String pythonLib;
        public String lib;
        public String resource;

        public LibFolders(IPluginsRegistryService pluginsRegistry, String pluginId) {
            this.pythonLib = pluginsRegistry.getPluginPythonlibFolder(pluginId).getAbsolutePath();
            this.lib = pluginsRegistry.getPluginJavalibFolder(pluginId).getAbsolutePath();
            this.resource = pluginsRegistry.getPluginResourceFolder(pluginId).getAbsolutePath();
        }
    }
}

