/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.eda;

import com.dataiku.dip.eda.worksheets.WorksheetsService;
import com.dataiku.dip.eda.worksheets.models.Worksheet;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/"}, produces={"application/json"})
public class WorksheetsController
extends DIPInternalControllerBase {
    @Autowired
    UIAuthService authService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    WorksheetsService worksheetsService;
    @Autowired
    PermissionsService permissionsService;
    @Autowired
    ProjectsService projectsService;
    @Autowired
    AuditTrailService auditTrailService;

    @AuditedCall(value={"msgType", "statistics-worksheet-get", "projectKey", "${projectKey}", "worksheetId", "{worksheetId}"})
    @RequestMapping(value={"/api/eda/worksheets/get-worksheet"}, method={RequestMethod.GET})
    @ResponseBody
    public Worksheet getWorksheet(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String worksheetId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Worksheet worksheet = this.worksheetsService.getWorksheet(projectKey, worksheetId);
            return worksheet;
        }
    }

    @AuditedCall(value={"msgType", "statistics-worksheets-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/eda/worksheets/list-worksheets"}, method={RequestMethod.GET})
    @ResponseBody
    public List<WorksheetsService.WorksheetHead> listWorksheets(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String datasetSmartName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            List<WorksheetsService.WorksheetHead> list = this.worksheetsService.listWorksheetHeads(projectKey, datasetSmartName);
            return list;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/eda/worksheets/save-worksheet"}, method={RequestMethod.POST})
    @ResponseBody
    public Worksheet saveWorksheet(HttpServletRequest req, @RequestParam Worksheet worksheet) throws Exception {
        Worksheet worksheet2;
        block8: {
            RWTransaction t = this.transactionService.beginWriteForUI(req);
            try {
                AuthCtx authCtx = this.authService.getMandatoryUser(req);
                this.permissionsService.checkProjectPrivileges(authCtx, worksheet.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                this.projectsService.failIfNoDatasetReadUseAccess(authCtx, worksheet.getDatasetLoc(), worksheet.projectKey);
                Worksheet savedWorksheet = this.worksheetsService.saveWorksheet(authCtx, worksheet);
                t.commit("Save worksheet " + savedWorksheet.getFullId(), 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
                this.auditTrailService.generic("statistics-worksheet-save").with("projectKey", worksheet.projectKey).with("worksheetId", worksheet.id).emit();
                worksheet2 = savedWorksheet;
                if (t == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.auditTrailService.failure("statistics-worksheet-save", (Throwable)e).with("projectKey", worksheet.projectKey).with("worksheetId", worksheet.id).emit();
                    throw e;
                }
            }
            t.close();
        }
        return worksheet2;
    }
}

