/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.server.services.IProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DKUExecutors;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.webapps.WebAppsService;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AliveService {
    TransactionService transactionService;
    IProjectsService projectsService;
    WebAppsService webAppsService;
    private static DKULogger logger = DKULogger.getLogger((String)AliveService.class.getCanonicalName());

    public AliveService(@Autowired TransactionService transactionService, @Autowired IProjectsService projectsService, @Autowired WebAppsService webAppsService) {
        this.transactionService = transactionService;
        this.projectsService = projectsService;
        this.webAppsService = webAppsService;
    }

    public synchronized AlivenessStatus isAlive() {
        AlivenessStatus status = new AlivenessStatus();
        boolean forcedNotAlive = this.getNotAliveFile().isFile();
        if (forcedNotAlive) {
            status.forcedNotAlive = true;
        } else {
            status.alive = true;
        }
        return status;
    }

    public synchronized void setNotAlive() throws IOException {
        logger.info((Object)"Setting instance as not-alive");
        DKUFileUtils.createIfNotExists((File)this.getNotAliveFile());
    }

    public synchronized void setAlive() throws IOException {
        logger.info((Object)"Setting instance as alive");
        File notAliveFile = this.getNotAliveFile();
        if (notAliveFile.isFile()) {
            DKUFileUtils.forceDelete((File)notAliveFile);
        }
    }

    private File getNotAliveFile() {
        return DKUApp.getFile((String[])new String[]{"run", "instance-not-alive.txt"});
    }

    public synchronized AlivenessStatus isProjectAlive(String projectKey) throws IOException {
        AlivenessStatus instanceAliveness = this.isAlive();
        if (!instanceAliveness.alive) {
            return instanceAliveness;
        }
        AlivenessStatus status = new AlivenessStatus();
        boolean forcedNotAlive = this.getProjectNotAliveFile(projectKey).isFile();
        if (forcedNotAlive) {
            status.forcedNotAlive = true;
            return status;
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            if (this.projectsService.getOrNullUnsafe(projectKey) == null) {
                AlivenessStatus alivenessStatus = status;
                return alivenessStatus;
            }
        }
        int poolSize = DKUApp.getParams().getIntParam("dku.webapp.backendReadiness.threadPoolSize", Integer.valueOf(5));
        int totalTimeout = DKUApp.getParams().getIntParam("dku.webapp.backendReadiness.totalTimeoutMS", Integer.valueOf(30000));
        try (DKUExecutors.DKUExecutor webappBackendStatusExecutor = new DKUExecutors.DKUExecutor(poolSize, "isProjectAliveExecutor", "isProjectAlive-%d", totalTimeout);){
            List<WebAppsService.BackendInfo> infoList = this.webAppsService.getBackendInfoListForProject_NT(webappBackendStatusExecutor, projectKey, true, false);
            status.alive = infoList.stream().filter(s -> !WebAppsService.Status.BACKEND_READY.equals((Object)s.status)).findFirst().isEmpty();
        }
        return status;
    }

    public synchronized void setProjectNotAlive(String projectKey) throws IOException {
        logger.infoV("Setting project %s as not-alive", new Object[]{projectKey});
        DKUFileUtils.createIfNotExists((File)this.getProjectNotAliveFile(projectKey));
    }

    public synchronized void setProjectAlive(String projectKey) throws IOException {
        logger.infoV("Setting project %s as alive", new Object[]{projectKey});
        File notAliveFile = this.getProjectNotAliveFile(projectKey);
        if (notAliveFile.isFile()) {
            DKUFileUtils.forceDelete((File)notAliveFile);
        }
    }

    private File getProjectNotAliveFile(String projectKey) {
        return DKUApp.getFile((String[])new String[]{"run", String.format("project-%s-not-alive.txt", projectKey)});
    }

    public static class AlivenessStatus {
        public boolean alive;
        public boolean forcedNotAlive;
    }
}

