/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.licensing;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.license.LicenseUtils;
import com.dataiku.dip.license.TrialToken;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.UserCodes;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.DkuLicenseEnforcementService;
import com.dataiku.dip.server.services.licensing.LicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LicenseLimitsParser;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.server.services.licensing.SublicenseEnforcer;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LicenseEnforcementService
implements DkuLicenseEnforcementService {
    @Autowired
    private LicenseStatusService statusService;
    @Autowired
    private UsersService usersService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.licenseing.enforcement");

    public void checkCanCreateDataset(String datasetType) throws AbstractLicenseFeaturesStatusBuilder.LicenseFeatureException {
        LicenseStatusService.LicensingStatus ls = this.statusService.getLicensingStatus();
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus lls = this.getFeaturesStatus();
        boolean isPluginDataset = Stream.of("CustomPython_", "CustomJava_", "Sample_", "fsprovider_").anyMatch(datasetType::startsWith);
        if (isPluginDataset) {
            return;
        }
        switch (datasetType) {
            case "Filesystem": 
            case "UploadedFiles": 
            case "Inline": 
            case "MySQL": 
            case "PostgreSQL": 
            case "S3": 
            case "GCS": 
            case "FTP": 
            case "SFTP": 
            case "SCP": 
            case "HTTP": 
            case "Azure": 
            case "FilesInFolder": 
            case "Labels": 
            case "JobsDB": 
            case "StatsDB": 
            case "ExperimentsDB": {
                return;
            }
        }
        if (ls.community) {
            throw new AbstractLicenseFeaturesStatusBuilder.LicenseFeatureException("Free Edition license does not allow you to create a dataset of type " + datasetType);
        }
        if (lls.allowedDatasetTypes != null && !lls.allowedDatasetTypes.contains(datasetType)) {
            throw new AbstractLicenseFeaturesStatusBuilder.LicenseFeatureException("Your license does not allow you to create a dataset of type " + datasetType);
        }
    }

    public void checkUsersOverQuota(String explanation) throws LimitsStatusComputer.LicenseLimitException {
        LimitsStatusComputer.LicenseLimitsStatus lls = this.getLimitsStatus();
        for (LimitsStatusComputer.UsedProfileLimit upl : lls.profileLimits.values()) {
            if (upl.overQuota <= 0) continue;
            throw new LimitsStatusComputer.LicenseLimitException("Cannot " + explanation + ": you have exceeded your quota of users with profile " + upl.profile);
        }
    }

    public void checkPermissionChangeIsValid() throws LimitsStatusComputer.LicenseLimitException {
        this.checkUsersOverQuota("change permissions");
    }

    public boolean isLdapAllowed() {
        return this.getFeaturesStatus().ldapAllowed;
    }

    public void checkLdapAllowed() throws LimitsStatusComputer.LicenseLimitException {
        if (!this.isLdapAllowed()) {
            throw new LimitsStatusComputer.LicenseLimitException("Your license does not allow you to enable LDAP authentication");
        }
    }

    public LimitsStatusComputer.LicensedProfile getUserProfileByNameOrNull(String profile) {
        boolean addNoneProfile;
        LimitsStatusComputer.LicenseLimitsStatus lls = new LimitsStatusComputer.LicenseLimitsStatus();
        LicenseStatusService.LicensingStatus ls = this.statusService.getLicensingStatus();
        if (ls.hasLicense && ls.licenseContent.properties != null) {
            LicenseLimitsParser.parseLicensedProfiles((LicenseStatusService.LicensingStatus)ls, (LimitsStatusComputer.LicenseLimitsStatus)lls);
        }
        if (addNoneProfile = DKUApp.getParams().getBoolParam("dku.licensing.addNoneProfile", true)) {
            LicenseLimitsParser.addNoneProfile((LimitsStatusComputer.LicenseLimitsStatus)lls);
        }
        return (LimitsStatusComputer.LicensedProfile)lls.licensedProfiles.get(profile);
    }

    public LimitsStatusComputer.LicensedProfile getUserProfileByNameOrFallback(String profile) {
        LimitsStatusComputer.LicensedProfile lp;
        boolean addNoneProfile;
        LimitsStatusComputer.LicenseLimitsStatus lls = new LimitsStatusComputer.LicenseLimitsStatus();
        LicenseStatusService.LicensingStatus ls = this.statusService.getLicensingStatus();
        if (ls.hasLicense && ls.licenseContent.properties != null) {
            LicenseLimitsParser.parseLicensedProfiles((LicenseStatusService.LicensingStatus)ls, (LimitsStatusComputer.LicenseLimitsStatus)lls);
        }
        if (addNoneProfile = DKUApp.getParams().getBoolParam("dku.licensing.addNoneProfile", true)) {
            LicenseLimitsParser.addNoneProfile((LimitsStatusComputer.LicenseLimitsStatus)lls);
        }
        if ((lp = (LimitsStatusComputer.LicensedProfile)lls.licensedProfiles.get(profile)) == null) {
            return (LimitsStatusComputer.LicensedProfile)lls.licensedProfiles.get(lls.fallbackProfile);
        }
        return lp;
    }

    public LimitsStatusComputer.LicensedProfile getUserProfileByNameMand(String profile) throws DKUSecurityException {
        LimitsStatusComputer.LicensedProfile lp;
        boolean addNoneProfile;
        LimitsStatusComputer.LicenseLimitsStatus lls = new LimitsStatusComputer.LicenseLimitsStatus();
        LicenseStatusService.LicensingStatus ls = this.statusService.getLicensingStatus();
        if (ls.hasLicense && ls.licenseContent.properties != null) {
            LicenseLimitsParser.parseLicensedProfiles((LicenseStatusService.LicensingStatus)ls, (LimitsStatusComputer.LicenseLimitsStatus)lls);
        }
        if (addNoneProfile = DKUApp.getParams().getBoolParam("dku.licensing.addNoneProfile", true)) {
            LicenseLimitsParser.addNoneProfile((LimitsStatusComputer.LicenseLimitsStatus)lls);
        }
        if ((lp = (LimitsStatusComputer.LicensedProfile)lls.licensedProfiles.get(profile)) == null) {
            throw new DKUSecurityException("Unrecognized user profile");
        }
        return lp;
    }

    public static DKUSecurityException forbiddenByUserProfile(AuthCtx authCtx, String action) {
        return LicenseEnforcementService.forbiddenByUserProfile(authCtx, action, false);
    }

    public static DKUSecurityException forbiddenByUserProfile(AuthCtx authCtx, String action, boolean mustBeAdmin) {
        UserCodes userCode = mustBeAdmin ? UserCodes.ERR_USER_ACTION_FORBIDDEN_MUST_BE_ADMIN : UserCodes.ERR_USER_ACTION_FORBIDDEN_BY_PROFILE;
        return new UnauthorizedException("Your user profile (" + authCtx.getUserProfile() + ") does not allow you to " + action + ".", "user-profile-action-denied").withCode((InfoMessage.MessageCode)userCode);
    }

    public void checkAdminAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayAdmin) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "administrate DSS", true);
        }
    }

    public void checkRegularCodeAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayRegularCode) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "write code");
        }
    }

    public void checkSQLAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).maySQL) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "write SQL code");
        }
    }

    public void checkGitInProjectLibrariesAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayGitInProjectLibraries) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "use Git in libraries");
        }
    }

    public void checkWebappsAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayWebapps) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "build webapps");
        }
    }

    public void checkCodeStudiosAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayCodeStudios) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "use Code Studios");
        }
    }

    public void checkDevelopPluginsAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayWritePlugins) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "develop plugins");
        }
    }

    public void checkVisualMLAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayVisualML) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "use core visual ML capabilities");
        }
    }

    public void checkAdvancedVisualMLAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayAdvancedVisualML) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "use advanced visual ML capabilities (clustering, MLOps, computer vision, code-based deep learning, MLflow import, ...)");
        }
    }

    public void checkEDAAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayEDA) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "use visual statistics");
        }
    }

    public void checkLLMMeshPoweredRecipesAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayLLMMeshPoweredRecipes) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "use LLM-Mesh-powered recipes");
        }
    }

    public void checkBasicLLMMeshAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayBasicLLMMesh) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "use LLM Mesh capabilities");
        }
    }

    public void checkFullLLMMeshAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayFullLLMMesh) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "use advanced LLM Mesh capabilities");
        }
    }

    public void checkAgentReviewAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayReviewAgent) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "use Agent Review");
        }
    }

    public void checkReadProjectContentAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayReadProjectContent) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "read project content");
        }
    }

    public void checkWriteProjectContentAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayWriteProjectContent) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "write project content");
        }
    }

    public void checkWriteDashboardsAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayWriteDashboards) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "write dashboards");
        }
    }

    public void checkWriteWikiAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayWriteWiki) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "write wiki");
        }
    }

    public void checkWriteStoriesAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!this.getFeaturesStatus().storiesAllowed) {
            throw new SecurityException("Stories usage is not authorized by your license");
        }
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayWriteStories) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "write stories");
        }
    }

    public void checkReadDashboardsAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayReadProjectContent) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "read Dashboards");
        }
    }

    public void checkUseDataikuAppsAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((DSSAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayReadProjectContent) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "use Dataiku Applications");
        }
    }

    public LimitsStatusComputer.LicenseLimitsStatus getLimitsStatus() {
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        try (DSSMetrics.TimeCtx c2 = DSSMetrics.timeCtx((String)"dku.services.licensing.getLimitsStatus");){
            boolean addNoneProfile;
            LimitsStatusComputer.LicenseLimitsStatus ret = new LimitsStatusComputer.LicenseLimitsStatus();
            LicenseStatusService.LicensingStatus ls = this.statusService.getLicensingStatus();
            if (ls.hasLicense && ls.licenseContent.properties != null) {
                LicenseLimitsParser.parseLicensedProfiles((LicenseStatusService.LicensingStatus)ls, (LimitsStatusComputer.LicenseLimitsStatus)ret);
            }
            if (addNoneProfile = DKUApp.getParams().getBoolParam("dku.licensing.addNoneProfile", true)) {
                LicenseLimitsParser.addNoneProfile((LimitsStatusComputer.LicenseLimitsStatus)ret);
            }
            logger.trace(() -> "After parsing of profiles: " + JSON.log((Object)ret));
            new SublicenseEnforcer(ls.sublicense).restrict(ret);
            logger.trace(() -> "After sublicense: " + JSON.log((Object)ret));
            try {
                ArrayList<String> userProfiles = new ArrayList<String>();
                ArrayList<String> trialProfiles = new ArrayList<String>();
                for (UsersDAO.User u : this.usersService.listUsersInternalUnsafeEnabledOnly()) {
                    Pair<TrialTokenStatus, String> trialStatusAndResultingProfile = UsersService.computeTrialStatusAndResultingUserProfile(gs, u);
                    TrialTokenStatus tokenStatus = (TrialTokenStatus)trialStatusAndResultingProfile.first;
                    String resultingProfile = (String)trialStatusAndResultingProfile.second;
                    if (tokenStatus.exists && tokenStatus.valid) {
                        trialProfiles.add(resultingProfile);
                        continue;
                    }
                    userProfiles.add(resultingProfile);
                }
                ret.profileLimits = new LimitsStatusComputer().getLimitsStatus(ret.licensedProfiles.values(), ret.fallbackProfile, userProfiles, trialProfiles);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to get licensing limits", (Throwable)e);
            }
            logger.trace(() -> "License enforcement status " + JSON.prettyLog((Object)ret));
            LimitsStatusComputer.LicenseLimitsStatus licenseLimitsStatus = ret;
            return licenseLimitsStatus;
        }
    }

    public static TrialTokenStatus getTrialTokenStatus(UsersDAO.User u) {
        TrialTokenStatus status = new TrialTokenStatus();
        if (u.trialToken == null || u.trialToken.content == null) {
            return status;
        }
        DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.services.licensing.getTrialTokenStatus");
        try {
            status.exists = true;
            try {
                if (System.getenv("DKU_HA_LICENSE") == null) {
                    LicenseUtils.verify((TrialToken)u.trialToken);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("User " + u.login + " has a trial token, but invalid"), (Throwable)e);
                status.illegal = true;
                status.invalidReason = "Invalid (wrong signature. Tampered with?)";
                TrialTokenStatus trialTokenStatus = status;
                if (tctx != null) {
                    tctx.close();
                }
                return trialTokenStatus;
            }
            status.grantedOn = DKUDateUtils.parseISOUTC((String)u.trialToken.content.grantedAt);
            status.expiresOn = DKUDateUtils.parseISOUTC((String)u.trialToken.content.expiresAt);
            if (status.expiresOn < System.currentTimeMillis()) {
                logger.warn((Object)("User " + u.login + " has a trial token, but expired"));
                status.invalidReason = "Expired (on " + u.trialToken.content.expiresAt + ")";
                status.expired = true;
                TrialTokenStatus trialTokenStatus = status;
                return trialTokenStatus;
            }
            status.valid = true;
            TrialTokenStatus trialTokenStatus = status;
            return trialTokenStatus;
        }
        finally {
            if (tctx != null) {
                try {
                    tctx.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    public AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus getFeaturesStatus() {
        try (DSSMetrics.TimeCtx c2 = DSSMetrics.timeCtx((String)"dku.services.licensing.getFeaturesStatus");){
            LicenseStatusService.LicensingStatus ls = this.statusService.getLicensingStatus();
            AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus licenseFeaturesStatus = LicenseFeaturesStatusBuilder.getFeaturesStatus(ls);
            return licenseFeaturesStatus;
        }
    }

    public static class TrialTokenStatus {
        public boolean exists;
        public boolean expired;
        public boolean illegal;
        public boolean valid;
        public long grantedOn;
        public long expiresOn;
        public String invalidReason;
    }
}

