/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.input.formats.csv.CSVDeserializer;
import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.SQLCapability;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class PrestoSQLDialect
extends HiveSQLDialect {
    private final Pattern timestampWithTimeZonePattern = Pattern.compile("([^ ]+ [^ ]+) (.*)");

    @Override
    public String getIdentifierQuoteChar() {
        return "\"";
    }

    @Override
    public boolean supportsTopLevelUnion() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean isCatalogAware() {
        return true;
    }

    @Override
    public String escapeSchemaOrTableNameForJDBCMetadataQuerying(String identifier) {
        if (identifier == null) {
            return null;
        }
        return identifier.toLowerCase().replace("_", "\\_");
    }

    @Override
    public List<String> getTableTypesWithoutOverrides(SQLDialect.GetTableTypesReason reason) {
        List<String> tableTypes = super.getTableTypesWithoutOverrides(reason);
        tableTypes.add("EXTERNAL_TABLE");
        tableTypes.add("VIRTUAL_VIEW");
        return tableTypes;
    }

    @Override
    public String quoteString(String str) {
        String sep = this.getStringQuoteChar();
        str = StringEscapeUtils.escapeSql((String)str);
        return sep + str + sep;
    }

    @Override
    public String quoteDate(String str) {
        return this.castAsDate(this.quoteString(str), null);
    }

    protected String castAsDate(String str, Type type) {
        com.dataiku.dip.shaker.types.Date dateMeaning = new com.dataiku.dip.shaker.types.Date();
        if (dateMeaning.msSinceEpoch(str) != Long.MAX_VALUE) {
            return "FROM_ISO8601_TIMESTAMP(" + str + ")";
        }
        return "CAST(" + str + " AS TIMESTAMP WITH TIME ZONE)";
    }

    @Override
    public String quoteDateOnly(String str) {
        return "CAST(" + this.quoteString(str) + " AS DATE)";
    }

    @Override
    public String quoteDatetimeNoTz(String str) {
        return "CAST(" + this.quoteString(str) + " AS TIMESTAMP)";
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case STRING: {
                return new DSSTypeSQLMapping(Type.STRING, 12, "varchar", new Integer[0]);
            }
            case INT: {
                return new DSSTypeSQLMapping(Type.INT, 4, "integer", new Integer[0]);
            }
            case FLOAT: 
            case DOUBLE: {
                return new DSSTypeSQLMapping(Type.DOUBLE, 8, "double", new Integer[]{7, 2, 3});
            }
            case DATE: {
                return new DSSTypeSQLMapping(Type.DATE, 93, "timestamp with time zone", new Integer[]{91, 2014});
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public SchemaColumn fromSQLType(String name, int sqlType, String sqlTypeName, int sqlPrecision, int sqlScale, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        if (sqlTypeName != null && sqlTypeName.toLowerCase().startsWith("timestamp") && sqlTypeName.toLowerCase().endsWith("with time zone")) {
            return new SchemaColumn(name, Type.DATE).withOriginalType(sqlTypeName).withOriginalSQLType(sqlTypeName);
        }
        return super.fromSQLType(name, sqlType, sqlTypeName, sqlPrecision, sqlScale, datetimenotzReadMode, dateonlyReadMode);
    }

    @Override
    public boolean requiresStrictTypeComparison() {
        return true;
    }

    @Override
    public String getId() {
        return "Presto";
    }

    @Override
    public String createTemporaryTable(SQLUtils.SQLTable table, String columnListExpr) {
        throw new IllegalStateException("Cannot create temporary table to be filled later");
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        return new String[]{"CREATE TABLE " + this.getQuotedTableFullName(table) + " AS " + selectExpr};
    }

    @Override
    public String dropTemporaryTable(SQLUtils.SQLTable table) {
        return "DROP TABLE " + this.getTableFullName(table.getCatalog(), table.getSchemaNullIfBlank(), table.getTable());
    }

    @Override
    protected String typeNameForCastAsString() {
        return "VARCHAR";
    }

    @Override
    public String convertToVarchar(String inputExpr, int len) {
        return "CAST((" + inputExpr + ") AS " + this.typeNameForCastAsString() + ")";
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return "timestamp".equalsIgnoreCase(sqlTypeName);
    }

    @Override
    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        if (requestedType == Type.BOOLEAN && exprType == Type.STRING) {
            return "CASE WHEN (" + expr + ") IS NULL OR CAST(" + expr + " AS VARCHAR) = '' THEN NULL when regexp_like(lower(CAST(" + expr + " AS VARCHAR)), '^" + this.booleanTrueValuesRegex + "$') then true else false END";
        }
        String sqlType = this.getSQLType((Type)requestedType, (int)maxLength, (String)expr).sqlDecl.toUpperCase();
        if (requestedType.isNumeric() && requestedType.isInteger() && exprType == Type.STRING) {
            return "cast(cast(" + expr + " as double) as " + sqlType + ")";
        }
        if (requestedType == Type.DATE) {
            return this.castAsDate(expr, exprType);
        }
        if (sqlType.startsWith("VARCHAR")) {
            sqlType = this.typeNameForCastAsString();
        }
        return "CAST( (" + expr + ") AS " + sqlType + ")";
    }

    @Override
    public String getValueAsDSSString(ResultSet rs2, int sqlType, int colIdx, SchemaColumn schemaColumn, boolean normalizeDoubles, boolean timestampNoTzAsDate, DateTimeZone assumedTz) throws SQLException {
        Type dssType = schemaColumn.getType();
        switch (sqlType) {
            case 91: {
                if (dssType == Type.DATE) {
                    this.ensureThreadLocalsAreHere();
                    Date dt = rs2.getDate(colIdx, assumedTz != null ? Calendar.getInstance(assumedTz.toTimeZone()) : (Calendar)this.utcCalendar.get());
                    if (dt == null) {
                        return null;
                    }
                    return DKUtils.isoFormatReadableByDateFormat((long)dt.getTime());
                }
                return rs2.getString(colIdx);
            }
            case 93: 
            case 2014: {
                if (dssType == Type.DATE) {
                    this.ensureThreadLocalsAreHere();
                    if (timestampNoTzAsDate) {
                        Timestamp ts = rs2.getTimestamp(colIdx, assumedTz != null ? Calendar.getInstance(assumedTz.toTimeZone()) : (Calendar)this.localCalendar.get());
                        if (ts == null) {
                            return null;
                        }
                        return DKUtils.isoFormatReadableByDateFormat((long)ts.getTime());
                    }
                    Timestamp ts = rs2.getTimestamp(colIdx, (Calendar)this.utcCalendar.get());
                    if (ts == null) {
                        return null;
                    }
                    return DKUtils.isoFormatReadableByDateFormat((long)ts.getTime());
                }
                return rs2.getString(colIdx);
            }
            case 12: {
                if (dssType == Type.DATE) {
                    String val = rs2.getString(colIdx);
                    if (val == null) {
                        return null;
                    }
                    DateTime ts = this.readTimestampWithTimeZoneStringAsDateTime(val);
                    if (ts != null) {
                        return CSVDeserializer.isoFormatter.print((ReadableInstant)ts);
                    }
                    return val;
                }
                return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
            }
        }
        return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
    }

    public DateTime readTimestampWithTimeZoneStringAsDateTime(String val) {
        Matcher m = this.timestampWithTimeZonePattern.matcher(val);
        if (m.matches()) {
            DateTime ts = CSVDeserializer.hiveDateParser.parseDateTime(m.group(1));
            DateTimeZone tz = DateTimeZone.forID((String)m.group(2));
            if (!tz.equals((Object)DateTimeZone.UTC)) {
                ts = ts.withZoneRetainFields(tz);
            }
            return ts;
        }
        return null;
    }

    @Override
    protected String dateDiff(String end, String start, String unit, Type type) {
        switch (unit) {
            case "YEAR": {
                return "date_diff('year', " + start + ", " + end + ")";
            }
            case "MONTH": {
                return "date_diff('month', " + start + ", " + end + ")";
            }
            case "WEEK": {
                return "date_diff('week', " + start + ", " + end + ")";
            }
            case "DAY": {
                return "date_diff('day', " + start + ", " + end + ")";
            }
            case "HOUR": {
                return "date_diff('hour', " + start + ", " + end + ")";
            }
            case "MINUTE": {
                return "date_diff('minute', " + start + ", " + end + ")";
            }
            case "SECOND": {
                return "date_diff('second', " + start + ", " + end + ")";
            }
        }
        throw new IllegalArgumentException("Unknown datepart: '" + unit + "'");
    }

    @Override
    public String dateonlyPartExpression(String expr, DatePart part) {
        return this.temporalPartExpression(expr, part);
    }

    @Override
    public String datetimenotzPartExpression(String expr, DatePart part) {
        return this.temporalPartExpression(expr, part);
    }

    @Override
    public String datePartExpression(String expr, DatePart part) {
        return this.temporalPartExpression("(" + expr + ") AT TIME ZONE 'UTC'", part);
    }

    @Override
    public String temporalPartExpression(String expr, DatePart part) {
        switch (part) {
            case DAY_OF_WEEK: {
                return "day_of_week(" + expr + ")";
            }
            case DAY_OF_MONTH: {
                return "day_of_month(" + expr + ")";
            }
            case WEEK_OF_YEAR: {
                return "week_of_year(" + expr + ")";
            }
            case QUARTER_OF_YEAR: {
                return "quarter(" + expr + ")";
            }
            case SECOND_FROM_EPOCH: {
                return "cast(to_unixtime(" + expr + ") as bigint)";
            }
            case MILLIS_FROM_EPOCH: {
                return "cast((1000 * to_unixtime(" + expr + ")) as bigint)";
            }
            case MILLISECOND_OF_SECOND: {
                return "millisecond(" + expr + ")";
            }
        }
        return super.temporalPartExpression(expr, part);
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc("(" + inputDateExpression + ") AT TIME ZONE 'UTC'", rounding, false);
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding, true);
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding, false);
    }

    @Override
    protected String temporalTrunc(String inputDateExpression, DateRounding rounding, boolean isDateOnly) {
        if (isDateOnly && ImmutableList.of((Object)DateRounding.HOUR, (Object)DateRounding.MINUTE, (Object)DateRounding.SECOND).contains((Object)rounding)) {
            throw new UnsupportedOperation("Date truncation with unit '" + String.valueOf(rounding) + "' is not supported for date only columns");
        }
        return "date_trunc('" + rounding.toString() + "', " + inputDateExpression + ")";
    }

    @Override
    public boolean canExtractMilliseconds() {
        return true;
    }

    @Override
    public void initOperators() {
        super.initOperators();
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATE_ADD, QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String datetimeNoTz = this.toSQLNoBrackets(args[0]);
                String addIntLong = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class);
                return "date_add('" + unit + "', " + addIntLong + ", " + datetimeNoTz + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.MD5, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                return "lower(to_hex(MD5(to_utf8(" + column + "))))";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SHA256, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                return "lower(to_hex(sha256(to_utf8(" + column + "))))";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SHA512, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                return "lower(to_hex(sha512(to_utf8(" + column + "))))";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 1);
                String formattedToStringExpr = "format_datetime(cast(" + this.toSQLNoBrackets(args[0]) + " as timestamp), 'yyyy-MM-dd HH:mm:ss.SSS')";
                if (args.length > 2 && args[2] != null) {
                    String translatedExpr = "cast(concat(" + formattedToStringExpr + ", ' ', " + this.toSQLNoBrackets(args[2]) + ") as TIMESTAMP WITH TIME ZONE)";
                    return "CAST(format_datetime(" + translatedExpr + " AT TIME ZONE " + this.toSQLNoBrackets(args[1]) + ", 'yyyy-MM-dd HH:mm:ss.SSS') AS TIMESTAMP WITH TIME ZONE)";
                }
                if (args.length > 1 && args[1] != null) {
                    return "cast(concat(" + formattedToStringExpr + ", ' ', " + this.toSQLNoBrackets(args[1]) + ") as TIMESTAMP WITH TIME ZONE)";
                }
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                Type requestedType;
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                if (args[0].outputType != null && args[0].outputType.dssType != Type.STRING) {
                    input = "CAST(" + (String)input + " AS VARCHAR)";
                }
                if ((requestedType = this.getParamAs(args[1], Type.class)).isTemporal()) {
                    String converted;
                    String timezoneId;
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String string = timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    if (requestedType == Type.DATEONLY) {
                        String sqlFormat = PrestoSQLDialect.this.toDateFormat(jodaFormat, true);
                        return "CAST(PARSE_DATETIME(" + (String)input + ",'" + sqlFormat + "') AS DATE)";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        String sqlFormat = PrestoSQLDialect.this.toDateFormat(jodaFormat, true);
                        return "CAST(PARSE_DATETIME(" + (String)input + ",'" + sqlFormat + "') AS TIMESTAMP)";
                    }
                    if (DKUDateUtils.isISO8601FormatString((String)jodaFormat)) {
                        converted = "FROM_ISO8601_TIMESTAMP(" + (String)input + ")";
                    } else {
                        String sqlFormat = PrestoSQLDialect.this.toDateFormat(jodaFormat, true);
                        converted = "PARSE_DATETIME(" + (String)input + ",'" + sqlFormat + "')";
                    }
                    if (StringUtils.equals((String)timezoneId, (String)"UTC")) {
                        return converted;
                    }
                    String formattedToStringExpr = "FORMAT_DATETIME(" + converted + ", 'yyyy-MM-dd HH:mm:ss.SSS')";
                    return "CAST(CONCAT(" + formattedToStringExpr + ", ' ', '" + timezoneId + "') as TIMESTAMP WITH TIME ZONE)";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CONCAT, "CONCAT", QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                StringBuilder sb = new StringBuilder("CONCAT(").append(this.castToString(args[0]));
                for (int i = 1; i < args.length; ++i) {
                    sb.append(", ").append(this.castToString(args[i]));
                }
                return sb.append(")").toString();
            }

            private String castToString(QueryAst.Expr arg) {
                return "COALESCE(CAST(" + this.toSQLNoBrackets(arg) + " AS VARCHAR), '')";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FORMAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    timezoneId = StringUtils.defaultIfBlank((String)timezoneId, (String)"UTC");
                    if (requestedType.isTimestamp() && StringUtils.isNotBlank((String)timezoneId) && !StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        input = "cast(" + (String)input + " as timestamp) at time zone'" + timezoneId + "'";
                    }
                    String sqlFormat = PrestoSQLDialect.this.toDateFormat(jodaFormat, false);
                    return "format_datetime(" + (String)input + ",'" + sqlFormat + "')";
                }
                throw new NotImplementedException("format as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_APPROX_AGG, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "approx_percentile(" + column + "," + percentile + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_APPROX_WIN, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "approx_percentile(" + column + "," + percentile + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "STRING_TO_TIMESTAMPTZ", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String ret = this.toSQLNoBrackets(args[0]);
                return PrestoSQLDialect.this.quoteDate(ret);
            }
        });
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_DATE, "CAST(", " AS DATE)"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_TIMESTAMP, "CAST(", " AS TIMESTAMP)"));
        this.addGenericFunction(QueryUtils.OperatorType.NOW, "NOW", QueryUtils.Arity.NO_ARG);
        this.addGenericOperator(QueryUtils.OperatorType.MOD, "%", QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.MOD.priority);
        this.removeOperator(QueryUtils.OperatorType.TRY_PARSE);
        this.removeOperator(QueryUtils.OperatorType.FACT);
        this.removeOperator(QueryUtils.OperatorType.DEC2HEX);
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META, QuotedPortionFinders.BackTickedNoEscapeFinder.META, QuotedPortionFinders.BackslashEscapedSingleQuotedFinder.META, QuotedPortionFinders.BackslashEscapedDoubleQuotedFinder.META};
    }

    @Override
    public SQLCapability canFormatDatePart(DKUDateUtils.FormatPatternPart part, boolean forParsing) {
        return SQLCapability.ok();
    }

    @Override
    public String toDateFormatPart(DKUDateUtils.FormatPatternPart part, boolean forParsing, boolean hasIsoDatePart) {
        switch (part.type) {
            case ERA: {
                return "GG";
            }
            case YEAR: 
            case YEAROFERA: {
                return super.toDateFormatPart(part, forParsing, hasIsoDatePart);
            }
            case WEEK: {
                return "ww";
            }
            case WEEKYEAR: {
                return part.shortened ? "xx" : "xxxx";
            }
            case MONTH: {
                if (part.numeric) {
                    return "MM";
                }
                if (part.shortened) {
                    return "MMM";
                }
                return "MMMM";
            }
            case DAY: {
                return "dd";
            }
            case DAYOFYEAR: {
                return "DD";
            }
            case DAYOFWEEK: {
                if (part.numeric) {
                    return "e";
                }
                if (part.shortened) {
                    return "EEE";
                }
                return "EEEE";
            }
            case HOUR: {
                return "HH";
            }
            case HALFDAY: {
                return "a";
            }
            case HOUROFHALFDAY: {
                return "KK";
            }
            case CLOCKHOUR: {
                return "kk";
            }
            case CLOCKHOUROFHALFDAY: {
                return "hh";
            }
            case MINUTE: {
                return "mm";
            }
            case SECOND: {
                return "ss";
            }
            case MILLISECOND: {
                return "SSS";
            }
            case TIMEZONE: {
                if (part.numeric) {
                    return "Z";
                }
                return "z";
            }
            case TEXT: {
                Pattern toEscape = Pattern.compile("[a-zA-Z0-9\"']");
                if (toEscape.matcher(part.text).matches()) {
                    return "\\'" + part.text.replace("'", "\\'\\'") + "\\'";
                }
                return part.text;
            }
        }
        return part.text;
    }
}

