/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NotImplementedException;

public class SqreamSQLDialect
extends GenericSQLDialect {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.sqldialect.sqream");

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case STRING: {
                return new DSSTypeSQLMapping(Type.STRING, 12, "text", new Integer[]{2003, 1, 1111, -16, -1, -9});
            }
            case FLOAT: {
                return new DSSTypeSQLMapping(Type.FLOAT, 6, "real", new Integer[]{7, 2});
            }
            case BOOLEAN: {
                return new DSSTypeSQLMapping(Type.BOOLEAN, 16, "bool", new Integer[]{-7});
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public SchemaColumn fromSQLType(String name, int sqlType, String sqlTypeName, int sqlPrecision, int sqlScale, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        return super.fromSQLType(name, sqlType, sqlTypeName, sqlPrecision, sqlScale, datetimenotzReadMode, dateonlyReadMode);
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.NestedMultiLineCommentFinder.META, QuotedPortionFinders.PostgresStringLiteralFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META, QuotedPortionFinders.EscapedStringLiteralFinder.META, QuotedPortionFinders.PostgresDollarQuotedLiteralFinder.META};
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.DATEDIFF, null, QueryUtils.Arity.NARY, GenericSQLDialect.SQLPriority.PARENTHESES.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String unit;
                this.validateMinNumberOfParameters(args, 3);
                String end = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.PLUS.priority);
                String start = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.PLUS.priority);
                switch (unit = this.getParamAs(args[2], String.class)) {
                    case "YEAR": {
                        return "DATEDIFF(YEAR," + start + "," + end + ")";
                    }
                    case "MONTH": {
                        return "DATEDIFF(MONTH," + start + "," + end + ")";
                    }
                    case "WEEK": {
                        return "DATEDIFF(WEEK," + start + "," + end + ")";
                    }
                    case "DAY": {
                        return "DATEDIFF(DAY," + start + "," + end + ")";
                    }
                    case "HOUR": {
                        return "DATEDIFF(HOUR," + start + "," + end + ")";
                    }
                    case "MINUTE": {
                        return "DATEDIFF(MINUTE," + start + "," + end + ")";
                    }
                    case "SECOND": {
                        return "DATEDIFF(SECOND," + start + "," + end + ")";
                    }
                }
                throw new QueryUtils.SQLGenerationException("Date difference with unit '" + unit + "' not implemented for " + SqreamSQLDialect.this.getId());
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.LEAST, QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 2;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                return "(CASE WHEN " + this.toSQLNoBrackets(args[0]) + " > " + this.toSQLNoBrackets(args[1]) + " then " + this.toSQLNoBrackets(args[1]) + " else " + this.toSQLNoBrackets(args[0]) + " end)";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.GREATEST, QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 2;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                return "(CASE WHEN " + this.toSQLNoBrackets(args[0]) + " <= " + this.toSQLNoBrackets(args[1]) + " then " + this.toSQLNoBrackets(args[1]) + " else " + this.toSQLNoBrackets(args[0]) + " end)";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_CONT, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "percentile_cont(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_APPROX_AGG, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "percentile_disc(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ")";
            }
        });
    }

    @Override
    public int getIdentifiersMaxLength() {
        return 128;
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        return this.getLimitedQueryUsingLimit(query, size);
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        return new String[]{"CREATE TABLE " + this.getQuotedTableFullName(table) + " AS " + selectExpr};
    }

    @Override
    public String createTemporaryTable(SQLUtils.SQLTable table, String columnListExpr) {
        return "CREATE TABLE " + this.getQuotedTableFullName(table) + " (" + columnListExpr + ") ";
    }

    @Override
    public boolean supportsNullsOrdering() {
        return false;
    }

    @Override
    public boolean supportsIndexing() {
        return false;
    }

    @Override
    public boolean supportsIndexingOnTemporaryTables() {
        return false;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    public boolean supportsCommitAndRollback() {
        return false;
    }

    @Override
    public String getId() {
        return "Sqream";
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "EXTRACT(DAY FROM " + inputDateExpression + ")";
            }
            case HOUR_OF_DAY: {
                return "EXTRACT(HOUR FROM " + inputDateExpression + ")";
            }
            case MINUTE_OF_HOUR: {
                return "EXTRACT(MINUTE FROM " + inputDateExpression + ")";
            }
            case SECOND_OF_MINUTE: {
                return "EXTRACT(SECOND FROM " + inputDateExpression + ")";
            }
            case MONTH_OF_YEAR: {
                return "EXTRACT(MONTH FROM " + inputDateExpression + ")";
            }
            case WEEK_OF_YEAR: {
                return "DATEPART(WEEK, " + inputDateExpression + ")";
            }
            case QUARTER_OF_YEAR: {
                return "DATEPART(QUARTER, " + inputDateExpression + ")";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM " + inputDateExpression + ")";
            }
            case DAY_OF_WEEK: {
                return "((DATEPART(WEEKDAY, " + inputDateExpression + ") + 5 ) % 7 + 1)";
            }
            case SECOND_FROM_EPOCH: {
                return "cast(DATEDIFF(SECOND, '1970-01-01 00:00:00.000', " + inputDateExpression + " ) as bigint)";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on Sqream", part));
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        String dateAtGmt = inputDateExpression;
        switch (rounding) {
            case DAY: {
                return "TRUNC(" + dateAtGmt + ", DAY)";
            }
            case HOUR: {
                return "TRUNC(" + dateAtGmt + ", HOUR)";
            }
            case WEEK: {
                return "TRUNC(" + dateAtGmt + ", WEEK)";
            }
            case MONTH: {
                return "TRUNC(" + dateAtGmt + ", MONTH)";
            }
            case YEAR: {
                return "TRUNC(" + dateAtGmt + ", YEAR)";
            }
            case QUARTER: {
                return "TRUNC(" + dateAtGmt + ", QUARTER)";
            }
            case MINUTE: {
                return "TRUNC(" + dateAtGmt + ", MINUTE)";
            }
            case SECOND: {
                return "TRUNC(" + dateAtGmt + ", SECOND)";
            }
        }
        throw new QueryUtils.SQLGenerationException("Date trunc with unit '" + String.valueOf(rounding) + "' not implemented for Sqream");
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return -1;
    }
}

