/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.AbstractQueryBuilder;
import com.dataiku.dip.sql.queries.QueryBuilderUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class CreateTableQueryBuilder
extends AbstractQueryBuilder {
    private boolean checkIfNotExists = false;
    protected List<SchemaColumn> columns = new ArrayList<SchemaColumn>();
    private final List<String> keyColumnNames = new ArrayList<String>();

    public static CreateTableQueryBuilder createTable(SQLUtils.SQLTable table) {
        return new CreateTableQueryBuilder(table);
    }

    private CreateTableQueryBuilder(SQLUtils.SQLTable table) {
        super(table);
    }

    @Override
    protected void assertBuilderIsValid() {
        super.assertBuilderIsValid();
        Preconditions.checkState((!this.columns.isEmpty() ? 1 : 0) != 0, (Object)"No columns selected for CREATE TABLE statement.");
    }

    @Override
    void buildSQLQueries() {
        String ine = this.checkIfNotExists ? "IF NOT EXISTS " : "";
        this.queries.add("CREATE TABLE " + ine + this.getQuotedTableFullName() + " (" + this.getDefinition(this.getColumnToDefinition()) + this.getPrimaryKey() + ")");
    }

    public CreateTableQueryBuilder addColumns(SchemaColumn ... columns) {
        for (SchemaColumn column : columns) {
            this.columns.add(new SchemaColumn(column));
        }
        return this;
    }

    public CreateTableQueryBuilder addColumns(SchemaColumn[] ... columnsGroups) {
        SchemaColumn[][] schemaColumnArray = columnsGroups;
        int n = schemaColumnArray.length;
        for (int i = 0; i < n; ++i) {
            SchemaColumn[] columnGroup;
            for (SchemaColumn column : columnGroup = schemaColumnArray[i]) {
                this.addColumns(column);
            }
        }
        return this;
    }

    public CreateTableQueryBuilder addKeyColumns(String ... columns) {
        if (columns != null) {
            this.keyColumnNames.addAll(Arrays.asList(columns));
        }
        return this;
    }

    public CreateTableQueryBuilder addKeyColumns(SchemaColumn[] ... columnsGroups) {
        SchemaColumn[][] schemaColumnArray = columnsGroups;
        int n = schemaColumnArray.length;
        for (int i = 0; i < n; ++i) {
            SchemaColumn[] columnGroup;
            for (SchemaColumn column : columnGroup = schemaColumnArray[i]) {
                this.addKeyColumns(column.getName());
            }
        }
        return this;
    }

    private String getQuotedTableFullName() {
        return this.dialect.getQuotedTableFullName(this.table);
    }

    private String transformAndJoinColumns(Function<SchemaColumn, String> transformation) {
        return FluentIterable.from(this.columns).transform(transformation).join(QueryBuilderUtils.COMMA_JOINER);
    }

    private Function<SchemaColumn, String> getColumnToDefinition() {
        return new Function<SchemaColumn, String>(){

            public String apply(SchemaColumn column) {
                return QueryBuilderUtils.columnDefinition(column, CreateTableQueryBuilder.this.dialect);
            }
        };
    }

    public CreateTableQueryBuilder ifNotExists() {
        this.checkIfNotExists = true;
        return this;
    }

    private String getPrimaryKey() {
        if (this.keyColumnNames.isEmpty()) {
            return "";
        }
        return ", PRIMARY KEY " + QueryBuilderUtils.tuple(this.keyColumnNames, this.dialect);
    }

    private String getDefinition(Function<SchemaColumn, String> transformation) {
        this.setColumnMaxLength();
        return this.transformAndJoinColumns(transformation);
    }

    private void setColumnMaxLength() {
        List<SchemaColumn> keyColumns = this.getSchemaColumnForKeys();
        this.dialect.setDefaultLengthForSchemaColumn(new Schema(this.columns, false), keyColumns, new InfoMessage.InfoMessages());
    }

    private List<SchemaColumn> getSchemaColumnForKeys() {
        ImmutableMap definedColumnsByName = FluentIterable.from(this.columns).uniqueIndex((Function)new Function<SchemaColumn, String>(){

            public String apply(SchemaColumn schemaColumn) {
                return schemaColumn.getName();
            }
        });
        return FluentIterable.from(this.keyColumnNames).transform((Function)new Function<String, SchemaColumn>(){
            final /* synthetic */ Map val$definedColumnsByName;
            {
                this.val$definedColumnsByName = map;
            }

            public SchemaColumn apply(String columnName) {
                SchemaColumn keyColumn = (SchemaColumn)this.val$definedColumnsByName.get(columnName);
                if (keyColumn == null) {
                    throw new IllegalStateException(String.format("Cannot specify a key column that has not been added to the columns of the table: '%s'", columnName));
                }
                return keyColumn;
            }
        }).toList();
    }
}

