/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.crecipes.sync;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.streaming.crecipes.sync.CSyncRecipeCreator;
import com.dataiku.dip.streaming.crecipes.sync.CSyncRecipeParams;
import com.dataiku.dip.streaming.crecipes.sync.CsyncRecipeSchemaComputer;
import com.dataiku.dip.streaming.crecipes.sync.CsyncRecipeStatusComputer;

public class CSyncRecipeMeta
extends RecipeMeta {
    public static final CSyncRecipeMeta META = new CSyncRecipeMeta();

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return CSyncRecipeParams.class;
    }

    @Override
    public String getType() {
        return "csync";
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) {
        throw new Error("this is a streaming recipe");
    }

    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.RELIABLE_STATIC;
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return new CsyncRecipeSchemaComputer(authCtx, activity);
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
        return new CsyncRecipeStatusComputer(recipe, payload);
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new CSyncRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        RecipeDesc ret = RecipeDesc.newSisoDesc("csync", null).multiEngine(true);
        RecipeDesc.IORoleDef in = ret.inputRoles.get(0);
        in.acceptsStreamingEndpoint = true;
        in.acceptsDataset = false;
        RecipeDesc.IORoleDef out = ret.outputRoles.get(0);
        out.acceptsStreamingEndpoint = true;
        out.acceptsDataset = true;
        return ret;
    }

    @Override
    public InputDatasetsReadParams getInputDatasetsReadParams(SerializedRecipe sr, String payload) {
        return sr.getParamsAs(CSyncRecipeParams.class).engineParams.spark.readParams;
    }

    @Override
    public String setInputDatasetsReadParams(SerializedRecipe sr, String payload, InputDatasetsReadParams inputDatasetsReadParams) {
        CSyncRecipeParams params = sr.getParamsAs(CSyncRecipeParams.class);
        params.engineParams.spark.readParams = inputDatasetsReadParams;
        return payload;
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags();
    }

    @Override
    public boolean hasJsonPayload() {
        return false;
    }
}

