/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.timelines;

import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.workspaces.Workspace;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.google.gson.JsonObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnrichmentService {
    @Autowired
    private UsersService usersService;
    @Autowired
    private WorkspacesService workspacesService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.enrichement");

    public void enrich(EnrichableSmartId en, String contextProjectKey) {
        if (en.getTaggableType() == ITaggingService.TaggableType.PROJECT) {
            this.enrich(en.getObjectSmartId(), en.getTaggableType(), en.getObjectSmartId(), null, en.getUserLogin(), en.getDetails());
        } else {
            AnyLoc loc = AnyLoc.resolveSmart(contextProjectKey, en.getObjectSmartId()).resolved();
            this.enrich(loc.getProjectKey(), en.getTaggableType(), loc.getId(), null, en.getUserLogin(), en.getDetails());
        }
    }

    public void enrich(Enrichable en) {
        this.enrich(en.getProjectKey(), en.getTaggableType(), en.getObjectId(), en.getWorkspaceKey(), en.getUserLogin(), en.getDetails());
    }

    private void enrich(String projectKey, ITaggingService.TaggableType taggableType, String id, String workspaceKey, String userLogin, JsonObject details) {
        block21: {
            try {
                if (taggableType == null) {
                    return;
                }
                taggableType.assertNotFakeType();
                TaggableObjectsService.TaggableObject obj = this.taggableObjectsReadService.getMandatoryUnsafe(projectKey, taggableType, id);
                details.addProperty("objectDisplayName", obj.getDisplayName());
                switch (taggableType) {
                    case DATASET: {
                        details.addProperty("datasetType", ((SerializedDataset)obj).type);
                        break;
                    }
                    case STREAMING_ENDPOINT: {
                        details.addProperty("streamingType", ((StreamingEndpoint)obj).type);
                        break;
                    }
                    case RECIPE: {
                        details.addProperty("recipeType", ((SerializedRecipe)obj).type);
                        break;
                    }
                    case INSIGHT: {
                        details.addProperty("insightType", ((Insight)obj).type);
                        break;
                    }
                    case WEB_APP: {
                        details.addProperty("webappType", ((WebApp)obj).type);
                        break;
                    }
                    case CODE_STUDIO: {
                        details.addProperty("codeStudioTemplateId", ((CodeStudioObject)obj).templateId);
                        break;
                    }
                    case SAVED_MODEL: {
                        details.addProperty("savedModelMLCategory", ((SavedModel)obj).getMLCategory());
                    }
                }
            }
            catch (NotFoundException e) {
                logger.traceV("Failed to enrich item (object not found): %s <%s.%s> %s", new Object[]{taggableType, projectKey, id, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                if (details != null) {
                    details.addProperty("itemNotFound", Boolean.valueOf(true));
                    details.addProperty("failedToEnrichItem", Boolean.valueOf(true));
                }
            }
            catch (Exception e) {
                logger.infoV("Failed to enrich item <%s.%s> %s", new Object[]{projectKey, id, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                if (details == null) break block21;
                details.addProperty("failedToEnrichItem", Boolean.valueOf(true));
            }
        }
        try {
            PublicUser pu;
            String user = userLogin;
            if (StringUtils.isNotBlank((String)user) && (pu = this.usersService.getPublicUser(user)) != null) {
                details.addProperty("userDisplayName", pu.displayName);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to enrich item with user details: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        if (StringUtils.isNotBlank((String)workspaceKey)) {
            try {
                Workspace workspace = this.workspacesService.getRawWorkspaceUnsafe(workspaceKey);
                if (workspace != null) {
                    details.addProperty("workspaceDisplayName", workspace.displayName);
                    details.addProperty("workspaceColor", workspace.color);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to enrich item with workspace details: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
    }

    public static interface EnrichableSmartId {
        public ITaggingService.TaggableType getTaggableType();

        public String getObjectSmartId();

        public String getUserLogin();

        public JsonObject getDetails();
    }

    public static interface Enrichable {
        public ITaggingService.TaggableType getTaggableType();

        public String getProjectKey();

        public String getObjectId();

        public String getUserLogin();

        public String getWorkspaceKey();

        public JsonObject getDetails();
    }
}

