/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.timelines;

import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.db.DSSDBConnectionsManagementService;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.timelines.AbstractTimelinesService;
import com.dataiku.dip.timelines.ITimelinesDBService;
import com.dataiku.dip.timelines.MultiTimelinesInternalDB;
import com.dataiku.dip.timelines.ProjectTimelineBehavior;
import com.dataiku.dip.timelines.SingleTimelinesInternalDB;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimelinesInternalDB
extends AbstractTimelinesService {
    @Autowired
    private DSSDBConnectionsManagementService internalDBConnectionsService;
    private ITimelinesDBService concreteTimelinesDAO;

    @PostConstruct
    public void init() throws CodedSQLException {
        this.concreteTimelinesDAO = this.internalDBConnectionsService.isUsingInternalH2() ? new MultiTimelinesInternalDB() : new SingleTimelinesInternalDB();
    }

    @Override
    public void createProject(String projectKey) throws CodedSQLException {
        this.concreteTimelinesDAO.createProject(projectKey);
    }

    @Override
    public void deleteForProject(String projectKey) {
        this.concreteTimelinesDAO.deleteForProject(projectKey);
    }

    @Override
    public ProjectTimelineBehavior getDao(String projectKey) throws CodedSQLException {
        return this.concreteTimelinesDAO.getDao(projectKey);
    }

    @Override
    public DSSDBConnection acquireConnection(String projectKey, boolean isReadOnly) throws CodedSQLException {
        return this.concreteTimelinesDAO.acquireConnection(projectKey, isReadOnly);
    }
}

