/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.variables;

import com.dataiku.dip.variables.BuiltinVariableExpansionFilters;
import com.dataiku.dip.variables.VariableExpansionFilter;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class VariableExpansionFilterParser {
    private static final Map<String, Class<? extends VariableExpansionFilter>> FILTERS_REGISTRY = ImmutableMap.builder().put((Object)"tolower", BuiltinVariableExpansionFilters.ToLower.class).put((Object)"toupper", BuiltinVariableExpansionFilters.ToUpper.class).put((Object)"default", BuiltinVariableExpansionFilters.DefaultValue.class).put((Object)"tojson", BuiltinVariableExpansionFilters.ToJson.class).put((Object)"fromjson", BuiltinVariableExpansionFilters.FromJson.class).put((Object)"getornull", BuiltinVariableExpansionFilters.GetOrNull.class).put((Object)"formatdate", BuiltinVariableExpansionFilters.FormatUnixTimestamp.class).put((Object)"indent", BuiltinVariableExpansionFilters.Indent.class).build();

    public static VariableExpansionChain parse(String expr) {
        if (StringUtils.isEmpty((String)expr)) {
            throw new IllegalArgumentException("Error parsing variable expansion filter, empty expression as variable");
        }
        VariableExpansionChain ret = new VariableExpansionChain();
        if (expr.startsWith("?")) {
            expr = expr.substring(1);
            ret.headOptional = true;
        }
        String[] chunks = StringUtils.split((String)expr, (String)"|");
        ret.headVariable = chunks[0];
        if (chunks.length > 1) {
            for (int i = 1; i < chunks.length; ++i) {
                VariableExpansionFilter filterProcessor;
                String filterExpr = chunks[i];
                int paramsStart = filterExpr.indexOf(58);
                String[] filterChunks = paramsStart > 0 ? new String[]{filterExpr.substring(0, paramsStart), filterExpr.substring(paramsStart + 1)} : new String[]{filterExpr, ""};
                String filterName = filterChunks[0].trim().toLowerCase(Locale.ENGLISH);
                if (!FILTERS_REGISTRY.containsKey(filterName)) {
                    throw new IllegalArgumentException("Unknown variable expansion filter: " + filterName);
                }
                try {
                    filterProcessor = FILTERS_REGISTRY.get(filterName).newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unknown error opening variable expansion filter: " + filterName, e);
                }
                if (filterChunks.length > 1) {
                    filterProcessor.setParams(filterChunks[1]);
                }
                ret.filters.add(filterProcessor);
            }
        }
        return ret;
    }

    public static class VariableExpansionChain {
        public String headVariable;
        public boolean headOptional;
        public List<VariableExpansionFilter> filters = new ArrayList<VariableExpansionFilter>();

        public String apply(JsonElement input) {
            JsonElement cur = input;
            for (VariableExpansionFilter filter : this.filters) {
                cur = filter.process(cur);
            }
            return BuiltinVariableExpansionFilters.jsonToString(cur);
        }
    }
}

