/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.backend;

import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WebAppBackendInstanceStartWaitThread
extends SimpleFutureThread<WebAppBackendInstance.BackendState> {
    public static final long WEBAPP_WAIT_STARTED_DEFAULT_TIMEOUT = 60000L;
    private final WebAppBackendInstance webAppBackendInstance;
    private final WebAppBackend webAppBackend;
    private final WebApp webApp;
    private final FuturePayload futurePayload;
    private final boolean keepFutureIdInState;
    private static Logger logger = Logger.getLogger((String)"dip.webapp.backend.start");

    public WebAppBackendInstanceStartWaitThread(AuthCtx owner, WebApp webApp, WebAppBackend webAppBackend, WebAppBackendInstance webAppBackendInstance, boolean keepFutureIdInState) {
        super(owner);
        this.webApp = webApp;
        this.webAppBackend = webAppBackend;
        this.webAppBackendInstance = webAppBackendInstance;
        this.futurePayload = WebAppBackendInstanceStartWaitThread.getStartWaitThreadPayload(webApp);
        this.keepFutureIdInState = keepFutureIdInState;
    }

    public String getPayloadForStartDoneMessage() {
        return "webapp:" + this.webApp.getFullId();
    }

    @Override
    protected WebAppBackendInstance.BackendState compute() throws Exception {
        long start = System.currentTimeMillis();
        WebApp webAppToLog = (WebApp)JSON.deepCopy((Object)this.webApp);
        webAppToLog.redactKeySecret();
        logger.info((Object)("start webApp=" + JSON.prettyLog((Object)webAppToLog)));
        WebAppHandler wah = WebAppHandler.buildHandler(this.webApp);
        long timeout = Math.max(60000L, this.webAppBackendInstance.getReadinessProbeTimeoutMilliseconds());
        FutureProgress.AutocloseableFutureProgressState state = null;
        while (System.currentTimeMillis() - start < timeout) {
            this.webAppBackendInstance.checkStartFailure();
            try {
                WebAppBackendInstance.BackendState backendState = this.webAppBackend.getBackendState(this.webAppBackendInstance, this.keepFutureIdInState);
                if (wah.backendReady(backendState, 0)) {
                    return backendState;
                }
            }
            catch (IOException e) {
                WebAppBackend.logger.info((Object)"Failed to contact webapp backend, wait...");
            }
            String label = this.webAppBackendInstance.makeStateLabel();
            if (StringUtils.isNotBlank((String)label)) {
                if (state == null) {
                    state = FutureProgress.pushAutoCloseableState((String)label);
                } else if (!label.equals(state.name)) {
                    state.close();
                    state = FutureProgress.pushAutoCloseableState((String)label);
                }
            } else if (state != null) {
                state.close();
                state = null;
            }
            Thread.sleep(300L);
        }
        throw new IOException("Webapp backend start timeout");
    }

    public FuturePayload getPayload() {
        return this.futurePayload;
    }

    private static FuturePayload getStartWaitThreadPayload(WebApp webApp) {
        FuturePayload fp = new FuturePayload();
        fp.displayName = "Starting web app backend " + webApp.type;
        fp.extras = new HashMap();
        fp.targets.add(new FuturePayload.FuturePayloadTarget(webApp.projectKey, webApp.id, webApp.name, ITaggingService.TaggableType.WEB_APP.name()));
        return fp;
    }
}

