/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.plugins;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendRunner;
import com.dataiku.dip.webapps.plugins.LoadedCustomWebApp;
import com.dataiku.dip.webapps.plugins.WebAppDesc;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CustomWebAppMeta
implements WebAppMeta,
IPluginifiedMeta {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.webapps.plugins.CustomWebAppMeta");
    public final LoadedCustomWebApp loaded;
    public static final Set<String> supportedBaseTypes = Set.of("STANDARD", "SHINY", "BOKEH", "DASH", "STREAMLIT");

    public CustomWebAppMeta(LoadedCustomWebApp loaded) {
        this.loaded = loaded;
    }

    @Override
    public String getType() {
        return this.loaded.getType();
    }

    public CodeEnvModel.EnvLang getEnvLang() {
        WebAppMeta meta = WebAppRegistry.getMeta(this.getBaseType());
        if (meta instanceof MetaWithSelectableCodeEnv) {
            MetaWithSelectableCodeEnv metaWithSelectableCodeEnv = (MetaWithSelectableCodeEnv)((Object)meta);
            return metaWithSelectableCodeEnv.getEnvLang();
        }
        logger.warn((Object)("No env lang found for " + this.getBaseType()));
        return null;
    }

    @Override
    public boolean isCustomWebApp() {
        return true;
    }

    @Override
    public Class<? extends WebApp.WebAppParams> getParamsClass() {
        return WebAppRegistry.getMeta(this.getBaseType()).getParamsClass();
    }

    @Override
    public WebAppBackendRunner buildRunner(WebApp webapp, WebAppBackend webappBackend, JsonObject userVariables, AuthCtx user, WebAppBackendInstance webAppBackendInstance) {
        if (supportedBaseTypes.contains(this.getBaseType())) {
            WebAppMeta meta = WebAppRegistry.getMeta(this.getBaseType());
            return meta.buildRunner(webapp, webappBackend, userVariables, user, webAppBackendInstance);
        }
        throw new Error(this.getBaseType() + " custom web app not implemented");
    }

    @Override
    public WebAppHandler buildHandler(WebApp webapp) {
        if (supportedBaseTypes.contains(this.getBaseType())) {
            IPluginsRegistryService pluginsService = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
            File pluginFolder = pluginsService.getActualPluginFolder(this.loaded.ownerPluginId);
            File webappFolder = new File(pluginFolder, this.loaded.folderName);
            WebAppMeta meta = WebAppRegistry.getMeta(this.getBaseType());
            return meta.buildCustomHandler(webapp, webappFolder);
        }
        throw new Error(this.getBaseType() + " custom web app not implemented");
    }

    @Override
    public WebAppHandler buildCustomHandler(WebApp webapp, File webappFolder) {
        throw new Error("Cannot build custom handler for custom app");
    }

    @Override
    public WebAppDesc getWebAppDesc() {
        return this.loaded.desc;
    }

    @Override
    public List<Object> getHashElements(WebApp webApp) {
        if (supportedBaseTypes.contains(this.getBaseType())) {
            ArrayList elements = Lists.newArrayList((Object[])new Object[]{webApp.config});
            elements.addAll(webApp.params.getHashElements());
            return elements;
        }
        throw new Error(this.getBaseType() + " custom web app not implemented");
    }

    public String getBaseType() {
        return this.loaded.desc.baseType;
    }

    public String getOwnerPluginId() {
        return this.loaded.ownerPluginId;
    }

    @Override
    public IElementLoadedDesc getLoadedDesc() {
        return this.loaded;
    }
}

