/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Match
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2) {
            Object s = args[0];
            Object p = args[1];
            if (s != null && (p instanceof String || p instanceof Pattern)) {
                Pattern pattern = p instanceof String ? Pattern.compile((String)p) : (Pattern)p;
                Matcher matcher = pattern.matcher(s.toString());
                if (matcher.matches()) {
                    int count = matcher.groupCount();
                    if (count == 0) {
                        return new String[]{s.toString()};
                    }
                    String[] groups = new String[count];
                    for (int i = 0; i < count; ++i) {
                        groups[i] = matcher.group(i + 1);
                    }
                    return groups;
                }
                return null;
            }
            return null;
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects a string or a regexp");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Match.DOCUMENTATION", "Returns an array of the matching groups found in <code>s</code>. Groups are designated by () within the specified string or regular expression.").withParams("string s, string or regexp").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"hello world\"", "\"he(.*)wo(rl)d\"").returns("[\"llo \",\"rl\"]"));
    }
}

