/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;
import java.util.regex.Pattern;

public class Replace
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 3) {
            Object o1 = args[0];
            Object o2 = args[1];
            Object o3 = args[2];
            if (o1 != null && o2 != null && o3 instanceof String) {
                String str;
                String string = str = o1 instanceof String ? (String)o1 : o1.toString();
                if (o2 instanceof String) {
                    return str.replace((String)o2, (String)o3);
                }
                if (o2 instanceof Pattern) {
                    Pattern pattern = (Pattern)o2;
                    return pattern.matcher(str).replaceAll((String)o3);
                }
            }
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects 3 strings, or 1 string, 1 regex, and 1 string");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Replace.DOCUMENTATION", "Replaces all occurrences of substring/regex <code>f</code> found in string <code>s</code> with the <code>replacement</code> string.").withParams("string s, string or regex f, string replacement").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"hello world\"", "\"hel\"", "\"a\"").returns("\"alo world\"")).withExample(Example.with("\"Oh my!\"", "/\\w/", "\"x\"").returns("\"xx xx!\""));
    }
}

