/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LazyHashMap<K, V>
implements Map<K, V> {
    Map<K, V> backend = new HashMap();
    Constructor<V> ctor;

    public LazyHashMap(Class<V> clazz) {
        try {
            this.ctor = clazz.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new Error("Can't create lazy hash map", e);
        }
    }

    public V getOrCreate(K key) {
        V ret = this.backend.get(key);
        if (ret == null) {
            try {
                ret = this.ctor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new Error("Can't create lazy hash map item", e);
            }
            this.backend.put(key, ret);
        }
        return ret;
    }

    @Override
    public void clear() {
        this.backend.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backend.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backend.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backend.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.backend.equals(o);
    }

    @Override
    public V get(Object key) {
        return this.backend.get(key);
    }

    @Override
    public int hashCode() {
        return this.backend.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.backend.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.backend.keySet();
    }

    @Override
    public V put(K key, V value) {
        return this.backend.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.backend.putAll(m);
    }

    @Override
    public V remove(Object key) {
        return this.backend.remove(key);
    }

    @Override
    public int size() {
        return this.backend.size();
    }

    @Override
    public Collection<V> values() {
        return this.backend.values();
    }
}

