/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.warnings;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.ICodedException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;

public class WarningsContext {
    public static final int MAX_WARNINGS_OF_TYPE = 20;
    private final Map<WarningType, WarningTypeData> perType = new HashMap<WarningType, WarningTypeData>();
    private static final DKULogger logger = DKULogger.getLogger("dku.warnings");

    public synchronized int getTotalCount() {
        int total = 0;
        for (Map.Entry<WarningType, WarningTypeData> e : this.perType.entrySet()) {
            total += e.getValue().count;
        }
        return total;
    }

    public synchronized void merge(SerializedWarnings other) {
        for (WarningTypeData theirs : other.warnings.values()) {
            WarningTypeData ours = this.perType.get((Object)theirs.type);
            if (ours == null) {
                ours = new WarningTypeData(theirs.type);
                this.perType.put(ours.type, ours);
            }
            ours.count += theirs.count;
            ours.stored.addAll(theirs.stored);
        }
    }

    public synchronized SerializedWarnings getOutput() {
        SerializedWarnings sw = new SerializedWarnings();
        sw.warnings = this.perType;
        sw.totalCount = this.getTotalCount();
        return sw;
    }

    public synchronized void addWarning(WarningType type, String message, Throwable t, DKULogger logger) {
        WarningTypeData wtd = this.perType.get((Object)type);
        if (wtd == null) {
            wtd = new WarningTypeData(type);
            this.perType.put(type, wtd);
        }
        ++wtd.count;
        if (wtd.count < 20) {
            StoredWarning sw = new StoredWarning();
            sw.timestamp = System.currentTimeMillis();
            sw.message = message;
            if (t != null) {
                sw.t = new SerializedThrowable(t);
            }
            wtd.stored.add(sw);
            if (logger == null) {
                logger = WarningsContext.logger;
            }
            if (t != null) {
                logger.warn(String.valueOf((Object)type) + ": " + message, t);
            } else {
                logger.warn(String.valueOf((Object)type) + ": " + message);
            }
        }
    }

    public synchronized void addWarning(WarningType type, String message, DKULogger logger) {
        this.addWarning(type, message, null, logger);
    }

    public synchronized boolean hasWarningType(WarningType type) {
        return this.perType.containsKey((Object)type);
    }

    public void flushLogging() {
        for (Map.Entry<WarningType, WarningTypeData> e : this.perType.entrySet()) {
            if (e.getValue().count <= 20) continue;
            logger.warn("Warning " + String.valueOf((Object)e.getKey()) + " repeated " + e.getValue().count + " times");
        }
    }

    public static class WarningTypeData {
        WarningType type;
        int count;
        public List<StoredWarning> stored = new ArrayList<StoredWarning>();

        WarningTypeData(WarningType wt) {
            this.type = wt;
        }

        WarningTypeData(WarningType wt, int count) {
            this.type = wt;
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }
    }

    @UIModel
    public static class SerializedWarnings {
        public Map<WarningType, WarningTypeData> warnings = new HashMap<WarningType, WarningTypeData>();
        public int totalCount;

        public static SerializedWarnings copyCounts(SerializedWarnings o) {
            SerializedWarnings ret = new SerializedWarnings();
            ret.totalCount = o.totalCount;
            for (Map.Entry<WarningType, WarningTypeData> e : o.warnings.entrySet()) {
                ret.warnings.put(e.getKey(), new WarningTypeData(e.getValue().type, e.getValue().count));
            }
            return ret;
        }

        public void mergeCountsFrom(SerializedWarnings other) {
            this.totalCount += other.totalCount;
            for (Map.Entry<WarningType, WarningTypeData> e : other.warnings.entrySet()) {
                WarningTypeData wtd = this.warnings.get((Object)e.getKey());
                if (wtd == null) {
                    wtd = new WarningTypeData(e.getKey());
                    this.warnings.put(e.getKey(), wtd);
                }
                wtd.count += e.getValue().count;
            }
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public Map<WarningType, WarningTypeData> getWarnings() {
            return this.warnings;
        }
    }

    public static enum WarningType {
        INPUT_DATA_BAD_DATA,
        INPUT_DATA_BAD_DATE,
        INPUT_DATA_BAD_INT,
        INPUT_DATA_INT_OOR,
        INPUT_DATA_BAD_FLOAT,
        INPUT_DATA_BAD_DOUBLE,
        INPUT_DATA_BAD_BOOLEAN,
        INPUT_DATA_BAD_GEO,
        INPUT_DATA_BAD_NBCOLS,
        INPUT_DATA_EXTRA_COLUMNS,
        INPUT_DATA_MISSING_COLUMNS,
        INPUT_ELASTICSEARCH_INDEX_NOT_FOUND,
        INPUT_ELASTICSEARCH_COUNT_MISMATCH,
        INPUT_ELASTICSEARCH_BAD_QUERY,
        INPUT_ELASTICSEARCH_RESULT_WINDOW_TOO_LARGE,
        INPUT_DATA_VERY_LONG,
        MEMSIZE_TRUNCATED_SAMPLE,
        INPUT_DATA_LINE_DOES_NOT_PARSE,
        OUTPUT_DATA_BAD_DATE,
        OUTPUT_DATA_BAD_INT,
        OUTPUT_DATA_BAD_DOUBLE,
        OUTPUT_DATA_INT_OOR,
        OUTPUT_DATA_BAD_FLOAT,
        OUTPUT_DATA_BAD_BOOLEAN,
        HIVE_METASTORE_SYNCHRONIZE,
        MISSING_SOURCE_PARTITION,
        IMPALA_METADATA_SYNCHRONIZE,
        SHAKER_BAD_DATE,
        SHAKER_COLUMN_IGNORED,
        PARTITION_MODE_UNSUPPORTED,
        DATA_DRIFT_COMPUTATION_ERROR,
        LLM_EVALUATION_COMPUTATION_ERROR,
        OUTPUT_DATA_SQL_BAD_DATA,
        OUTPUT_DATA_BAD_TYPE,
        CSV_OUTPUT_BAD_COMPLEX_VALUE,
        CSV_OUTPUT_BAD_DATE,
        OUTPUT_DATA_ELASTICSEARCH_ERROR,
        COMMUNITY_EDITION_TRUNCATED_OUTPUT,
        SAMPLING_BAD_COLUMN,
        SQL_CREATE_QUERY_WARNING,
        SQL_SCRIPT_INFER_SCHEMA_FAILED,
        GOVERNANCE_ISSUE,
        DEPLOYMENT_ISSUE,
        INPUT_DATA_BAD_TYPE,
        ENGINE_DEPRECATED,
        ENGINE_UNSUPPORTED,
        DEPRECATED_SPARK,
        DEPRECATED_PYTHON_INTERPRETER,
        ML_DIAGNOSTICS_TRAINING_OVERFIT,
        ML_DIAGNOSTICS_MODELING_PARAMETERS,
        ML_DIAGNOSTICS_LEAKAGE_DETECTION,
        ML_DIAGNOSTICS_DATASET_SANITY_CHECKS,
        ML_DIAGNOSTICS_MODEL_CHECK,
        ML_DIAGNOSTICS_RUNTIME,
        ML_DIAGNOSTICS_REPRODUCIBILITY,
        ML_DIAGNOSTICS_ML_ASSERTIONS,
        ML_DIAGNOSTICS_ABNORMAL_PREDICTIONS_DETECTION,
        ML_DIAGNOSTICS_SCORING_DATASET_SANITY_CHECKS,
        ML_DIAGNOSTICS_EVALUATION_DATASET_SANITY_CHECKS,
        ML_DIAGNOSTICS_TIMESERIES_RESAMPLING_CHECKS,
        ML_DIAGNOSTICS_CAUSAL_TREATMENT_CHECKS,
        ML_DIAGNOSTICS_CAUSAL_PROPENSITY_CHECKS,
        STATISTICS_ENGINE_ISSUE,
        CONTAINERIZED_SHAKER_INCOMPATIBILITY,
        CONTAINERIZED_ENGINE_INCOMPATIBILITY,
        LLM_QUERY_ERROR,
        LLM_TOOL_UNKNOWN_COLUMN,
        DOCUMENT_PROCESSING_FAILED;

    }

    public static class StoredWarning {
        public long timestamp;
        public SerializedThrowable t;
        public String message;
    }

    public static class SerializedThrowable {
        public String clazz;
        public String message;
        public String stack;
        public String code;
        public String title;
        public InfoMessage.FixabilityCategory fixability;

        public SerializedThrowable(Throwable t) {
            this.clazz = t.getClass().getCanonicalName();
            this.message = com.dataiku.dip.utils.ExceptionUtils.getMessageWithCauses(t);
            this.stack = ExceptionUtils.getFullStackTrace((Throwable)t);
            if (t instanceof ICodedException && ((ICodedException)((Object)t)).getCode() != null) {
                InfoMessage.MessageCode errorCode = ((ICodedException)((Object)t)).getCode();
                this.code = errorCode.getCode();
                this.title = errorCode.getCodeTitle();
                this.fixability = errorCode.getFixability();
            }
        }

        public SerializedThrowable(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public String getStack() {
            return this.stack;
        }

        public String getClazz() {
            return this.clazz;
        }
    }

    public static class DummyWarningsContext
    extends WarningsContext {
        WarningsContext real = new WarningsContext();

        @Override
        public int getTotalCount() {
            return this.real.getTotalCount();
        }

        @Override
        public void merge(SerializedWarnings other) {
            this.real.merge(other);
        }

        @Override
        public SerializedWarnings getOutput() {
            return this.real.getOutput();
        }

        @Override
        public void addWarning(WarningType type, String message, Throwable t, DKULogger logger) {
            logger.warn("ADDING WARNING ON DUMMY WC " + String.valueOf(this));
            this.real.addWarning(type, message, t, logger);
        }

        @Override
        public void addWarning(WarningType type, String message, DKULogger logger) {
            this.real.addWarning(type, message, logger);
        }

        @Override
        public void flushLogging() {
            this.real.flushLogging();
        }

        public String toString() {
            return this.real.toString();
        }
    }
}

