/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.mixin;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.ApiClient;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.DatabricksError;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.mixin.NodeTypeSelector;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.mixin.SemVer;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.mixin.SparkVersionSelector;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.CloudProviderNodeStatus;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.ClusterDetails;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.ClustersAPI;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.ClustersService;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.GetSparkVersionsResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.ListNodeTypesResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.NodeInstanceType;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.NodeType;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.SparkVersion;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.compute.State;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClustersExt
extends ClustersAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ClustersExt.class);
    private static final String INVALID_STATE = "INVALID_STATE";
    private final Comparator<NodeType> nodeSortingComparator = (item1, item2) -> Comparator.comparing(NodeType::getIsDeprecated, Comparator.nullsLast(Boolean::compare)).thenComparing(NodeType::getNumCores, Comparator.nullsLast(Double::compare)).thenComparing(NodeType::getMemoryMb, Comparator.nullsLast(Long::compare)).thenComparing(ClustersExt.instanceTypeComparator(NodeInstanceType::getLocalDisks), Comparator.nullsLast(Long::compare)).thenComparing(ClustersExt.instanceTypeComparator(NodeInstanceType::getLocalDiskSizeGb), Comparator.nullsLast(Long::compare)).thenComparing(ClustersExt.instanceTypeComparator(NodeInstanceType::getLocalNvmeDisks), Comparator.nullsLast(Long::compare)).thenComparing(ClustersExt.instanceTypeComparator(NodeInstanceType::getLocalNvmeDiskSizeGb), Comparator.nullsLast(Long::compare)).thenComparing(NodeType::getNumGpus, Comparator.nullsLast(Long::compare)).thenComparing(NodeType::getInstanceTypeId, Comparator.nullsLast(String::compareTo)).compare((NodeType)item1, (NodeType)item2);

    public ClustersExt(ApiClient apiClient) {
        super(apiClient);
    }

    public ClustersExt(ClustersService mock) {
        super(mock);
    }

    public String selectSparkVersion(SparkVersionSelector selector) throws IllegalArgumentException {
        ArrayList<String> versions = new ArrayList<String>();
        GetSparkVersionsResponse sv = this.sparkVersions();
        for (SparkVersion version : sv.getVersions()) {
            boolean matches;
            if (version.getName() == null || selector.scala != null && !version.getKey().contains("-scala" + selector.scala)) continue;
            boolean bl = matches = !version.getKey().contains("apache-spark-") && version.getKey().contains("-ml-") == selector.ml && version.getKey().contains("-hls-") == selector.genomics && version.getKey().contains("-gpu-") == selector.gpu && version.getKey().contains("-photon-") == selector.photon && version.getKey().contains("-aarch64-") == selector.graviton && version.getName().contains("Beta") == selector.beta;
            if (matches && selector.longTermSupport) {
                boolean bl2 = matches = version.getName().contains("LTS") || version.getKey().contains("-esr-");
            }
            if (matches && selector.sparkVersion != null) {
                matches = ("Apache Spark " + selector.sparkVersion).equals(version.getName());
            }
            if (!matches) continue;
            versions.add(version.getKey());
        }
        if (versions.size() < 1) {
            throw new IllegalArgumentException("spark versions query returned no results");
        }
        if (versions.size() > 1) {
            if (!selector.latest) {
                throw new IllegalArgumentException("spark versions query returned multiple results");
            }
            versions.sort((v1, v2) -> SemVer.parse(v2).compareTo(SemVer.parse(v1)));
        }
        return (String)versions.get(0);
    }

    public String selectNodeType(NodeTypeSelector selector) {
        ListNodeTypesResponse res = this.listNodeTypes();
        List types = res.getNodeTypes().stream().sorted(this.nodeSortingComparator).collect(Collectors.toList());
        for (NodeType nt : types) {
            if (ClustersExt.shouldNodeBeSkipped(nt)) continue;
            Long gbs = 0L;
            if (nt.getMemoryMb() != null) {
                gbs = nt.getMemoryMb() / 1024L;
            }
            if (selector.fleet != null && !nt.getNodeTypeId().contains(selector.fleet) || selector.minMemoryGb != null && gbs < (long)selector.minMemoryGb.intValue() || selector.gbPerCore != null && (double)gbs.longValue() / nt.getNumCores() < (double)selector.gbPerCore.intValue() || selector.minCores != null && nt.getNumCores() < (double)selector.minCores.intValue() || selector.minGpus != null && nt.getNumGpus() < (long)selector.minGpus.intValue() || selector.minGpus == null && nt.getNumGpus() != null && nt.getNumGpus() > 0L) continue;
            if (selector.localDisk != null || selector.localDiskMinSize != null) {
                long localNvmeDisks;
                NodeInstanceType instanceType = nt.getNodeInstanceType();
                if (instanceType == null) continue;
                long localDisks = instanceType.getLocalDisks() != null ? instanceType.getLocalDisks() : 0L;
                long l = localNvmeDisks = instanceType.getLocalNvmeDisks() != null ? instanceType.getLocalNvmeDisks() : 0L;
                if (localDisks < 1L && localNvmeDisks < 1L) continue;
                Long localDiskSizeGb = instanceType.getLocalDiskSizeGb() != null ? instanceType.getLocalDiskSizeGb() : 0L;
                Long localNvmeDiskSizeGb = instanceType.getLocalNvmeDiskSizeGb() != null ? instanceType.getLocalNvmeDiskSizeGb() : 0L;
                long allDisksSize = localDiskSizeGb + localNvmeDiskSizeGb;
                if (selector.localDiskMinSize != null && allDisksSize < (long)selector.localDiskMinSize.intValue()) continue;
            }
            if (selector.category != null && !nt.getCategory().equalsIgnoreCase(selector.category) || selector.isIoCacheEnabled != null && !nt.getIsIoCacheEnabled().equals(selector.isIoCacheEnabled) || selector.supportPortForwarding != null && !nt.getSupportPortForwarding().equals(selector.supportPortForwarding) || selector.photonDriverCapable != null && !nt.getPhotonDriverCapable().equals(selector.photonDriverCapable) || selector.photonWorkerCapable != null && !nt.getPhotonWorkerCapable().equals(selector.photonWorkerCapable) || selector.graviton != null && !nt.getIsGraviton().equals(selector.graviton)) continue;
            return nt.getNodeTypeId();
        }
        throw new IllegalArgumentException("Cannot determine smallest node type");
    }

    private static Function<NodeType, Long> instanceTypeComparator(Function<NodeInstanceType, Long> yy) {
        return nodeType -> {
            NodeInstanceType nodeInstanceType = nodeType.getNodeInstanceType();
            if (nodeInstanceType == null) {
                return 0L;
            }
            Long value = (Long)yy.apply(nodeInstanceType);
            if (value == null) {
                return 0L;
            }
            return value;
        };
    }

    private static boolean shouldNodeBeSkipped(NodeType nt) {
        if (nt.getNodeInfo() == null) {
            return false;
        }
        if (nt.getNodeInfo().getStatus() == null) {
            return false;
        }
        for (CloudProviderNodeStatus st : nt.getNodeInfo().getStatus()) {
            if (st != CloudProviderNodeStatus.NOT_AVAILABLE_IN_REGION && st != CloudProviderNodeStatus.NOT_ENABLED_ON_SUBSCRIPTION) continue;
            return true;
        }
        return false;
    }

    public void ensureClusterIsRunning(String clusterId) throws TimeoutException {
        Duration outerTimeout = Duration.ofMinutes(20L);
        long deadline = System.currentTimeMillis() + outerTimeout.toMillis();
        while (System.currentTimeMillis() < deadline) {
            try {
                ClusterDetails info = this.get(clusterId);
                if (info.getState() == State.TERMINATED) {
                    this.start(clusterId).get();
                } else if (info.getState() == State.TERMINATING) {
                    this.waitGetClusterTerminated(clusterId);
                    this.start(clusterId).get();
                } else if (Arrays.asList(State.PENDING, State.RESIZING, State.RESTARTING).contains((Object)info.getState())) {
                    this.waitGetClusterRunning(clusterId);
                } else if (Arrays.asList(State.ERROR, State.UNKNOWN).contains((Object)info.getState())) {
                    throw new DatabricksError(info.getState().name(), info.getStateMessage());
                }
                LOG.debug("Cluster is {}: {}", (Object)info.getState(), (Object)info.getStateMessage());
                return;
            }
            catch (DatabricksError e) {
                if (e.getErrorCode().equals(INVALID_STATE)) {
                    LOG.debug("Cluster was started by other process: {} Retrying.", (Object)e.getMessage());
                    continue;
                }
                LOG.debug("Received {} error code", (Object)e.getErrorCode());
                throw e;
            }
        }
        throw new TimeoutException("Cannot ensure cluster to start");
    }
}

