/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.ApiClient;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.CreateMetastore;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.CreateMetastoreAssignment;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.DeleteMetastoreRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.GetMetastoreRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.GetMetastoreSummaryResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.ListMetastoresResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.MetastoreAssignment;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.MetastoreInfo;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.MetastoresImpl;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.MetastoresService;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.UnassignRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.UpdateMetastore;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.UpdateMetastoreAssignment;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Generated;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class MetastoresAPI {
    private static final Logger LOG = LoggerFactory.getLogger(MetastoresAPI.class);
    private final MetastoresService impl;

    public MetastoresAPI(ApiClient apiClient) {
        this.impl = new MetastoresImpl(apiClient);
    }

    public MetastoresAPI(MetastoresService mock) {
        this.impl = mock;
    }

    public void assign(long workspaceId, String metastoreId, String defaultCatalogName) {
        this.assign(new CreateMetastoreAssignment().setWorkspaceId(workspaceId).setMetastoreId(metastoreId).setDefaultCatalogName(defaultCatalogName));
    }

    public void assign(CreateMetastoreAssignment request) {
        this.impl.assign(request);
    }

    public MetastoreInfo create(String name) {
        return this.create(new CreateMetastore().setName(name));
    }

    public MetastoreInfo create(CreateMetastore request) {
        return this.impl.create(request);
    }

    public MetastoreAssignment current() {
        return this.impl.current();
    }

    public void delete(String id) {
        this.delete(new DeleteMetastoreRequest().setId(id));
    }

    public void delete(DeleteMetastoreRequest request) {
        this.impl.delete(request);
    }

    public MetastoreInfo get(String id) {
        return this.get(new GetMetastoreRequest().setId(id));
    }

    public MetastoreInfo get(GetMetastoreRequest request) {
        return this.impl.get(request);
    }

    public Iterable<MetastoreInfo> list() {
        return new Paginator(null, v -> this.impl.list(), ListMetastoresResponse::getMetastores, response -> null);
    }

    public GetMetastoreSummaryResponse summary() {
        return this.impl.summary();
    }

    public void unassign(long workspaceId, String metastoreId) {
        this.unassign(new UnassignRequest().setWorkspaceId(workspaceId).setMetastoreId(metastoreId));
    }

    public void unassign(UnassignRequest request) {
        this.impl.unassign(request);
    }

    public MetastoreInfo update(String id) {
        return this.update(new UpdateMetastore().setId(id));
    }

    public MetastoreInfo update(UpdateMetastore request) {
        return this.impl.update(request);
    }

    public void updateAssignment(long workspaceId) {
        this.updateAssignment(new UpdateMetastoreAssignment().setWorkspaceId(workspaceId));
    }

    public void updateAssignment(UpdateMetastoreAssignment request) {
        this.impl.updateAssignment(request);
    }

    public MetastoresService impl() {
        return this.impl;
    }
}

