/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.BuiltinsLoader;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.ml.DKUMLUtils;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.logging.LimitedLogFactory;
import com.dataiku.dip.logging.SparkLoggingConfigurator;
import com.dataiku.dip.remoterun.RemoteRunLocalFilesHelper;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkJobExecEnv;
import com.dataiku.dip.spark.submit.DKUSparkKubernetesEntrypoint;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.net.URL;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.Loader;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.api.Names;
import scala.reflect.api.Symbols;
import scala.util.matching.Regex;

public final class package$ {
    public static package$ MODULE$;
    private boolean registerTempTableNeedsEscape;
    private final Regex OBJECT_FQN;
    private boolean dkuLoggingInitialized;
    private final DKULogger logger;
    private volatile boolean bitmap$0;

    static {
        new package$();
    }

    public Regex OBJECT_FQN() {
        return this.OBJECT_FQN;
    }

    public <A extends AutoCloseable, T> T tryWith(A resource, Function1<A, T> block) {
        Object object;
        try {
            object = block.apply(resource);
        }
        finally {
            if (resource != null) {
                resource.close();
            }
        }
        return (T)object;
    }

    public boolean dkuLoggingInitialized() {
        return this.dkuLoggingInitialized;
    }

    public void dkuLoggingInitialized_$eq(boolean x$1) {
        this.dkuLoggingInitialized = x$1;
    }

    public void initializeLogging() {
        System.err.println("Initialize DKU app logging");
        if (this.dkuLoggingInitialized()) {
            System.err.println(" --> Already initialized");
            return;
        }
        if (Loader.getResource((String)"log4j.properties") == null) {
            System.err.println("Logging resource not found ...");
            BasicConfigurator.configure();
        } else {
            PropertyConfigurator.configure((URL)Loader.getResource((String)"log4j.properties"));
        }
        if (System.getenv("DKU_SILENT") != null) {
            Logger.getRootLogger().setLevel(Level.WARN);
        }
        if (System.getenv("DKU_NOTDEBUG") != null) {
            Logger.getRootLogger().setLevel(Level.INFO);
        }
        if (System.getenv("DKU_DEBUG") != null) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
        }
        SparkLoggingConfigurator.configureFromRunDir();
        this.dkuLoggingInitialized_$eq(true);
    }

    public void initializeApplication(boolean canReadConf, boolean multithread) {
        this.logger().info((Object)"Spark: initializeApplication");
        package$ package$2 = this;
        synchronized (package$2) {
            if (SpringUtils.getInstance() == null) {
                DKUSparkKubernetesEntrypoint.doFetch();
                this.logger().info((Object)"Spark: initializeApplication: need to do it");
                this.initializeLogging();
                boolean isYarnCluster = com.dataiku.dip.remoterun.package$.MODULE$.isYarnCluster();
                boolean isDatabricks = com.dataiku.dip.remoterun.package$.MODULE$.isDatabricks();
                this.logger().info((Object)new StringBuilder(18).append("Running in folder ").append(new File(".").getAbsolutePath()).toString());
                this.logger().info((Object)new StringBuilder(25).append("Driver working directory ").append(com.dataiku.dip.remoterun.package$.MODULE$.getLocalRunFile(".").getAbsolutePath()).toString());
                this.logger().info((Object)new StringBuilder(25).append("yarn-cluster=").append(isYarnCluster).append(" databricks=").append(isDatabricks).toString());
                ApplicationConfigurator.setInSparkDriver((boolean)true);
                BuiltinsLoader.load();
                DKUMLUtils.loadClasses();
                if (isYarnCluster || isDatabricks) {
                    this.logger().info((Object)"Use local dip home");
                    File localDipHome = com.dataiku.dip.remoterun.package$.MODULE$.getLocalRunFile("./local-dip-home/");
                    localDipHome.mkdirs();
                    File localInstallDir = com.dataiku.dip.remoterun.package$.MODULE$.getLocalRunFile("./local-install-dir/");
                    localInstallDir.mkdirs();
                    this.logger().info((Object)new StringBuilder(15).append("Using DIP_HOME=").append(localDipHome.getAbsolutePath()).toString());
                    this.logger().info((Object)new StringBuilder(20).append("Using DKUINSTALLDIR=").append(localInstallDir.getAbsolutePath()).toString());
                    com.dataiku.dip.remoterun.package$.MODULE$.getEnvVarsAsJava().put("DIP_HOME", localDipHome.getAbsolutePath());
                    com.dataiku.dip.remoterun.package$.MODULE$.getEnvVarsAsJava().put("DKUINSTALLDIR", localInstallDir.getAbsolutePath());
                    DKUApp.configureNoConfig((String)localDipHome.getAbsolutePath(), (String)localInstallDir.getAbsolutePath());
                    RemoteRunLocalFilesHelper.unzipPlugins();
                    RemoteRunLocalFilesHelper.writeInfoFiles();
                } else if (canReadConf) {
                    this.logger().info((Object)"Use real dip home and conf");
                    ApplicationConfigurator.autoconfigureEnv();
                } else {
                    this.logger().info((Object)"Use real dip home but no conf");
                    ApplicationConfigurator.configureFromEnvNoConfig();
                }
                CLISetup.sparkDriverSetup((boolean)canReadConf, (boolean)multithread);
                SparkConf sparkConf = new SparkConf();
                if (sparkConf.contains("spark.dku.limitedLogs")) {
                    LimitedLogFactory.configure((String)sparkConf.get("spark.dku.limitedLogs"));
                }
            } else {
                this.logger().info((Object)"Spark: initializeApplication: ALREADY done");
            }
        }
        SparkJobExecEnv execEnv = com.dataiku.dip.remoterun.package$.MODULE$.getJobExecEnv();
        if (execEnv != null) {
            this.logger().infoV("Loading exec env", new Object[0]);
            execEnv.loadInDriver();
            return;
        }
        this.logger().warnV("Not loading exec env", new Object[0]);
    }

    public boolean initializeApplication$default$1() {
        return false;
    }

    public boolean initializeApplication$default$2() {
        return false;
    }

    public void registerTempTableProperly(Dataset<Row> df, String name) {
        this.logger().debug((Object)new StringBuilder(34).append("Registering dataframe temp table: ").append(name).toString());
        if (this.registerTempTableNeedsEscape()) {
            df.registerTempTable(new StringBuilder(2).append("`").append(name).append("`").toString());
            return;
        }
        df.registerTempTable(name);
    }

    private boolean registerTempTableNeedsEscape$lzycompute() {
        package$ package$2 = this;
        synchronized (package$2) {
            if (!this.bitmap$0) {
                this.registerTempTableNeedsEscape = this.liftedTree1$1();
                this.bitmap$0 = true;
            }
        }
        return this.registerTempTableNeedsEscape;
    }

    public boolean registerTempTableNeedsEscape() {
        if (!this.bitmap$0) {
            return this.registerTempTableNeedsEscape$lzycompute();
        }
        return this.registerTempTableNeedsEscape;
    }

    public DKULogger logger() {
        return this.logger;
    }

    private final /* synthetic */ boolean liftedTree1$1() {
        boolean bl;
        block3: {
            try {
                Class<?> datasetClass = Class.forName("org.apache.spark.sql.Dataset");
                Symbols.ClassSymbolApi datasetSymbol = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(datasetClass.getClassLoader()).classSymbol(datasetClass);
                Symbols.SymbolApi symbol = datasetSymbol.toType().member((Names.NameApi)((Names)scala.reflect.runtime.package$.MODULE$.universe()).stringToTermName("registerTempTable"));
                if (symbol == null || !symbol.isMethod()) {
                    this.logger().info((Object)"Old-style DF temp table registration (< 2.0 version)");
                    bl = false;
                    break block3;
                }
                this.logger().info((Object)"New-style DF temp table registration (>=2.0 version)");
                bl = true;
            }
            catch (Throwable t) {
                this.logger().info((Object)"Old-style DF temp table registration (<<2.0 version)");
                bl = false;
            }
        }
        return bl;
    }

    private package$() {
        MODULE$ = this;
        this.OBJECT_FQN = new StringOps(Predef$.MODULE$.augmentString("^(\\w+)\\.(.+)$")).r();
        this.dkuLoggingInitialized = false;
        this.logger = DKULogger.getLogger((String)"dku.spark.entrypoint");
    }
}

