/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.admin;

import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.lambda.auth.AdminAuthCRUDService;
import com.dataiku.lambda.auth.ApiNodeAuthVerificationService;
import com.dataiku.lambda.model.serverconfig.AdminAPIKey;
import com.dataiku.lambda.server.LambdaAPIControllerBase;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class AuthAdminController
extends LambdaAPIControllerBase {
    @Autowired
    private ApiNodeAuthVerificationService authService;
    @Autowired
    private AdminAuthCRUDService crudService;
    @Autowired
    private AuditTrailService auditTrailService;

    @RequestMapping(value={"/admin/api/keys"}, method={RequestMethod.GET})
    public void listKeys(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.authService.checkAdmin(req);
        List<AdminAPIKey> keys = this.crudService.listKeys();
        keys.forEach(AdminAPIKey::clearManagedKeyField);
        AuthAdminController.writeJSON(resp, keys);
        this.auditTrailService.generic("admin-keys-list").emit();
    }

    @RequestMapping(value={"/admin/api/keys"}, method={RequestMethod.POST})
    public void create(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.authService.checkAdmin(req);
        AdminAPIKey primoKey = (AdminAPIKey)this.getRequestBodyAs(req, AdminAPIKey.class);
        AdminAPIKey createdKey = this.crudService.createAdminKey(primoKey);
        createdKey.clearManagedKeyField();
        AuthAdminController.writeJSON(resp, createdKey);
        this.auditTrailService.generic("admin-key-create").with("newKeyId", createdKey.id).emit();
    }

    @RequestMapping(value={"/admin/api/keys/{key:.+}"}, method={RequestMethod.DELETE})
    public void deleteRealmKey(HttpServletRequest req, HttpServletResponse resp, @PathVariable String key) throws Exception {
        this.authService.checkAdmin(req);
        this.crudService.deleteAdminKeyByKey(key);
        this.writeSimpleOK(resp);
        this.auditTrailService.generic("admin-key-delete").emit();
    }

    @RequestMapping(value={"/admin/api/keys/{id:.+}/key"}, method={RequestMethod.DELETE})
    public void deleteRealmKeyById(HttpServletRequest req, HttpServletResponse resp, @PathVariable String id) throws Exception {
        this.authService.checkAdmin(req);
        this.crudService.deleteAdminKeyById(id);
        this.writeSimpleOK(resp);
        this.auditTrailService.generic("admin-key-delete").emit();
    }
}

