/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.admin;

import com.codahale.metrics.json.MetricsModule;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.lambda.auth.ApiNodeAuthVerificationService;
import com.dataiku.lambda.monitoring.ActivityMonitoringService;
import com.dataiku.lambda.monitoring.MonitoringService;
import com.dataiku.lambda.server.LambdaAPIControllerBase;
import com.dataiku.lambda.services.AliveService;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.common.TextFormat;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MonitoringController
extends LambdaAPIControllerBase {
    @Autowired
    private ApiNodeAuthVerificationService authService;
    @Autowired
    private AliveService aliveService;
    @Autowired
    private MonitoringService monitoringService;
    @Autowired
    private ActivityMonitoringService activityMonitoringService;

    @AuditedCall(value={"msgType", "apinode-get-metrics"})
    @RequestMapping(value={"/admin/api/metrics"})
    public void dumpMetrics(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.authService.checkAdmin(req);
        ObjectMapper om = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false));
        om.writerWithDefaultPrettyPrinter().writeValue((OutputStream)resp.getOutputStream(), (Object)DSSMetrics.registry());
    }

    @AuditedCall(value={"msgType", "apinode-get-activity-metrics"})
    @RequestMapping(value={"/admin/api/activity-metrics"})
    @ResponseBody
    public String getActivityMetrics(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.authService.checkAdmin(req);
        return this.activityMonitoringService.getActivityMetricsInGraphiteRawFormat();
    }

    @AuditedCall(value={"msgType", "apinode-get-system-metrics"})
    @RequestMapping(value={"/admin/api/system-metrics"})
    @ResponseBody
    public String getSystemMetrics(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.authService.checkAdmin(req);
        return this.activityMonitoringService.getSystemMetricsInGraphiteRawFormat();
    }

    @AuditedCall(value={"msgType", "apinode-get-metrics"})
    @RequestMapping(value={"/admin/api/metrics-prometheus"})
    public void dumpMetricsPrometheus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.authService.checkAdmin(req);
        CollectorRegistry collector = new CollectorRegistry();
        collector.register((Collector)new DropwizardExports(DSSMetrics.registry()));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)resp.getOutputStream());
        TextFormat.write004((Writer)writer, (Enumeration)collector.metricFamilySamples());
        writer.flush();
    }

    @RequestMapping(value={"/admin/api/services/{serviceId}/stats"})
    public void getServiceStats(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId) throws Exception {
        this.authService.checkAdmin(req);
        MonitoringController.writeJSON(resp, this.monitoringService.getAPIServiceStats(serviceId));
    }

    @RequestMapping(value={"/admin/api/set-not-alive"})
    public void setNotAlive(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.authService.checkAdmin(req);
        this.aliveService.setNotAlive();
    }

    @RequestMapping(value={"/admin/api/set-alive"})
    public void setAlive(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.authService.checkAdmin(req);
        this.aliveService.setAlive();
    }
}

