/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.services;

import com.codahale.metrics.Counter;
import com.dataiku.common.server.APIError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.code.APINodeCodeEnvImporter;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.APINodeMetrics;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.ServiceGenContext;
import com.dataiku.lambda.dataload.DataLoadManager;
import com.dataiku.lambda.dispatch.GenerationSelector;
import com.dataiku.lambda.dispatch.GenerationSelectorFactory;
import com.dataiku.lambda.endpoints.IEndpointFactory;
import com.dataiku.lambda.endpoints.LambdaEndpointHandler;
import com.dataiku.lambda.health.HealthChecksBuilder;
import com.dataiku.lambda.model.api.PredictionQueryDispatch;
import com.dataiku.lambda.model.serverconfig.EndpointServerSideConfig;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServiceConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServiceGenTag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceManager {
    public static final int MIN_DSS_CONF_VERSION = 15;
    public APIError startAbortedReason;
    @Autowired
    private LambdaContext lambdaContext;
    @Autowired
    private DataLoadManager loadManager;
    @Autowired
    private IEndpointFactory endpointFactory;
    private Counter serviceActive;
    private String serviceId;
    private GenerationSelector generationSelector;
    private GenerationsMapping activeMapping;
    private Map<String, ServiceGeneration> loadedGenerations = new HashMap<String, ServiceGeneration>();
    ExecutorService executor = Executors.newSingleThreadExecutor();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.service.manager");

    public String getServiceId() {
        return this.serviceId;
    }

    public ServiceManager(String serviceId) {
        logger.info((Object)("Creating ServiceManager for " + serviceId));
        this.serviceId = serviceId;
        this.serviceActive = APINodeMetrics.serviceCounter(serviceId, "activeRequests");
    }

    public synchronized LambdaServiceConfig getConfig() {
        return this.loadedGenerations.values().iterator().next().sc.getConfig();
    }

    public synchronized LambdaServiceConfig getConfig(String generationId) throws IllegalArgumentException {
        ServiceGeneration generation = this.loadedGenerations.get(generationId);
        if (generation != null) {
            return generation.sc.getConfig();
        }
        throw new IllegalArgumentException("Generation " + generationId + " not found on service: " + this.serviceId);
    }

    public synchronized RefcountedEndpoint acquireEndpoint(String endpointId, PredictionQueryDispatch dispatch) {
        if (this.activeMapping == null || this.activeMapping.getEntries() == null || this.activeMapping.getEntries().isEmpty()) {
            throw new IllegalArgumentException("No generation is active on service " + this.serviceId);
        }
        String selectedGeneration = this.generationSelector.select(dispatch);
        logger.debug((Object)("Serving request with generation " + selectedGeneration));
        ServiceGeneration gen = this.loadedGenerations.get(selectedGeneration);
        if (gen == null) {
            throw ErrorContext.iaef((String)"Invalid selected generation: %s", (Object)selectedGeneration, (Object[])new Object[0]);
        }
        LambdaEndpointHandler<?> handler = gen.handlers.get(endpointId);
        if (handler == null) {
            throw new IllegalArgumentException("Endpoint does not exist: " + endpointId);
        }
        ++gen.activeQueries;
        this.serviceActive.inc();
        APINodeMetrics.serviceMeter(this.serviceId, "requestsPerGeneration." + selectedGeneration).mark();
        return new RefcountedEndpoint(gen, handler, this.activeMapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void releaseEndpoint(RefcountedEndpoint re) {
        ServiceGeneration gen = re.gen;
        boolean removeIt = false;
        ServiceManager serviceManager = this;
        synchronized (serviceManager) {
            logger.debug((Object)("Releasing on generation " + re.gen.generation));
            assert (this.loadedGenerations.containsKey(gen.generation));
            --gen.activeQueries;
            boolean generationIsInUse = this.isGenerationInUse(gen.generation);
            if (!generationIsInUse) {
                logger.info((Object)"This generation is not current anymore");
            }
            if (gen.activeQueries == 0 && !generationIsInUse) {
                logger.info((Object)("End of service on generation  " + gen.generation));
                this.loadedGenerations.remove(gen.generation);
                removeIt = true;
            }
        }
        this.serviceActive.dec();
        if (removeIt) {
            this.executor.submit(new UnmountTask(gen));
        }
    }

    public boolean isGenerationInUse(String generationId) {
        if (this.activeMapping != null) {
            for (GenerationsMapping.MappingEntry me : this.activeMapping.getEntries()) {
                if (!me.generation.equals(generationId)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasGenerationActiveQueries(String generationId) {
        if (!this.loadedGenerations.containsKey(generationId)) {
            return false;
        }
        ServiceGeneration sg = this.loadedGenerations.get(generationId);
        return sg.activeQueries > 0;
    }

    public void shutdown() {
        logger.infoV("Service shutting down (unloading %d generations)", new Object[]{this.loadedGenerations.size()});
        this.activeMapping = null;
        while (this.serviceActive.getCount() > 0L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
        ServiceGeneration[] gens = this.loadedGenerations.values().toArray(new ServiceGeneration[this.loadedGenerations.size()]);
        this.loadedGenerations.clear();
        for (ServiceGeneration gen : gens) {
            this.executor.submit(new UnmountTask(gen));
        }
        logger.info((Object)"Service shutdown complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mount(String generation, boolean forceRebuildCodeEnvs) throws Exception {
        ServiceManager serviceManager = this;
        synchronized (serviceManager) {
            assert (!this.loadedGenerations.containsKey(generation));
        }
        try (ErrorContext.ACNDC c1 = ErrorContext.pushWithNDC((String)("service:" + this.serviceId));
             ErrorContext.ACNDC c2 = ErrorContext.pushWithNDC((String)("gen:" + generation));){
            logger.info((Object)("Creating ServiceGeneration for " + this.serviceId));
            ServiceGeneration newGen = new ServiceGeneration(generation);
            File tagFile = new File(newGen.sc.getBaseFolder(), "tag.json");
            if (!tagFile.isFile()) {
                logger.warn((Object)"No tag file found, weird");
            } else {
                LambdaServiceGenTag tag = (LambdaServiceGenTag)JSON.parseFile((File)tagFile, LambdaServiceGenTag.class);
                logger.info((Object)("Verifying package version " + JSON.log((Object)tag)));
                if (tag.createdWithDSSConfVersion != null) {
                    Integer createdWithDSSConfVersion = Integer.parseInt(tag.createdWithDSSConfVersion);
                    if (createdWithDSSConfVersion < 15) {
                        logger.error((Object)"*****************************");
                        logger.error((Object)"This package was generated with a too old version of DSS");
                        logger.error((Object)("Generated:\n" + JSON.prettyLog((Object)tag)));
                        logger.error((Object)"Recommended: regenerate the package from DSS");
                        logger.error((Object)("Not recommended: If you are sure you want to move on, please edit " + tagFile.getAbsolutePath() + " and set \"createdWithDSSConfVersion\": \"15\""));
                        throw new ServiceStartAbortedException("Incompatible service generation " + this.serviceId + "/" + generation);
                    }
                } else {
                    logger.error((Object)"*****************************");
                    logger.error((Object)"This package was generated with an unknown version of DSS");
                    logger.error((Object)("Generated:\n" + JSON.prettyLog((Object)tag)));
                    logger.error((Object)"Recommended: regenerate the package from DSS");
                    logger.error((Object)("Not recommended: If you are sure you want to move on, please edit " + tagFile.getAbsolutePath() + " and set \"createdWithDSSConfVersion\": \"15\""));
                    throw new ServiceStartAbortedException("Incompatible service generation " + this.serviceId + "/" + generation);
                }
            }
            logger.info((Object)"Loading data resources");
            this.loadManager.loadServiceGeneration(this.serviceId, generation, newGen.sc.getBaseFolder(), newGen.sc.getConfig());
            logger.info((Object)"Loading code environments");
            if (ApplicationConfigurator.isDevLambdaServer()) {
                APINodeCodeEnvImporter.linkToHostNodeCodeEnvs(newGen.sc);
            }
            for (LambdaEndpointConfig endpointConfig : newGen.sc.getConfig().endpoints) {
                File rEnvDesc;
                File rEndpointCacheFolder;
                File pyEndpointCacheFolder;
                if (FeatureFlags.isEnabled((String)"apinode_codeenvs_global_cache")) {
                    pyEndpointCacheFolder = this.lambdaContext.getGlobalPythonCodeEnvFile();
                    rEndpointCacheFolder = this.lambdaContext.getGlobalRCodeEnvFile();
                } else {
                    pyEndpointCacheFolder = this.lambdaContext.getFile(new String[]{"code-envs-cache", this.serviceId, endpointConfig.id, "python"});
                    rEndpointCacheFolder = this.lambdaContext.getFile(new String[]{"code-envs-cache", this.serviceId, endpointConfig.id, "R"});
                }
                File pyEnvDesc = new File(newGen.sc.getBaseFolder(), "endpoint-" + endpointConfig.id + "/python-env-desc");
                if (pyEnvDesc.isDirectory()) {
                    File pythonEnvLive = DKUFileUtils.getWithin((File)newGen.sc.getBaseFolder(), (String[])new String[]{"endpoint-" + endpointConfig.id, "python-env-live"});
                    new APINodeCodeEnvImporter().importEnvIfNeeded(CodeEnvModel.EnvLang.PYTHON, this.serviceId, endpointConfig.id, pyEnvDesc, pythonEnvLive, pyEndpointCacheFolder, forceRebuildCodeEnvs);
                }
                if (!(rEnvDesc = new File(newGen.sc.getBaseFolder(), "endpoint-" + endpointConfig.id + "/R-env-desc")).isDirectory()) continue;
                File rEnvLive = DKUFileUtils.getWithin((File)newGen.sc.getBaseFolder(), (String[])new String[]{"endpoint-" + endpointConfig.id, "R-env-live"});
                new APINodeCodeEnvImporter().importEnvIfNeeded(CodeEnvModel.EnvLang.R, this.serviceId, endpointConfig.id, rEnvDesc, rEnvLive, rEndpointCacheFolder, forceRebuildCodeEnvs);
            }
            for (LambdaEndpointConfig endpointConfig : newGen.sc.getConfig().endpoints) {
                logger.info((Object)("Creating endpoint handler for " + endpointConfig.id));
                LambdaEndpointHandler<?> handler = this.endpointFactory.build(endpointConfig, newGen.sc);
                handler.init(newGen.sc);
                newGen.handlers.put(endpointConfig.id, handler);
            }
            ServiceManager serviceManager2 = this;
            synchronized (serviceManager2) {
                assert (!this.isMounted(newGen.generation));
                this.loadedGenerations.put(newGen.generation, newGen);
            }
        }
    }

    public synchronized boolean isMounted(String generationId) {
        return this.loadedGenerations.containsKey(generationId);
    }

    public synchronized Double getMapping(String generationId) {
        if (!this.isMounted(generationId)) {
            return null;
        }
        for (GenerationsMapping.MappingEntry e : this.activeMapping.getEntries()) {
            if (!e.generation.equals(generationId)) continue;
            return e.proba;
        }
        return null;
    }

    public synchronized GenerationsMapping getCurrentGenerationsMapping() {
        return (GenerationsMapping)JSON.deepCopy((Object)this.activeMapping);
    }

    public void mountIfNeeded(String generation, boolean forceRebuildCodeEnvs) throws Exception {
        if (this.isMounted(generation)) {
            return;
        }
        this.mount(generation, forceRebuildCodeEnvs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGenerationsMapping(GenerationsMapping mapping) {
        Validate.notNull((Object)mapping);
        logger.info((Object)("Starting switch to mapping: " + JSON.log((Object)mapping)));
        ArrayList<ServiceGeneration> generationsToUnmount = new ArrayList<ServiceGeneration>();
        ServiceManager serviceManager = this;
        synchronized (serviceManager) {
            ServiceGeneration gen2;
            for (GenerationsMapping.MappingEntry me : mapping.getEntries()) {
                assert (this.loadedGenerations.containsKey(me.generation));
            }
            this.activeMapping = mapping;
            this.generationSelector = GenerationSelectorFactory.build(mapping);
            for (ServiceGeneration gen2 : this.loadedGenerations.values()) {
                if (gen2.activeQueries != 0 || mapping.isUsed(gen2.generation)) continue;
                logger.info((Object)("Will close idle previous generation " + gen2.generation));
                generationsToUnmount.add(gen2);
            }
            for (ServiceGeneration gen2 : generationsToUnmount) {
                this.loadedGenerations.remove(gen2.generation);
            }
            String firstGeneration = ((GenerationsMapping.MappingEntry)mapping.getEntries().get((int)0)).generation;
            gen2 = this.loadedGenerations.get(firstGeneration);
            this.lambdaContext.setHealthChecksForService(this.serviceId, HealthChecksBuilder.buildForService(this.serviceId, gen2.sc.getConfig()));
        }
        for (ServiceGeneration gen : generationsToUnmount) {
            this.executor.submit(new UnmountTask(gen));
        }
        logger.info((Object)"Done switch to new mapping");
    }

    public boolean isActive() {
        return this.activeMapping != null && this.activeMapping.getEntries() != null && this.activeMapping.getEntries().size() > 0;
    }

    public void checkActive() {
        if (this.isActive()) {
            return;
        }
        if (this.startAbortedReason != null) {
            throw ErrorContext.iaef((String)"Service %s is not active: %s", (Object)this.serviceId, (Object[])new Object[]{this.startAbortedReason.detailedMessage});
        }
        throw ErrorContext.iaef((String)"Service %s is not active", (Object)this.serviceId, (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unmount(ServiceGeneration gen) {
        ServiceManager serviceManager = this;
        synchronized (serviceManager) {
            assert (!this.loadedGenerations.containsKey(gen.generation));
        }
        for (LambdaEndpointHandler lambdaEndpointHandler : gen.handlers.values()) {
            lambdaEndpointHandler.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadAndUnmap(String generationId) throws Exception {
        ServiceManager serviceManager = this;
        synchronized (serviceManager) {
            assert (!this.loadedGenerations.containsKey(generationId));
        }
        logger.infoV("Unloading generation %s", new Object[]{generationId});
        this.loadManager.unloadServiceGeneration(this.serviceId, generationId);
    }

    public synchronized void setNotAlive() throws IOException {
        logger.info((Object)"Setting service as not-alive");
        DKUFileUtils.createIfNotExists((File)this.lambdaContext.getFile(new String[]{"service-not-alive-" + this.serviceId + ".txt"}));
    }

    public synchronized void setAlive() throws IOException {
        logger.info((Object)"Setting service as alive");
        File f = this.lambdaContext.getFile(new String[]{"service-not-alive-" + this.serviceId + ".txt"});
        if (f.isFile()) {
            DKUFileUtils.forceDelete((File)f);
        }
    }

    public String getNotAliveSimpleReason() {
        if (this.activeMapping == null) {
            return "This service is disabled";
        }
        if (this.activeMapping.getEntries().isEmpty()) {
            return "This service has no active generation";
        }
        File f = this.lambdaContext.getFile(new String[]{"service-not-alive-" + this.serviceId + ".txt"});
        if (f.isFile()) {
            return "This service is forced as not-alive";
        }
        return null;
    }

    private class ServiceGeneration {
        private Map<String, LambdaEndpointHandler<?>> handlers = new HashMap();
        private ServiceGenContext sc;
        private String generation;
        private int activeQueries;

        public ServiceGeneration(String generation) throws IOException {
            this.generation = generation;
            this.sc = new ServiceGenContext(ServiceManager.this.serviceId, generation, ServiceManager.this.lambdaContext.getFile(new String[]{"services", ServiceManager.this.serviceId, "gens", generation}));
            for (LambdaEndpointConfig endpointConfig : this.sc.getConfig().endpoints) {
                this.sc.setServerEndpointConfig(endpointConfig.id, ServiceManager.this.lambdaContext.getMandatoryConfig().endpointDefaults);
                File epServerConfig = ServiceManager.this.lambdaContext.getFile(new String[]{"config/services", ServiceManager.this.serviceId, endpointConfig.id + ".json"});
                if (!epServerConfig.isFile() || !epServerConfig.canRead()) continue;
                try {
                    this.sc.setServerEndpointConfig(endpointConfig.id, (EndpointServerSideConfig)JSON.parseFile((File)epServerConfig, EndpointServerSideConfig.class));
                }
                catch (Exception e) {
                    logger.warn((Object)("Couldn't parse endpoint config file, will fall back to server default: " + epServerConfig.getAbsolutePath()), (Throwable)e);
                }
            }
        }
    }

    public static class RefcountedEndpoint {
        private final ServiceGeneration gen;
        private final LambdaEndpointHandler<?> handler;
        private final GenerationsMapping activeMapping;

        RefcountedEndpoint(ServiceGeneration gen, LambdaEndpointHandler<?> handler, GenerationsMapping activeMapping) {
            this.gen = gen;
            this.handler = handler;
            this.activeMapping = activeMapping;
        }

        public LambdaEndpointHandler<?> getHandler() {
            return this.handler;
        }

        public GenerationsMapping getActiveMapping() {
            return this.activeMapping;
        }
    }

    class UnmountTask
    implements Runnable {
        private ServiceGeneration generation;

        UnmountTask(ServiceGeneration generation) {
            this.generation = generation;
        }

        @Override
        public void run() {
            logger.infoV("Starting actual unmount of " + String.valueOf(this.generation), new Object[0]);
            try {
                ServiceManager.this.unmount(this.generation);
            }
            catch (Throwable e) {
                logger.warn((Object)"Unmount failed", e);
            }
        }
    }

    public static class ServiceStartAbortedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        ServiceStartAbortedException(String message) {
            super(message);
        }

        ServiceStartAbortedException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

