/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.time_series.TimeSeriesDatapoint;
import com.dataiku.gh.core.services.time_series.ITimeSeriesService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.security.auth.MetaAuthService;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PublicAPITimeSeriesController
extends PublicAPIControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private ITimeSeriesService timeSeriesService;

    @AuditedCall(value={"msgType", "time-series-get", "timeSeriesId", "${timeSeriesId}", "timestampMin", "${timestampMin}", "timestampMax", "${timestampMax}"})
    @RequestMapping(value={"/publicapi/time-series/{timeSeriesId}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String timeSeriesId, @RequestParam(required=false) Long timestampMin, @RequestParam(required=false) Long timestampMax) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        PublicAPITimeSeriesController.writeJSON((HttpServletResponse)resp, this.timeSeriesService.get(authCtx, timeSeriesId, timestampMin, timestampMax));
    }

    @AuditedCall(value={"msgType", "time-series-delete", "timeSeriesId", "${timeSeriesId}", "timestampMin", "${timestampMin}", "timestampMax", "${timestampMax}"})
    @RequestMapping(value={"/publicapi/time-series/{timeSeriesId}"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.TIMESERIES_DELETE)
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String timeSeriesId, @RequestParam(required=false) Long timestampMin, @RequestParam(required=false) Long timestampMax) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        this.timeSeriesService.delete(authCtx, timeSeriesId, timestampMin, timestampMax);
        PublicAPITimeSeriesController.writeEmptyJSONObj((HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "time-series-create"})
    @RequestMapping(value={"/publicapi/time-series"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.TIMESERIES_CREATE)
    public void create(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        Set datapoints = (Set)this.getRequestBodyAsOrNull(req, (TypeToken)new TypeToken<Set<TimeSeriesDatapoint>>(){});
        String idCreated = this.timeSeriesService.create(authCtx, Optional.ofNullable(datapoints).orElse(Sets.newHashSet()));
        PublicAPITimeSeriesController.writeJSON((HttpServletResponse)resp, (Object)JSON.kv((String)"id", (Object)idCreated).get());
    }

    @AuditedCall(value={"msgType", "time-series-push", "timeSeriesId", "${timeSeriesId}"})
    @RequestMapping(value={"/publicapi/time-series/{timeSeriesId}"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.TIMESERIES_PUSH)
    public void push(HttpServletRequest req, HttpServletResponse resp, @PathVariable String timeSeriesId, @RequestParam(required=false) Boolean upsert) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        Set datapoints = (Set)this.getRequestBodyAs(req, (TypeToken)new TypeToken<Set<TimeSeriesDatapoint>>(){});
        datapoints.forEach(dp -> {
            if (!StringUtils.equals((CharSequence)dp.timeSeriesId, (CharSequence)timeSeriesId)) {
                throw new ValidationException("Time-series IDs do not match: " + timeSeriesId + ", " + dp.timeSeriesId);
            }
        });
        this.timeSeriesService.push(authCtx, datapoints, upsert == null || upsert != false);
        PublicAPITimeSeriesController.writeEmptyJSONObj((HttpServletResponse)resp);
    }
}

