/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.uploaded_files.UploadedFile;
import com.dataiku.gh.core.models.uploaded_files.UploadedFileDesc;
import com.dataiku.gh.core.services.uploaded_files.IUploadedFilesService;
import com.dataiku.gh.security.auth.MetaAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class PublicAPIUploadedFilesController
extends PublicAPIControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IUploadedFilesService uploadedFilesService;

    @AuditedCall(value={"msgType", "uploaded-file-get-desc", "uploadedFileId", "${uploadedFileId}"})
    @RequestMapping(value={"/publicapi/uploaded-file/{uploadedFileId}"}, method={RequestMethod.GET})
    public void getFileDesc(HttpServletRequest req, HttpServletResponse resp, @PathVariable String uploadedFileId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        PublicAPIUploadedFilesController.writeJSON((HttpServletResponse)resp, (Object)this.uploadedFilesService.getUploadedFileDesc(authCtx, uploadedFileId));
    }

    @AuditedCall(value={"msgType", "uploaded-file-get", "uploadedFileId", "${uploadedFileId}"})
    @RequestMapping(value={"/publicapi/uploaded-file/{uploadedFileId}/download"}, method={RequestMethod.GET})
    public void getFile(HttpServletRequest req, HttpServletResponse resp, @PathVariable String uploadedFileId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        UploadedFile file = this.uploadedFilesService.getUploadedFile(authCtx, uploadedFileId);
        this.writeStream(resp, file.data, file.desc.type, file.desc.name);
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/uploaded-files"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.UPLOADED_FILE_UPLOAD)
    public void uploadFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam MultipartFile file) throws Exception {
        try {
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            UploadedFileDesc uploadedFileDesc = this.uploadedFilesService.uploadFile(authCtx, file.getOriginalFilename(), file.getInputStream(), file.getSize());
            this.auditTrailService.generic("uploaded-file-upload").with("uploadedFileId", uploadedFileDesc.id).emit();
            PublicAPIUploadedFilesController.writeJSON((HttpServletResponse)resp, (Object)uploadedFileDesc);
        }
        catch (Exception e) {
            this.auditTrailService.failure("uploaded-file-upload", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "uploaded-file-delete", "uploadedFileId", "${uploadedFileId}"})
    @RequestMapping(value={"/publicapi/uploaded-file/{uploadedFileId}"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.UPLOADED_FILE_DELETE)
    public void deleteFile(HttpServletRequest req, HttpServletResponse resp, @PathVariable String uploadedFileId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        this.uploadedFilesService.deleteUploadedFile(authCtx, uploadedFileId);
        PublicAPIUploadedFilesController.writeEmptyJSONObj((HttpServletResponse)resp);
    }
}

