/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.user_config;

import com.dataiku.gh.core.models.user_config.UserConfiguration;
import com.dataiku.gh.core.services.user_config.IUserConfigurationDataService;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.storage.user_config.IUserConfigurationDAO;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class UserConfigurationDataService
implements IUserConfigurationDataService {
    @Autowired
    private IUserConfigurationDAO userConfigurationDAO;

    @Override
    @GHMandatoryTransaction
    @Nullable
    public UserConfiguration getUserConfigurationOrNull(String userConfId) throws IOException {
        return (UserConfiguration)this.userConfigurationDAO.getOrNull(userConfId);
    }

    @Override
    @GHMandatoryTransaction
    public UserConfiguration upsertUserConfiguration(UserConfiguration userConf) throws IOException {
        this.lockUserConfiguration(userConf.userIdentifier);
        if (!this.userConfigurationDAO.exists(userConf.userIdentifier)) {
            this.userConfigurationDAO.create(userConf);
        } else {
            this.userConfigurationDAO.save(userConf);
        }
        return (UserConfiguration)this.userConfigurationDAO.getMandatory(userConf.userIdentifier);
    }

    @Override
    @GHMandatoryTransaction
    public void deleteUserConfiguration(String userConfId) throws IOException {
        this.userConfigurationDAO.lock(userConfId);
        this.userConfigurationDAO.delete(userConfId);
    }

    @Override
    @GHMandatoryTransaction
    public void deleteUserConfigurationIfExists(String userConfId) throws IOException {
        this.userConfigurationDAO.lock(userConfId);
        if (this.userConfigurationDAO.exists(userConfId)) {
            this.userConfigurationDAO.delete(userConfId);
        }
    }

    @Override
    public void removeCustomPageId(String pageId) throws IOException {
        List<UserConfiguration> lockedConfigWithPageId = this.userConfigurationDAO.getAndLockConfigWithPageId(pageId);
        for (UserConfiguration uc : lockedConfigWithPageId) {
            uc.pages.remove(pageId);
            this.userConfigurationDAO.save(uc);
        }
    }

    @Override
    public void lockUserConfiguration(String userConfId) throws IOException {
        this.userConfigurationDAO.lock(userConfId);
    }
}

