/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation;

import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPath;
import com.dataiku.gh.core.services.validation.IBlueprintVersionMigrationPathValidationService;
import com.dataiku.gh.core.services.validation.errors.MissingReferenceException;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.blueprints.IBlueprintVersionDAO;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.core.utils.ValidatorUtils;
import java.io.IOException;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlueprintVersionMigrationPathValidationService
implements IBlueprintVersionMigrationPathValidationService {
    @Autowired
    private IBlueprintVersionDAO blueprintVersionDAO;

    @Override
    public void validateMigrationPath(BlueprintVersionMigrationPath migrationPath) throws IOException {
        ValidatorUtils.validateThat(migrationPath.id != null, "blueprintVersionMigrationPath.id is required", new Object[0]);
        ValidatorUtils.validateThat(IdentifiersUtils.isValidBlueprintVersionMigrationPathId(migrationPath.id), "Invalid migration path ID: " + migrationPath.id, new Object[0]);
        ValidatorUtils.validateThat(migrationPath.blueprintVersionIdTo != null, "Target blueprint version ID is required", new Object[0]);
        ValidatorUtils.validateThat(migrationPath.blueprintVersionIdFrom != null, "Source blueprint version ID is required", new Object[0]);
        this.validateBlueprintVersionId(migrationPath.blueprintVersionIdTo);
        this.validateBlueprintVersionId(migrationPath.blueprintVersionIdFrom);
        try {
            ValidatorUtils.validateThat(this.blueprintVersionDAO.exists(migrationPath.blueprintVersionIdFrom), "Source blueprint version target does not exists", new Object[0]);
            ValidatorUtils.validateThat(this.blueprintVersionDAO.exists(migrationPath.blueprintVersionIdTo), "Target blueprint version target does not exists", new Object[0]);
        }
        catch (ValidationException e) {
            throw new MissingReferenceException(e.getMessage(), e);
        }
        ValidatorUtils.validateThat(Objects.equals(migrationPath.blueprintVersionIdTo.blueprintId, migrationPath.blueprintVersionIdFrom.blueprintId), "Cannot create a migration path between different blueprints", new Object[0]);
    }

    private void validateBlueprintVersionId(BlueprintVersionId blueprintVersionId) {
        ValidatorUtils.validateThat(IdentifiersUtils.isValidBlueprintVersionId(blueprintVersionId.versionId), "Invalid referenced blueprint version ID: " + blueprintVersionId.versionId, new Object[0]);
        ValidatorUtils.validateThat(IdentifiersUtils.isValidBlueprintId(blueprintVersionId.blueprintId), "Invalid referenced blueprint ID: " + blueprintVersionId.blueprintId, new Object[0]);
    }
}

