/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.exceptions.InvalidConfigurationValueException;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.FieldMetadata;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ColumnMapping {
    public static final String COLUMN_MAPPING_MODE_KEY = "delta.columnMapping.mode";
    public static final String COLUMN_MAPPING_PHYSICAL_NAME_KEY = "delta.columnMapping.physicalName";
    public static final String COLUMN_MAPPING_ID_KEY = "delta.columnMapping.id";
    public static final String COLUMN_MAPPING_NESTED_IDS_KEY = "delta.columnMapping.nested.ids";
    public static final String PARQUET_FIELD_ID_KEY = "parquet.field.id";
    public static final String PARQUET_FIELD_NESTED_IDS_METADATA_KEY = "parquet.field.nested.ids";
    public static final String COLUMN_MAPPING_MAX_COLUMN_ID_KEY = "delta.columnMapping.maxColumnId";

    private ColumnMapping() {
    }

    public static ColumnMappingMode getColumnMappingMode(Map<String, String> map) {
        return Optional.ofNullable(map.get(COLUMN_MAPPING_MODE_KEY)).map(ColumnMappingMode::fromTableConfig).orElse(ColumnMappingMode.NONE);
    }

    public static void throwOnUnsupportedColumnMappingMode(Metadata metadata) {
        ColumnMapping.getColumnMappingMode(metadata.getConfiguration());
    }

    public static StructType convertToPhysicalSchema(StructType structType, StructType structType2, ColumnMappingMode columnMappingMode) {
        switch (columnMappingMode) {
            case NONE: {
                return structType;
            }
            case ID: 
            case NAME: {
                boolean bl = columnMappingMode == ColumnMappingMode.ID;
                return ColumnMapping.convertToPhysicalSchema(structType, structType2, bl);
            }
        }
        throw new UnsupportedOperationException("Unsupported column mapping mode: " + (Object)((Object)columnMappingMode));
    }

    public static String getPhysicalName(StructField structField) {
        if (ColumnMapping.hasPhysicalName(structField)) {
            return structField.getMetadata().getString(COLUMN_MAPPING_PHYSICAL_NAME_KEY);
        }
        return structField.getName();
    }

    public static void verifyColumnMappingChange(Map<String, String> map, Map<String, String> map2, boolean bl) {
        ColumnMappingMode columnMappingMode = ColumnMapping.getColumnMappingMode(map);
        ColumnMappingMode columnMappingMode2 = ColumnMapping.getColumnMappingMode(map2);
        Preconditions.checkArgument(bl || ColumnMapping.validModeChange(columnMappingMode, columnMappingMode2), "Changing column mapping mode from '%s' to '%s' is not supported", new Object[]{columnMappingMode, columnMappingMode2});
    }

    public static boolean isColumnMappingModeEnabled(ColumnMappingMode columnMappingMode) {
        return columnMappingMode == ColumnMappingMode.ID || columnMappingMode == ColumnMappingMode.NAME;
    }

    public static Metadata updateColumnMappingMetadata(Metadata metadata, ColumnMappingMode columnMappingMode, boolean bl) {
        switch (columnMappingMode) {
            case NONE: {
                return metadata;
            }
            case ID: 
            case NAME: {
                return ColumnMapping.assignColumnIdAndPhysicalName(metadata, bl);
            }
        }
        throw new UnsupportedOperationException("Unsupported column mapping mode: " + (Object)((Object)columnMappingMode));
    }

    static int findMaxColumnId(StructType structType) {
        int n = 0;
        for (StructField structField : structType.fields()) {
            n = ColumnMapping.findMaxColumnId(structField, n);
        }
        return n;
    }

    private static int findMaxColumnId(StructField structField, int n) {
        if (ColumnMapping.hasColumnId(structField)) {
            n = Math.max(n, ColumnMapping.getColumnId(structField));
            if (ColumnMapping.hasNestedColumnIds(structField)) {
                n = Math.max(n, ColumnMapping.getMaxNestedColumnId(structField));
            }
        }
        if (structField.getDataType() instanceof StructType) {
            StructType structType = (StructType)structField.getDataType();
            for (StructField structField2 : structType.fields()) {
                n = ColumnMapping.findMaxColumnId(structField2, n);
            }
            return n;
        }
        if (structField.getDataType() instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)structField.getDataType();
            return ColumnMapping.findMaxColumnId(arrayType.getElementField(), n);
        }
        if (structField.getDataType() instanceof MapType) {
            MapType mapType = (MapType)structField.getDataType();
            return Math.max(ColumnMapping.findMaxColumnId(mapType.getKeyField(), n), ColumnMapping.findMaxColumnId(mapType.getValueField(), n));
        }
        return n;
    }

    private static StructType convertToPhysicalSchema(StructType structType, StructType structType2, boolean bl) {
        StructType structType3 = new StructType();
        for (StructField structField : structType.fields()) {
            DataType dataType = structField.getDataType();
            StructField structField2 = structType2.get(structField.getName());
            DataType dataType2 = ColumnMapping.convertToPhysicalType(dataType, structField2.getDataType(), bl);
            String string = structField2.getMetadata().getString(COLUMN_MAPPING_PHYSICAL_NAME_KEY);
            if (bl) {
                Long l = structField2.getMetadata().getLong(COLUMN_MAPPING_ID_KEY);
                FieldMetadata.Builder builder = FieldMetadata.builder().putLong(PARQUET_FIELD_ID_KEY, l);
                if (ColumnMapping.hasNestedColumnIds(structField2)) {
                    builder.putFieldMetadata(PARQUET_FIELD_NESTED_IDS_METADATA_KEY, ColumnMapping.getNestedColumnIds(structField2));
                }
                structType3 = structType3.add(string, dataType2, structField.isNullable(), builder.build());
                continue;
            }
            structType3 = structType3.add(string, dataType2, structField.isNullable());
        }
        return structType3;
    }

    private static DataType convertToPhysicalType(DataType dataType, DataType dataType2, boolean bl) {
        if (dataType instanceof StructType) {
            return ColumnMapping.convertToPhysicalSchema((StructType)dataType, (StructType)dataType2, bl);
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            return new ArrayType(ColumnMapping.convertToPhysicalType(arrayType.getElementType(), ((ArrayType)dataType2).getElementType(), bl), arrayType.containsNull());
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            MapType mapType2 = (MapType)dataType2;
            return new MapType(ColumnMapping.convertToPhysicalType(mapType.getKeyType(), mapType2.getKeyType(), bl), ColumnMapping.convertToPhysicalType(mapType.getValueType(), mapType2.getValueType(), bl), mapType.isValueContainsNull());
        }
        return dataType;
    }

    private static boolean validModeChange(ColumnMappingMode columnMappingMode, ColumnMappingMode columnMappingMode2) {
        return columnMappingMode.equals((Object)columnMappingMode2) || columnMappingMode == ColumnMappingMode.NONE && columnMappingMode2 == ColumnMappingMode.NAME;
    }

    private static Metadata assignColumnIdAndPhysicalName(Metadata metadata, boolean bl) {
        StructType structType = metadata.getSchema();
        AtomicInteger atomicInteger = new AtomicInteger(Math.max(Integer.parseInt(metadata.getConfiguration().getOrDefault(COLUMN_MAPPING_MAX_COLUMN_ID_KEY, "0")), ColumnMapping.findMaxColumnId(structType)));
        StructType structType2 = new StructType();
        for (StructField structField : structType.fields()) {
            structType2 = structType2.add(ColumnMapping.transformAndAssignColumnIdAndPhysicalName(ColumnMapping.assignColumnIdAndPhysicalNameToField(structField, atomicInteger, bl), atomicInteger, bl));
        }
        if (Boolean.parseBoolean(metadata.getConfiguration().getOrDefault(TableConfig.ICEBERG_COMPAT_V2_ENABLED.getKey(), "false"))) {
            structType2 = ColumnMapping.rewriteFieldIdsForIceberg(structType2, atomicInteger);
        }
        HashMap hashMap = new HashMap();
        hashMap.put(COLUMN_MAPPING_MAX_COLUMN_ID_KEY, Integer.toString(atomicInteger.get()));
        return metadata.withNewSchema(structType2).withNewConfiguration(hashMap);
    }

    private static StructField transformAndAssignColumnIdAndPhysicalName(StructField structField, AtomicInteger atomicInteger, boolean bl) {
        DataType dataType = structField.getDataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructType structType2 = new StructType();
            for (StructField structField2 : structType.fields()) {
                structType2 = structType2.add(ColumnMapping.transformAndAssignColumnIdAndPhysicalName(ColumnMapping.assignColumnIdAndPhysicalNameToField(structField2, atomicInteger, bl), atomicInteger, bl));
            }
            return new StructField(structField.getName(), structType2, structField.isNullable(), structField.getMetadata());
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            StructField structField3 = ColumnMapping.transformAndAssignColumnIdAndPhysicalName(arrayType.getElementField(), atomicInteger, bl);
            return new StructField(structField.getName(), new ArrayType(structField3), structField.isNullable(), structField.getMetadata());
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            StructField structField4 = ColumnMapping.transformAndAssignColumnIdAndPhysicalName(mapType.getKeyField(), atomicInteger, bl);
            StructField structField5 = ColumnMapping.transformAndAssignColumnIdAndPhysicalName(mapType.getValueField(), atomicInteger, bl);
            return new StructField(structField.getName(), new MapType(structField4, structField5), structField.isNullable(), structField.getMetadata());
        }
        return structField;
    }

    private static StructField assignColumnIdAndPhysicalNameToField(StructField structField, AtomicInteger atomicInteger, boolean bl) {
        if (!ColumnMapping.hasColumnId(structField)) {
            structField = structField.withNewMetadata(FieldMetadata.builder().fromMetadata(structField.getMetadata()).putLong(COLUMN_MAPPING_ID_KEY, atomicInteger.incrementAndGet()).build());
        }
        if (!ColumnMapping.hasPhysicalName(structField)) {
            String string = bl ? "col-" + UUID.randomUUID() : structField.getName();
            structField = structField.withNewMetadata(FieldMetadata.builder().fromMetadata(structField.getMetadata()).putString(COLUMN_MAPPING_PHYSICAL_NAME_KEY, string).build());
        }
        return structField;
    }

    private static boolean hasColumnId(StructField structField) {
        return structField.getMetadata().contains(COLUMN_MAPPING_ID_KEY);
    }

    private static boolean hasPhysicalName(StructField structField) {
        return structField.getMetadata().contains(COLUMN_MAPPING_PHYSICAL_NAME_KEY);
    }

    private static int getColumnId(StructField structField) {
        return structField.getMetadata().getLong(COLUMN_MAPPING_ID_KEY).intValue();
    }

    private static boolean hasNestedColumnIds(StructField structField) {
        return structField.getMetadata().contains(COLUMN_MAPPING_NESTED_IDS_KEY);
    }

    private static FieldMetadata getNestedColumnIds(StructField structField) {
        return structField.getMetadata().getMetadata(COLUMN_MAPPING_NESTED_IDS_KEY);
    }

    private static int getMaxNestedColumnId(StructField structField) {
        return ColumnMapping.getNestedColumnIds(structField).getEntries().values().stream().filter(Long.class::isInstance).map(Long.class::cast).max(Comparator.naturalOrder()).orElse(0L).intValue();
    }

    private static StructType rewriteFieldIdsForIceberg(StructType structType, AtomicInteger atomicInteger) {
        StructType structType2 = new StructType();
        for (StructField structField : structType.fields()) {
            structType2 = structType2.add(ColumnMapping.transformSchema(atomicInteger, structField, ""));
        }
        return structType2;
    }

    private static StructField transformSchema(AtomicInteger atomicInteger, StructField structField2, String string) {
        DataType dataType = structField2.getDataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            List<StructField> list = structType.fields().stream().map(structField -> ColumnMapping.transformSchema(atomicInteger, structField, ColumnMapping.getPhysicalName(structField))).collect(Collectors.toList());
            return new StructField(structField2.getName(), new StructType(list), structField2.isNullable(), structField2.getMetadata());
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            String string2 = "".equals(string) ? ColumnMapping.getPhysicalName(structField2) : string;
            String string3 = string2 + "." + arrayType.getElementField().getName();
            structField2 = ColumnMapping.maybeUpdateFieldId(structField2, string3, atomicInteger);
            StructField structField3 = ColumnMapping.transformSchema(atomicInteger, arrayType.getElementField(), string3);
            return new StructField(structField2.getName(), new ArrayType(structField3), structField2.isNullable(), structField2.getMetadata());
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            String string4 = "".equals(string) ? ColumnMapping.getPhysicalName(structField2) : string;
            String string5 = string4 + "." + mapType.getKeyField().getName();
            structField2 = ColumnMapping.maybeUpdateFieldId(structField2, string5, atomicInteger);
            StructField structField4 = ColumnMapping.transformSchema(atomicInteger, mapType.getKeyField(), string5);
            String string6 = string4 + "." + mapType.getValueField().getName();
            structField2 = ColumnMapping.maybeUpdateFieldId(structField2, string6, atomicInteger);
            StructField structField5 = ColumnMapping.transformSchema(atomicInteger, mapType.getValueField(), string6);
            return new StructField(structField2.getName(), new MapType(structField4, structField5), structField2.isNullable(), structField2.getMetadata());
        }
        return structField2;
    }

    private static StructField maybeUpdateFieldId(StructField structField, String string, AtomicInteger atomicInteger) {
        FieldMetadata fieldMetadata;
        Object object;
        if (!structField.getMetadata().contains(COLUMN_MAPPING_NESTED_IDS_KEY)) {
            object = ColumnMapping.initNestedIdsMetadataBuilder(structField);
            fieldMetadata = FieldMetadata.builder().fromMetadata(structField.getMetadata()).putFieldMetadata(COLUMN_MAPPING_NESTED_IDS_KEY, ((FieldMetadata.Builder)object).build()).build();
            structField = structField.withNewMetadata(fieldMetadata);
        }
        if (!((FieldMetadata)(object = structField.getMetadata().getMetadata(COLUMN_MAPPING_NESTED_IDS_KEY))).contains(string)) {
            fieldMetadata = FieldMetadata.builder().fromMetadata((FieldMetadata)object).putLong(string, atomicInteger.incrementAndGet()).build();
            return structField.withNewMetadata(FieldMetadata.builder().fromMetadata(structField.getMetadata()).putFieldMetadata(COLUMN_MAPPING_NESTED_IDS_KEY, fieldMetadata).build());
        }
        return structField;
    }

    private static FieldMetadata.Builder initNestedIdsMetadataBuilder(StructField structField) {
        if (ColumnMapping.hasNestedColumnIds(structField)) {
            return FieldMetadata.builder().fromMetadata(ColumnMapping.getNestedColumnIds(structField));
        }
        return FieldMetadata.builder();
    }

    public static enum ColumnMappingMode {
        NONE("none"),
        ID("id"),
        NAME("name");

        public final String value;

        private ColumnMappingMode(String string2) {
            this.value = string2;
        }

        public static ColumnMappingMode fromTableConfig(String string) {
            for (ColumnMappingMode columnMappingMode : ColumnMappingMode.values()) {
                if (!columnMappingMode.value.equalsIgnoreCase(string)) continue;
                return columnMappingMode;
            }
            throw new InvalidConfigurationValueException(ColumnMapping.COLUMN_MAPPING_MODE_KEY, string, String.format("Needs to be one of: %s.", Arrays.toString((Object[])ColumnMappingMode.values())));
        }

        public String toString() {
            return this.value;
        }
    }
}

