/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.jose.crypto;

import com.dataiku.dss.shadelib.com.google.crypto.tink.subtle.Ed25519Sign;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JOSEException;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWSAlgorithm;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWSHeader;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWSSigner;
import com.dataiku.dss.shadelib.com.nimbusds.jose.crypto.impl.EdDSAProvider;
import com.dataiku.dss.shadelib.com.nimbusds.jose.jwk.Curve;
import com.dataiku.dss.shadelib.com.nimbusds.jose.jwk.OctetKeyPair;
import com.dataiku.dss.shadelib.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import com.dataiku.dss.shadelib.com.nimbusds.jose.util.Base64URL;
import java.security.GeneralSecurityException;

@ThreadSafe
public class Ed25519Signer
extends EdDSAProvider
implements JWSSigner {
    private final OctetKeyPair privateKey;
    private final Ed25519Sign tinkSigner;

    public Ed25519Signer(OctetKeyPair privateKey) throws JOSEException {
        if (!Curve.Ed25519.equals(privateKey.getCurve())) {
            throw new JOSEException("Ed25519Signer only supports OctetKeyPairs with crv=Ed25519");
        }
        if (!privateKey.isPrivate()) {
            throw new JOSEException("The OctetKeyPair doesn't contain a private part");
        }
        this.privateKey = privateKey;
        try {
            this.tinkSigner = new Ed25519Sign(privateKey.getDecodedD());
        }
        catch (GeneralSecurityException e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public OctetKeyPair getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Base64URL sign(JWSHeader header, byte[] signingInput) throws JOSEException {
        byte[] jwsSignature;
        JWSAlgorithm alg = header.getAlgorithm();
        if (!JWSAlgorithm.Ed25519.equals(alg) && !JWSAlgorithm.EdDSA.equals(alg)) {
            throw new JOSEException("Ed25519Verifier requires alg=Ed25519 or alg=EdDSA in JWSHeader");
        }
        try {
            jwsSignature = this.tinkSigner.sign(signingInput);
        }
        catch (GeneralSecurityException e) {
            throw new JOSEException(e.getMessage(), e);
        }
        return Base64URL.encode(jwsSignature);
    }
}

