/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.AllManifestsTable;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpecParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.SchemaParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.ExpressionParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIOParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.PartitionUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;

class AllManifestsTableTaskParser {
    private static final String DATA_TABLE_SCHEMA = "data-table-schema";
    private static final String FILE_IO = "file-io";
    private static final String SCHEMA = "schema";
    private static final String SPECS = "partition-specs";
    private static final String MANIFEST_LIST_LOCATION = "manifest-list-Location";
    private static final String RESIDUAL = "residual-filter";
    private static final String REFERENCE_SNAPSHOT_ID = "reference-snapshot-id";

    private AllManifestsTableTaskParser() {
    }

    static void toJson(AllManifestsTable.ManifestListReadTask task, JsonGenerator generator) throws IOException {
        Preconditions.checkArgument(task != null, "Invalid manifest task: null");
        Preconditions.checkArgument(generator != null, "Invalid JSON generator: null");
        generator.writeFieldName(DATA_TABLE_SCHEMA);
        SchemaParser.toJson(task.dataTableSchema(), generator);
        generator.writeFieldName(FILE_IO);
        FileIOParser.toJson(task.io(), generator);
        generator.writeFieldName(SCHEMA);
        SchemaParser.toJson(task.schema(), generator);
        generator.writeArrayFieldStart(SPECS);
        for (PartitionSpec spec : task.specsById().values()) {
            PartitionSpecParser.toJson(spec, generator);
        }
        generator.writeEndArray();
        generator.writeStringField(MANIFEST_LIST_LOCATION, task.manifestListLocation());
        generator.writeFieldName(RESIDUAL);
        ExpressionParser.toJson(task.residual(), generator);
        generator.writeNumberField(REFERENCE_SNAPSHOT_ID, task.referenceSnapshotId());
    }

    static AllManifestsTable.ManifestListReadTask fromJson(JsonNode jsonNode) {
        Preconditions.checkArgument(jsonNode != null, "Invalid JSON node for manifest task: null");
        Preconditions.checkArgument(jsonNode.isObject(), "Invalid JSON node for manifest task: non-object (%s)", (Object)jsonNode);
        Schema dataTableSchema = SchemaParser.fromJson(JsonUtil.get(DATA_TABLE_SCHEMA, jsonNode));
        FileIO fileIO = FileIOParser.fromJson(JsonUtil.get(FILE_IO, jsonNode), null);
        Schema schema = SchemaParser.fromJson(JsonUtil.get(SCHEMA, jsonNode));
        JsonNode specsArray = JsonUtil.get(SPECS, jsonNode);
        Preconditions.checkArgument(specsArray.isArray(), "Invalid JSON node for partition specs: non-array (%s)", (Object)specsArray);
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        for (JsonNode specNode : specsArray) {
            PartitionSpec spec = PartitionSpecParser.fromJson(dataTableSchema, specNode);
            specsBuilder.add(spec);
        }
        Map<Integer, PartitionSpec> specsById = PartitionUtil.indexSpecs((List<PartitionSpec>)((Object)specsBuilder.build()));
        String manifestListLocation = JsonUtil.getString(MANIFEST_LIST_LOCATION, jsonNode);
        Expression residualFilter = ExpressionParser.fromJson(JsonUtil.get(RESIDUAL, jsonNode));
        long referenceSnapshotId = JsonUtil.getLong(REFERENCE_SNAPSHOT_ID, jsonNode);
        return new AllManifestsTable.ManifestListReadTask(dataTableSchema, fileIO, schema, specsById, manifestListLocation, residualFilter, referenceSnapshotId);
    }
}

