/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.BaseFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.ContentFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.ContentScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.FixedSizeSplitScanTaskIterator;
import com.dataiku.dss.shadelib.org.apache.iceberg.OffsetsAwareSplitScanTaskIterator;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpecParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.SchemaParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.SplittableScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.ResidualEvaluator;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ArrayUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ScanTaskUtil;

abstract class BaseContentScanTask<ThisT extends ContentScanTask<F>, F extends ContentFile<F>>
implements ContentScanTask<F>,
SplittableScanTask<ThisT> {
    private final F file;
    private final String schemaString;
    private final String specString;
    private final ResidualEvaluator residuals;
    private volatile transient Schema schema = null;
    private volatile transient PartitionSpec spec = null;

    BaseContentScanTask(F file, String schemaString, String specString, ResidualEvaluator residuals) {
        this.file = file;
        this.schemaString = schemaString;
        this.specString = specString;
        this.residuals = residuals;
    }

    protected abstract ThisT self();

    protected abstract ThisT newSplitTask(ThisT var1, long var2, long var4);

    @Override
    public F file() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Schema schema() {
        if (this.schema == null) {
            BaseContentScanTask baseContentScanTask = this;
            synchronized (baseContentScanTask) {
                if (this.schema == null) {
                    this.schema = SchemaParser.fromJson(this.schemaString);
                }
            }
        }
        return this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionSpec spec() {
        if (this.spec == null) {
            BaseContentScanTask baseContentScanTask = this;
            synchronized (baseContentScanTask) {
                if (this.spec == null) {
                    this.spec = PartitionSpecParser.fromJson(this.schema(), this.specString);
                }
            }
        }
        return this.spec;
    }

    @Override
    public long start() {
        return 0L;
    }

    @Override
    public long length() {
        return ScanTaskUtil.contentSizeInBytes(this.file);
    }

    @Override
    public Expression residual() {
        return this.residuals.residualFor(this.file.partition());
    }

    @Override
    public long estimatedRowsCount() {
        return BaseContentScanTask.estimateRowsCount(this.length(), this.file);
    }

    @Override
    public Iterable<ThisT> split(long targetSplitSize) {
        if (this.file.format().isSplittable()) {
            long[] splitOffsets = BaseContentScanTask.splitOffsets(this.file);
            if (splitOffsets != null && ArrayUtil.isStrictlyAscending(splitOffsets)) {
                return () -> new OffsetsAwareSplitScanTaskIterator<ContentScanTask>((ContentScanTask)this.self(), this.length(), splitOffsets, this::newSplitTask);
            }
            return () -> new FixedSizeSplitScanTaskIterator<ContentScanTask>((ContentScanTask)this.self(), this.length(), targetSplitSize, this::newSplitTask);
        }
        return ImmutableList.of(this.self());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("file", this.file().location()).add("partition_data", this.file().partition()).add("residual", this.residual()).toString();
    }

    static long estimateRowsCount(long length, ContentFile<?> file) {
        long[] splitOffsets = BaseContentScanTask.splitOffsets(file);
        long splitOffset = splitOffsets != null ? splitOffsets[0] : 0L;
        double scannedFileFraction = (double)length / (double)(file.fileSizeInBytes() - splitOffset);
        return (long)(scannedFileFraction * (double)file.recordCount());
    }

    private static long[] splitOffsets(ContentFile<?> file) {
        if (file instanceof BaseFile) {
            return ((BaseFile)file).splitOffsetArray();
        }
        return ArrayUtil.toLongArray(file.splitOffsets());
    }
}

