/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.BaseContentScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.MergeableScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.ScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.ResidualEvaluator;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ScanTaskUtil;
import java.util.List;

public class BaseFileScanTask
extends BaseContentScanTask<FileScanTask, DataFile>
implements FileScanTask {
    private final DeleteFile[] deletes;
    private volatile transient List<DeleteFile> deleteList = null;
    private volatile transient long deletesSizeBytes = 0L;

    public BaseFileScanTask(DataFile file, DeleteFile[] deletes, String schemaString, String specString, ResidualEvaluator residuals) {
        super(file, schemaString, specString, residuals);
        this.deletes = deletes != null ? deletes : new DeleteFile[]{};
    }

    @Override
    protected FileScanTask self() {
        return this;
    }

    @Override
    protected FileScanTask newSplitTask(FileScanTask parentTask, long offset, long length) {
        return new SplitScanTask(offset, length, parentTask, this.deletesSizeBytes());
    }

    @Override
    public List<DeleteFile> deletes() {
        if (this.deleteList == null) {
            this.deleteList = ImmutableList.copyOf(this.deletes);
        }
        return this.deleteList;
    }

    @Override
    public long sizeBytes() {
        return this.length() + this.deletesSizeBytes();
    }

    @Override
    public int filesCount() {
        return 1 + this.deletes.length;
    }

    @Override
    public Schema schema() {
        return super.schema();
    }

    private long deletesSizeBytes() {
        if (this.deletesSizeBytes == 0L && this.deletes.length > 0) {
            long size = 0L;
            for (DeleteFile deleteFile : this.deletes) {
                size += ScanTaskUtil.contentSizeInBytes(deleteFile);
            }
            this.deletesSizeBytes = size;
        }
        return this.deletesSizeBytes;
    }

    @VisibleForTesting
    static final class SplitScanTask
    implements FileScanTask,
    MergeableScanTask<SplitScanTask> {
        private final long len;
        private final long offset;
        private final FileScanTask fileScanTask;
        private volatile transient long deletesSizeBytes = 0L;

        SplitScanTask(long offset, long len, FileScanTask fileScanTask) {
            this.offset = offset;
            this.len = len;
            this.fileScanTask = fileScanTask;
        }

        SplitScanTask(long offset, long len, FileScanTask fileScanTask, long deletesSizeBytes) {
            this.offset = offset;
            this.len = len;
            this.fileScanTask = fileScanTask;
            this.deletesSizeBytes = deletesSizeBytes;
        }

        @Override
        public DataFile file() {
            return (DataFile)this.fileScanTask.file();
        }

        @Override
        public List<DeleteFile> deletes() {
            return this.fileScanTask.deletes();
        }

        @Override
        public Schema schema() {
            return this.fileScanTask.schema();
        }

        @Override
        public PartitionSpec spec() {
            return this.fileScanTask.spec();
        }

        @Override
        public long start() {
            return this.offset;
        }

        @Override
        public long length() {
            return this.len;
        }

        @Override
        public long estimatedRowsCount() {
            return BaseContentScanTask.estimateRowsCount(this.len, this.fileScanTask.file());
        }

        @Override
        public long sizeBytes() {
            return this.len + this.deletesSizeBytes();
        }

        @Override
        public int filesCount() {
            return this.fileScanTask.filesCount();
        }

        @Override
        public Expression residual() {
            return this.fileScanTask.residual();
        }

        @Override
        public Iterable<FileScanTask> split(long splitSize) {
            throw new UnsupportedOperationException("Cannot split a task which is already split");
        }

        @Override
        public boolean canMerge(ScanTask other) {
            if (other instanceof SplitScanTask) {
                SplitScanTask that = (SplitScanTask)other;
                return this.file().equals(that.file()) && this.offset + this.len == that.start();
            }
            return false;
        }

        @Override
        public SplitScanTask merge(ScanTask other) {
            SplitScanTask that = (SplitScanTask)other;
            return new SplitScanTask(this.offset, this.len + that.length(), this.fileScanTask, this.deletesSizeBytes);
        }

        private long deletesSizeBytes() {
            if (this.deletesSizeBytes == 0L && this.fileScanTask.filesCount() > 1) {
                this.deletesSizeBytes = ScanTaskUtil.contentSizeInBytes(this.fileScanTask.deletes());
            }
            return this.deletesSizeBytes;
        }
    }
}

