/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.BaseTableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.IncrementalDataTableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestGroup;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScanContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import java.util.List;

public class DataTableScan
extends BaseTableScan {
    protected DataTableScan(Table table, Schema schema, TableScanContext context) {
        super(table, schema, context);
    }

    @Override
    public TableScan appendsBetween(long fromSnapshotId, long toSnapshotId) {
        Preconditions.checkState(this.snapshotId() == null, "Cannot enable incremental scan, scan-snapshot set to id=%s", (Object)this.snapshotId());
        return new IncrementalDataTableScan(this.table(), this.schema(), this.context().fromSnapshotIdExclusive(fromSnapshotId).toSnapshotId(toSnapshotId));
    }

    @Override
    public TableScan appendsAfter(long fromSnapshotId) {
        Snapshot currentSnapshot = this.table().currentSnapshot();
        Preconditions.checkState(currentSnapshot != null, "Cannot scan appends after %s, there is no current snapshot", fromSnapshotId);
        return this.appendsBetween(fromSnapshotId, currentSnapshot.snapshotId());
    }

    @Override
    protected boolean useSnapshotSchema() {
        return true;
    }

    @Override
    protected TableScan newRefinedScan(Table table, Schema schema, TableScanContext context) {
        return new DataTableScan(table, schema, context);
    }

    @Override
    public CloseableIterable<FileScanTask> doPlanFiles() {
        Snapshot snapshot = this.snapshot();
        FileIO io = this.table().io();
        List<ManifestFile> dataManifests = snapshot.dataManifests(io);
        List<ManifestFile> deleteManifests = snapshot.deleteManifests(io);
        this.scanMetrics().totalDataManifests().increment((long)dataManifests.size());
        this.scanMetrics().totalDeleteManifests().increment((long)deleteManifests.size());
        ManifestGroup manifestGroup = new ManifestGroup(io, dataManifests, deleteManifests).caseSensitive(this.isCaseSensitive()).select(this.scanColumns()).filterData(this.filter()).specsById(this.table().specs()).scanMetrics(this.scanMetrics()).ignoreDeleted().columnsToKeepStats(this.columnsToKeepStats());
        if (this.shouldIgnoreResiduals()) {
            manifestGroup = manifestGroup.ignoreResiduals();
        }
        if (this.shouldPlanWithExecutor() && (dataManifests.size() > 1 || deleteManifests.size() > 1)) {
            manifestGroup = manifestGroup.planWith(this.planExecutor());
        }
        return manifestGroup.planFiles();
    }
}

