/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.BlobMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class GenericBlobMetadata
implements BlobMetadata {
    private final String type;
    private final long sourceSnapshotId;
    private final long sourceSnapshotSequenceNumber;
    private final List<Integer> fields;
    private final Map<String, String> properties;

    public static BlobMetadata from(com.dataiku.dss.shadelib.org.apache.iceberg.puffin.BlobMetadata puffinMetadata) {
        return new GenericBlobMetadata(puffinMetadata.type(), puffinMetadata.snapshotId(), puffinMetadata.sequenceNumber(), puffinMetadata.inputFields(), puffinMetadata.properties());
    }

    public static List<BlobMetadata> from(Collection<com.dataiku.dss.shadelib.org.apache.iceberg.puffin.BlobMetadata> puffinMetadataList) {
        return puffinMetadataList.stream().map(GenericBlobMetadata::from).collect(ImmutableList.toImmutableList());
    }

    public GenericBlobMetadata(String type, long sourceSnapshotId, long sourceSnapshotSequenceNumber, List<Integer> fields, Map<String, String> properties) {
        Preconditions.checkNotNull(type, "type is null");
        Preconditions.checkNotNull(fields, "fields is null");
        Preconditions.checkNotNull(properties, "properties is null");
        this.type = type;
        this.sourceSnapshotId = sourceSnapshotId;
        this.sourceSnapshotSequenceNumber = sourceSnapshotSequenceNumber;
        this.fields = ImmutableList.copyOf(fields);
        this.properties = ImmutableMap.copyOf(properties);
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public long sourceSnapshotId() {
        return this.sourceSnapshotId;
    }

    @Override
    public long sourceSnapshotSequenceNumber() {
        return this.sourceSnapshotSequenceNumber;
    }

    @Override
    public List<Integer> fields() {
        return this.fields;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericBlobMetadata that = (GenericBlobMetadata)o;
        return this.sourceSnapshotId == that.sourceSnapshotId && this.sourceSnapshotSequenceNumber == that.sourceSnapshotSequenceNumber && Objects.equals(this.type, that.type) && Objects.equals(this.fields, that.fields) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.sourceSnapshotId, this.sourceSnapshotSequenceNumber, this.fields, this.properties);
    }

    public String toString() {
        return new StringJoiner(", ", GenericBlobMetadata.class.getSimpleName() + "[", "]").add("type='" + this.type + "'").add("sourceSnapshotId=" + this.sourceSnapshotId).add("sourceSnapshotSequenceNumber=" + this.sourceSnapshotSequenceNumber).add("fields=" + String.valueOf(this.fields)).add("properties=" + String.valueOf(this.properties)).toString();
    }
}

