/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructTransform;
import java.util.List;
import java.util.stream.Collectors;

public class PartitionKey
extends StructTransform {
    private final PartitionSpec spec;
    private final Schema inputSchema;

    public PartitionKey(PartitionSpec spec, Schema inputSchema) {
        super(inputSchema, PartitionKey.fieldTransform(spec));
        this.spec = spec;
        this.inputSchema = inputSchema;
    }

    private PartitionKey(PartitionKey toCopy) {
        super(toCopy);
        this.spec = toCopy.spec;
        this.inputSchema = toCopy.inputSchema;
    }

    public PartitionKey copy() {
        return new PartitionKey(this);
    }

    public String toPath() {
        return this.spec.partitionToPath(this);
    }

    public void partition(StructLike row) {
        this.wrap(row);
    }

    private static List<StructTransform.FieldTransform> fieldTransform(PartitionSpec spec) {
        return spec.fields().stream().map(partitionField -> new StructTransform.FieldTransform(partitionField.sourceId(), partitionField.transform())).collect(Collectors.toList());
    }
}

