/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.BaseMetadataTable;
import com.dataiku.dss.shadelib.org.apache.iceberg.BasePositionDeletesScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.BatchScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileContent;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestEntry;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataColumns;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataTableType;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpecParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.Partitioning;
import com.dataiku.dss.shadelib.org.apache.iceberg.ScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.ScanTaskGroup;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.SchemaParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.SnapshotScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScanContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expressions;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.ManifestEvaluator;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Projections;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.ResidualEvaluator;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterator;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableCollection;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.TypeUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ParallelIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.TableScanUtil;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PositionDeletesTable
extends BaseMetadataTable {
    public static final String PARTITION = "partition";
    public static final String SPEC_ID = "spec_id";
    public static final String DELETE_FILE_PATH = "delete_file_path";
    public static final String CONTENT_OFFSET = "content_offset";
    public static final String CONTENT_SIZE_IN_BYTES = "content_size_in_bytes";
    private final Schema schema = this.calculateSchema();
    private final int defaultSpecId;
    private final Map<Integer, PartitionSpec> specs;

    PositionDeletesTable(Table table) {
        this(table, table.name() + ".position_deletes");
    }

    PositionDeletesTable(Table table, String name) {
        super(table, name);
        this.defaultSpecId = table.spec().specId();
        this.specs = PositionDeletesTable.transformSpecs(this.schema(), table.specs());
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.POSITION_DELETES;
    }

    @Override
    public TableScan newScan() {
        throw new UnsupportedOperationException("Cannot create TableScan from table of type POSITION_DELETES");
    }

    @Override
    public BatchScan newBatchScan() {
        return new PositionDeletesBatchScan(this.table(), this.schema());
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public PartitionSpec spec() {
        return this.specs.get(this.defaultSpecId);
    }

    @Override
    public Map<Integer, PartitionSpec> specs() {
        return this.specs;
    }

    @Override
    public Map<String, String> properties() {
        return Collections.unmodifiableMap(this.table().properties().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("write.")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private Schema calculateSchema() {
        int formatVersion = TableUtil.formatVersion(this.table());
        Types.StructType partitionType = Partitioning.partitionType(this.table());
        ImmutableCollection.Builder builder = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(MetadataColumns.DELETE_FILE_PATH)).add(MetadataColumns.DELETE_FILE_POS)).add(Types.NestedField.optional(2147483544, "row", this.table().schema().asStruct(), "Deleted row values"))).add(Types.NestedField.required(0x7FFFFFFA, PARTITION, partitionType, "Partition that position delete row belongs to"))).add(Types.NestedField.required(0x7FFFFFFB, SPEC_ID, Types.IntegerType.get(), "Spec ID used to track the file containing a row"))).add(Types.NestedField.required(0x7FFFFFFE, DELETE_FILE_PATH, Types.StringType.get(), "Path of the file in which a row is stored"));
        if (formatVersion >= 3) {
            ((ImmutableList.Builder)((ImmutableList.Builder)builder).add(Types.NestedField.optional(0x7FFFFFF9, CONTENT_OFFSET, Types.LongType.get(), "The offset in the DV where the content starts"))).add(Types.NestedField.optional(0x7FFFFFF8, CONTENT_SIZE_IN_BYTES, Types.LongType.get(), "The length in bytes of the DV blob"));
        }
        ImmutableCollection columns = ((ImmutableList.Builder)builder).build();
        Set<Integer> currentlyUsedIds = Collections.unmodifiableSet(TypeUtil.indexById(Types.StructType.of((List<Types.NestedField>)((Object)columns))).keySet());
        Set allUsedIds = this.table().schemas().values().stream().map(currSchema -> TypeUtil.indexById(currSchema.asStruct()).keySet()).reduce(currentlyUsedIds, Sets::union);
        Set idsToReassign = partitionType.fields().stream().map(Types.NestedField::fieldId).collect(Collectors.toSet());
        AtomicInteger nextId = new AtomicInteger();
        Schema result = new Schema((List<Types.NestedField>)((Object)columns), ImmutableSet.of(), oldId -> {
            if (!idsToReassign.contains(oldId)) {
                return oldId;
            }
            int candidate = nextId.incrementAndGet();
            while (allUsedIds.contains(candidate)) {
                candidate = nextId.incrementAndGet();
            }
            return candidate;
        });
        if (!partitionType.fields().isEmpty()) {
            return result;
        }
        return TypeUtil.selectNot(result, Sets.newHashSet(0x7FFFFFFA));
    }

    public static class PositionDeletesBatchScan
    extends SnapshotScan<BatchScan, ScanTask, ScanTaskGroup<ScanTask>>
    implements BatchScan {
        private Expression baseTableFilter = Expressions.alwaysTrue();

        protected PositionDeletesBatchScan(Table table, Schema schema) {
            super(table, schema, TableScanContext.empty());
        }

        protected PositionDeletesBatchScan(Table table, Schema schema, TableScanContext context, Expression baseTableFilter) {
            super(table, schema, context);
            this.baseTableFilter = baseTableFilter;
        }

        @Override
        protected PositionDeletesBatchScan newRefinedScan(Table newTable, Schema newSchema, TableScanContext newContext) {
            return new PositionDeletesBatchScan(newTable, newSchema, newContext, this.baseTableFilter);
        }

        @Override
        public CloseableIterable<ScanTaskGroup<ScanTask>> planTasks() {
            return TableScanUtil.planTaskGroups(this.planFiles(), this.targetSplitSize(), this.splitLookback(), this.splitOpenFileCost());
        }

        @Override
        protected List<String> scanColumns() {
            return this.context().returnColumnStats() ? DELETE_SCAN_WITH_STATS_COLUMNS : DELETE_SCAN_COLUMNS;
        }

        public BatchScan baseTableFilter(Expression expr) {
            return new PositionDeletesBatchScan(this.table(), this.schema(), this.context(), Expressions.and(this.baseTableFilter, expr));
        }

        @Override
        protected CloseableIterable<ScanTask> doPlanFiles() {
            String schemaString = SchemaParser.toJson(this.tableSchema());
            Map<Integer, PartitionSpec> transformedSpecs = BaseMetadataTable.transformSpecs(this.tableSchema(), this.table().specs());
            LoadingCache<Integer, String> specStringCache = this.partitionCacheOf(transformedSpecs, PartitionSpecParser::toJson);
            LoadingCache<Integer, ManifestEvaluator> deletesTableEvalCache = this.partitionCacheOf(transformedSpecs, spec -> ManifestEvaluator.forRowFilter(this.filter(), spec, this.isCaseSensitive()));
            LoadingCache<Integer, ManifestEvaluator> baseTableEvalCache = this.partitionCacheOf(this.table().specs(), spec -> ManifestEvaluator.forRowFilter(this.baseTableFilter, spec, this.isCaseSensitive()));
            LoadingCache<Integer, ResidualEvaluator> residualCache = this.partitionCacheOf(transformedSpecs, spec -> ResidualEvaluator.of(spec, this.shouldIgnoreResiduals() ? Expressions.alwaysTrue() : this.filter(), this.isCaseSensitive()));
            List<ManifestFile> manifests = this.snapshot().deleteManifests(this.table().io());
            CloseableIterable<ManifestFile> matchingManifests = CloseableIterable.filter(this.scanMetrics().skippedDeleteManifests(), CloseableIterable.withNoopClose(manifests), manifest -> ((ManifestEvaluator)baseTableEvalCache.get((Object)manifest.partitionSpecId())).eval((ManifestFile)manifest) && ((ManifestEvaluator)deletesTableEvalCache.get((Object)manifest.partitionSpecId())).eval((ManifestFile)manifest));
            matchingManifests = CloseableIterable.count(this.scanMetrics().scannedDeleteManifests(), matchingManifests);
            CloseableIterable tasks = CloseableIterable.transform(matchingManifests, manifest -> this.posDeletesScanTasks((ManifestFile)manifest, this.table().specs().get(manifest.partitionSpecId()), schemaString, transformedSpecs, residualCache, specStringCache));
            if (this.planExecutor() != null) {
                return new ParallelIterable<ScanTask>(tasks, this.planExecutor());
            }
            return CloseableIterable.concat(tasks);
        }

        private CloseableIterable<ScanTask> posDeletesScanTasks(final ManifestFile manifest, final PartitionSpec spec, final String schemaString, final Map<Integer, PartitionSpec> transformedSpecs, final LoadingCache<Integer, ResidualEvaluator> residualCache, final LoadingCache<Integer, String> specStringCache) {
            return new CloseableIterable<ScanTask>(){
                private CloseableIterable<ScanTask> iterable;

                @Override
                public void close() throws IOException {
                    if (this.iterable != null) {
                        this.iterable.close();
                    }
                }

                @Override
                public CloseableIterator<ScanTask> iterator() {
                    Expression partitionFilter = Projections.inclusive(spec, this.isCaseSensitive()).project(baseTableFilter);
                    CloseableIterable<ManifestEntry<DeleteFile>> deleteFileEntries = ManifestFiles.readDeleteManifest(manifest, this.table().io(), transformedSpecs).caseSensitive(this.isCaseSensitive()).select(this.scanColumns()).filterRows(this.filter()).filterPartitions(partitionFilter).scanMetrics(this.scanMetrics()).liveEntries();
                    CloseableIterable<ManifestEntry> positionDeleteEntries = CloseableIterable.filter(deleteFileEntries, entry -> ((DeleteFile)entry.file()).content().equals((Object)FileContent.POSITION_DELETES));
                    this.iterable = CloseableIterable.transform(positionDeleteEntries, entry -> {
                        int specId = ((DeleteFile)entry.file()).specId();
                        return new BasePositionDeletesScanTask((DeleteFile)((DeleteFile)entry.file()).copy(this.context().returnColumnStats()), schemaString, (String)specStringCache.get((Object)specId), (ResidualEvaluator)residualCache.get((Object)specId));
                    });
                    return this.iterable.iterator();
                }
            };
        }

        private <T> LoadingCache<Integer, T> partitionCacheOf(Map<Integer, PartitionSpec> specs, Function<PartitionSpec, T> constructor) {
            return Caffeine.newBuilder().build(specId -> {
                PartitionSpec spec = (PartitionSpec)specs.get(specId);
                return constructor.apply(spec);
            });
        }
    }
}

