/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.actions;

import com.dataiku.dss.shadelib.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.dataiku.dss.shadelib.javax.annotation.CheckReturnValue;
import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.dss.shadelib.javax.annotation.ParametersAreNonnullByDefault;
import com.dataiku.dss.shadelib.javax.annotation.concurrent.Immutable;
import com.dataiku.dss.shadelib.javax.annotation.concurrent.NotThreadSafe;
import com.dataiku.dss.shadelib.org.apache.iceberg.actions.BaseRewriteTablePath;
import com.dataiku.dss.shadelib.org.apache.iceberg.actions.RewriteTablePath;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BaseRewriteTablePath", generator="Immutables")
public final class ImmutableRewriteTablePath {
    private ImmutableRewriteTablePath() {
    }

    @CheckReturnValue
    @Generated(from="BaseRewriteTablePath.Result", generator="Immutables")
    @Immutable
    public static final class Result
    implements BaseRewriteTablePath.Result {
        private final String stagingLocation;
        private final String fileListLocation;
        private final String latestVersion;

        private Result(String stagingLocation, String fileListLocation, String latestVersion) {
            this.stagingLocation = stagingLocation;
            this.fileListLocation = fileListLocation;
            this.latestVersion = latestVersion;
        }

        @Override
        public String stagingLocation() {
            return this.stagingLocation;
        }

        @Override
        public String fileListLocation() {
            return this.fileListLocation;
        }

        @Override
        public String latestVersion() {
            return this.latestVersion;
        }

        public final Result withStagingLocation(String value) {
            String newValue = Objects.requireNonNull(value, "stagingLocation");
            if (this.stagingLocation.equals(newValue)) {
                return this;
            }
            return new Result(newValue, this.fileListLocation, this.latestVersion);
        }

        public final Result withFileListLocation(String value) {
            String newValue = Objects.requireNonNull(value, "fileListLocation");
            if (this.fileListLocation.equals(newValue)) {
                return this;
            }
            return new Result(this.stagingLocation, newValue, this.latestVersion);
        }

        public final Result withLatestVersion(String value) {
            String newValue = Objects.requireNonNull(value, "latestVersion");
            if (this.latestVersion.equals(newValue)) {
                return this;
            }
            return new Result(this.stagingLocation, this.fileListLocation, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Result && this.equalsByValue((Result)another);
        }

        private boolean equalsByValue(Result another) {
            return this.stagingLocation.equals(another.stagingLocation) && this.fileListLocation.equals(another.fileListLocation) && this.latestVersion.equals(another.latestVersion);
        }

        public int hashCode() {
            int h2 = 5381;
            h2 += (h2 << 5) + this.stagingLocation.hashCode();
            h2 += (h2 << 5) + this.fileListLocation.hashCode();
            h2 += (h2 << 5) + this.latestVersion.hashCode();
            return h2;
        }

        public String toString() {
            return "Result{stagingLocation=" + this.stagingLocation + ", fileListLocation=" + this.fileListLocation + ", latestVersion=" + this.latestVersion + "}";
        }

        public static Result copyOf(BaseRewriteTablePath.Result instance) {
            if (instance instanceof Result) {
                return (Result)instance;
            }
            return Result.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="BaseRewriteTablePath.Result", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_STAGING_LOCATION = 1L;
            private static final long INIT_BIT_FILE_LIST_LOCATION = 2L;
            private static final long INIT_BIT_LATEST_VERSION = 4L;
            private long initBits = 7L;
            @Nullable
            private String stagingLocation;
            @Nullable
            private String fileListLocation;
            @Nullable
            private String latestVersion;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(BaseRewriteTablePath.Result instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(RewriteTablePath.Result instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                RewriteTablePath.Result instance;
                long bits = 0L;
                if (object instanceof BaseRewriteTablePath.Result) {
                    instance = (BaseRewriteTablePath.Result)object;
                    if ((bits & 1L) == 0L) {
                        this.stagingLocation(instance.stagingLocation());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.latestVersion(instance.latestVersion());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.fileListLocation(instance.fileListLocation());
                        bits |= 4L;
                    }
                }
                if (object instanceof RewriteTablePath.Result) {
                    instance = (RewriteTablePath.Result)object;
                    if ((bits & 1L) == 0L) {
                        this.stagingLocation(instance.stagingLocation());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.latestVersion(instance.latestVersion());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.fileListLocation(instance.fileListLocation());
                        bits |= 4L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder stagingLocation(String stagingLocation) {
                this.stagingLocation = Objects.requireNonNull(stagingLocation, "stagingLocation");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder fileListLocation(String fileListLocation) {
                this.fileListLocation = Objects.requireNonNull(fileListLocation, "fileListLocation");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder latestVersion(String latestVersion) {
                this.latestVersion = Objects.requireNonNull(latestVersion, "latestVersion");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public Result build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Result(this.stagingLocation, this.fileListLocation, this.latestVersion);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("stagingLocation");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("fileListLocation");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("latestVersion");
                }
                return "Cannot build Result, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }
}

