/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.actions;

import com.dataiku.dss.shadelib.org.apache.iceberg.ContentScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.RewriteJobOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.actions.ImmutableRewriteDataFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.actions.RewriteDataFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.actions.RewriteGroupBase;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ContentFileUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.DataFileSet;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.DeleteFileSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class RewriteFileGroup
extends RewriteGroupBase<RewriteDataFiles.FileGroupInfo, FileScanTask, DataFile> {
    private final int outputSpecId;
    private DataFileSet addedFiles = DataFileSet.create();

    public RewriteFileGroup(RewriteDataFiles.FileGroupInfo info, List<FileScanTask> fileScanTasks, int outputSpecId, long writeMaxFileSize, long inputSplitSize, int expectedOutputFiles) {
        super(info, fileScanTasks, writeMaxFileSize, inputSplitSize, expectedOutputFiles);
        this.outputSpecId = outputSpecId;
    }

    public void setOutputFiles(Set<DataFile> files) {
        this.addedFiles = DataFileSet.of(files);
    }

    public Set<DataFile> rewrittenFiles() {
        return this.fileScanTasks().stream().map(ContentScanTask::file).collect(Collectors.toCollection(DataFileSet::create));
    }

    public Set<DeleteFile> danglingDVs() {
        return this.fileScanTasks().stream().flatMap(task -> task.deletes().stream().filter(ContentFileUtil::isDV)).collect(Collectors.toCollection(DeleteFileSet::create));
    }

    public Set<DataFile> addedFiles() {
        return this.addedFiles;
    }

    public RewriteDataFiles.FileGroupRewriteResult asResult() {
        Preconditions.checkState(this.addedFiles != null, "Cannot get result, Group was never rewritten");
        return ImmutableRewriteDataFiles.FileGroupRewriteResult.builder().info((RewriteDataFiles.FileGroupInfo)this.info()).addedDataFilesCount(this.addedFiles.size()).rewrittenDataFilesCount(this.fileScanTasks().size()).rewrittenBytesCount(this.inputFilesSizeInBytes()).removedDeleteFilesCount(this.danglingDVs().size()).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("info", this.info()).add("numRewrittenFiles", this.fileScanTasks().size()).add("numAddedFiles", this.addedFiles == null ? "Rewrite Incomplete" : Integer.toString(this.addedFiles.size())).add("numRewrittenBytes", this.inputFilesSizeInBytes()).add("maxOutputFileSize", this.maxOutputFileSize()).add("inputSplitSize", this.inputSplitSize()).add("expectedOutputFiles", this.expectedOutputFiles()).add("outputSpecId", this.outputSpecId).toString();
    }

    public int outputSpecId() {
        return this.outputSpecId;
    }

    public static Comparator<RewriteFileGroup> comparator(RewriteJobOrder rewriteJobOrder) {
        switch (rewriteJobOrder) {
            case BYTES_ASC: {
                return Comparator.comparing(RewriteGroupBase::inputFilesSizeInBytes);
            }
            case BYTES_DESC: {
                return Comparator.comparing(RewriteGroupBase::inputFilesSizeInBytes, Comparator.reverseOrder());
            }
            case FILES_ASC: {
                return Comparator.comparing(RewriteGroupBase::inputFileNum);
            }
            case FILES_DESC: {
                return Comparator.comparing(RewriteGroupBase::inputFileNum, Comparator.reverseOrder());
            }
        }
        return (unused, unused2) -> 0;
    }
}

