/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.catalog;

import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataUpdate;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateRequirement;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateRequirements;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.ImmutableTableCommit;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifier;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import java.util.List;
import org.immutables.value.Value;

@Value.Immutable
public interface TableCommit {
    public TableIdentifier identifier();

    public List<UpdateRequirement> requirements();

    public List<MetadataUpdate> updates();

    public static TableCommit create(TableIdentifier identifier, TableMetadata base, TableMetadata updated) {
        Preconditions.checkArgument(null != identifier, "Invalid table identifier: null");
        Preconditions.checkArgument(null != base && null != updated, "Invalid table metadata: null");
        Preconditions.checkArgument(base.uuid().equals(updated.uuid()), "UUID of base (%s) and updated (%s) table metadata does not match", (Object)base.uuid(), (Object)updated.uuid());
        return ImmutableTableCommit.builder().identifier(identifier).requirements(UpdateRequirements.forUpdateTable(base, updated.changes())).updates(updated.changes()).build();
    }
}

