/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.data;

import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.Record;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.TableScanIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import java.util.Collection;

public class IcebergGenerics {
    private IcebergGenerics() {
    }

    public static ScanBuilder read(Table table) {
        return new ScanBuilder(table);
    }

    public static class ScanBuilder {
        private TableScan tableScan;
        private boolean reuseContainers = false;

        public ScanBuilder(Table table) {
            this.tableScan = table.newScan();
        }

        public ScanBuilder reuseContainers() {
            this.reuseContainers = true;
            return this;
        }

        public ScanBuilder where(Expression rowFilter) {
            this.tableScan = (TableScan)this.tableScan.filter(rowFilter);
            return this;
        }

        public ScanBuilder caseInsensitive() {
            this.tableScan = (TableScan)this.tableScan.caseSensitive(false);
            return this;
        }

        public ScanBuilder select(String ... selectedColumns) {
            this.tableScan = (TableScan)this.tableScan.select(selectedColumns);
            return this;
        }

        public ScanBuilder select(Collection<String> columns) {
            this.tableScan = (TableScan)this.tableScan.select(columns);
            return this;
        }

        public ScanBuilder project(Schema schema) {
            this.tableScan = (TableScan)this.tableScan.project(schema);
            return this;
        }

        public ScanBuilder useSnapshot(long scanSnapshotId) {
            this.tableScan = this.tableScan.useSnapshot(scanSnapshotId);
            return this;
        }

        public ScanBuilder asOfTime(long scanTimestampMillis) {
            this.tableScan = this.tableScan.asOfTime(scanTimestampMillis);
            return this;
        }

        public ScanBuilder appendsBetween(long fromSnapshotId, long toSnapshotId) {
            this.tableScan = this.tableScan.appendsBetween(fromSnapshotId, toSnapshotId);
            return this;
        }

        public ScanBuilder appendsAfter(long fromSnapshotId) {
            this.tableScan = this.tableScan.appendsAfter(fromSnapshotId);
            return this;
        }

        public CloseableIterable<Record> build() {
            return new TableScanIterable(this.tableScan, this.reuseContainers);
        }
    }
}

